#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs
ACTUAL_DARCS=`which $DARCS`
DARCSPATH=`dirname $ACTUAL_DARCS`
export PATH="$DARCSPATH:$PATH"
echo $PATH

export EMAIL=tester

rm -rf temp temp_0
mkdir temp
cd temp
$DARCS init
date > bla
$DARCS add bla
$DARCS record -a --patch-name=1
echo hello > world
$DARCS add world
$DARCS whatsnew --dont-look-for-adds > wn1
cd ..
$DARCS get temp
cd temp_0
date > bla2
date >> bla
$DARCS add bla2
$DARCS record -a --patch-name=2
$DARCS push -a ../temp
cd ..
cd temp
$DARCS whatsnew --dont-look-for-adds > wn2
diff wn1 wn2

$DARCS record -a -m 'cleaning up for new test.'
date > foo.jpg
$DARCS add foo.jpg
$DARCS whatsnew

$DARCS remove foo.jpg
(! $DARCS whatsnew) || exit 1

cd ..

rm -rf temp*
