// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CVisitor_h__
#define __CVisitor_h__

// Iterate through a C++ syntax tree

namespace Puma {


class CTree;

class CVisitor {
  bool _aborted;
  bool _pruned;

  void visit_sons (CTree *node);

public:
  CVisitor () : _aborted (false), _pruned (false) {}
  virtual ~CVisitor () {}

  void abort (bool v = true) { _aborted = v; }
  void prune (bool v = true) { _pruned = v; }
  bool aborted () const { return _aborted; }
  bool pruned () const { return _pruned; }
  
  void visit (CTree *node);

  virtual void pre_visit (CTree *node);
  virtual void post_visit (CTree *node);
};


} // namespace Puma

#endif /* __CVisitor_h__ */
