// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeList_h__
#define __CTypeList_h__

#include "Puma/Array.h"

namespace Puma {


class CTypeInfo;
class CT_ArgDeclList;

class CTypeList {
  Array<CTypeInfo*> _List;
  CT_ArgDeclList *_ArgumentList;

public:
  CTypeList (int len = 3);
  ~CTypeList ();

  unsigned Entries () const;
  CTypeInfo *Entry (unsigned) const;
  void ReplaceEntry (unsigned, CTypeInfo *);
  
  CT_ArgDeclList *ArgumentList () const;
  void ArgumentList (CT_ArgDeclList *);
  
  void AddEntry (CTypeInfo *);
  
  bool isDependent () const;
};

inline CTypeList::CTypeList (int len) :
  _List (len),
  _ArgumentList ((CT_ArgDeclList*)0)
 {}
inline CTypeList::~CTypeList ()
 {}

inline CT_ArgDeclList *CTypeList::ArgumentList () const
 { return _ArgumentList; }
inline void CTypeList::ArgumentList (CT_ArgDeclList *al)
 { _ArgumentList = al; }

inline unsigned CTypeList::Entries () const
 { return _List.length (); }
inline CTypeInfo *CTypeList::Entry (unsigned i) const
 { return _List.lookup (i); }
 
inline void CTypeList::AddEntry (CTypeInfo *info) 
 { if (info) _List.append (info); }
inline void CTypeList::ReplaceEntry (unsigned i, CTypeInfo *info)
 { if (info && (i < Entries ())) _List[i] = info; }


} // namespace Puma

#endif /* __CTypeList_h__ */
