// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CRecord_h__
#define __CRecord_h__

// base class of class and union infos

#include "Puma/CStructure.h"

namespace Puma {


class CTemplateInfo;

class CRecord : public CStructure {
//  // classes/unions using this as/in an attribute.
//  Array<CObjectInfo*> _Referer;     
//  // classes/unions/enums used by this class/union as/in an attribute.
//  Array<CObjectInfo*> _Used; 
//  // methods (defined) of other classes/unions using this 
//  // class/union as argument/result. 
//  Array<CFunctionInfo*> _Transferer;
//  // classes/unions/enums used as/in arguments/results of (defined) 
//  // methods of this class/union.
//  Array<CObjectInfo*> _Transfered;

  CTemplateInfo *_TemplateInfo;
  bool _isTemplate;
  bool _hiddenFwdDecl;

protected:
  CRecord (ObjectId);

public:
  ~CRecord ();

  CTemplateInfo *TemplateInfo () const;
  void TemplateInfo (CTemplateInfo *);

  void QualifiedScope (CStructure *);

  // Get ... 
  bool isComplete (unsigned long = 0) const;        // is complete type?
  bool isDefined () const;                        // has a definition?
  bool isTemplate () const;                        // is class template?
  bool isHiddenForwardDecl () const;            // hides names?
//  unsigned Referers () const;
//  unsigned Usages () const;
//  unsigned Transferers () const;
//  unsigned Transfers () const;
//  CObjectInfo *Referer (unsigned) const;
//  CObjectInfo *Referer (const char *) const;
//  CObjectInfo *Usage (unsigned) const;
//  CObjectInfo *Usage (const char *) const;
//  CFunctionInfo *Transferer (unsigned) const;
//  CFunctionInfo *Transferer (const char *) const;
//  CObjectInfo *Transfer (unsigned) const;
//  CObjectInfo *Transfer (const char *) const;
//  bool isReferer (const CObjectInfo *) const;
//  bool isUsed (const CObjectInfo *) const;
//  bool isTransferer (const CFunctionInfo *) const;
//  bool isTransfered (const CObjectInfo *) const;

  // Set ... 
  void isTemplate (bool);
  void isHiddenForwardDecl (bool);
//  void addReferer (CObjectInfo *);
//  void addUsage (CObjectInfo *);
//  void addTransferer (CFunctionInfo *);
//  void addTransfer (CObjectInfo *);
//  void removeReferer (const CObjectInfo *);      // WILL NOT BE DESTROYED!
//  void removeUsage (const CObjectInfo *);        // WILL NOT BE DESTROYED!
//  void removeTransferer (const CFunctionInfo *); // WILL NOT BE DESTROYED!
//  void removeTransfer (const CObjectInfo *);     // WILL NOT BE DESTROYED!

  // additional information
//  bool isForward () const;
};

inline CRecord::CRecord (CObjectInfo::ObjectId id) :
  CStructure (id),
  _TemplateInfo ((CTemplateInfo*)0),
  _isTemplate (false),
  _hiddenFwdDecl (false)
 {}
 
inline bool CRecord::isTemplate () const 
 { return _isTemplate; }
inline void CRecord::isTemplate (bool v)
 { _isTemplate = v; }

inline bool CRecord::isHiddenForwardDecl () const 
 { return _hiddenFwdDecl; }
inline void CRecord::isHiddenForwardDecl (bool v)
 { _hiddenFwdDecl = v; }
  
inline CTemplateInfo *CRecord::TemplateInfo () const
 { return _TemplateInfo; }
inline void CRecord::TemplateInfo (CTemplateInfo *info) 
 { _TemplateInfo = info; }

inline void CRecord::QualifiedScope (CStructure *s)
 { _QualScope = s; }
 
//inline unsigned CRecord::Referers () const
// { return _Referer.length (); }
//inline unsigned CRecord::Usages () const
// { return _Used.length (); }
//inline unsigned CRecord::Transferers () const
// { return _Transferer.length (); }
//inline unsigned CRecord::Transfers () const
// { return _Transfered.length (); }
//inline CObjectInfo *CRecord::Referer (unsigned n) const
// { return _Referer.lookup (n); }
//inline CObjectInfo *CRecord::Usage (unsigned n) const
// { return _Used.lookup (n); }
//inline CFunctionInfo *CRecord::Transferer (unsigned n) const
// { return _Transferer.lookup (n); }
//inline CObjectInfo *CRecord::Transfer (unsigned n) const
// { return _Transfered.lookup (n); }


} // namespace Puma

#endif /* __CRecord_h__ */
