// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CMemberAliasInfo_h__
#define __CMemberAliasInfo_h__

// member alias name info 
// a member alias is created by using-declarations in 
// class scope and denote a member of a base class, 
// such a member alias has its own member access,
// the denoted member can be a class or union, enum,
// enumerator, data member, method, and typedef,
// it is added to the _Objects array of CStructure,
// the denoted member is added to _Functions, 
// _Types and _Attributes of CStructure

#include "Puma/CScopeRequest.h"

namespace Puma {


/** \file 
 *  Representation of a class member inherited from a base class.
 *  \see Puma::CMemberAliasInfo */

/** \class CMemberAliasInfo CMemberAliasInfo.h Puma/infos/CMemberAliasInfo.h
 *  A CMemberAliasInfo object represents a class member inherited 
 *  from a base class. */
class CMemberAliasInfo : public CScopeRequest {
  CObjectInfo *_Member;

public: 
  /** Construct a new member alias info. */
  CMemberAliasInfo ();
  /** Destruct the member alias info. If the object id is 
   *  \c MEMBERALIAS_INFO, Puma::CObjectInfo::CleanUp() is called. */
  ~CMemberAliasInfo ();
  
  /** Get the info of the original member for which this is an alias. */
  CObjectInfo *Member () const;
  /** Set the original member for which this is an alias. 
   *  \param info The info of the member. */
  void Member (CObjectInfo *info);
};

inline CMemberAliasInfo::CMemberAliasInfo () :
  CScopeRequest (CObjectInfo::MEMBERALIAS_INFO),
  _Member ((CObjectInfo*)0)
 {}

inline CObjectInfo *CMemberAliasInfo::Member () const
 { return _Member; }
inline void CMemberAliasInfo::Member (CObjectInfo *m)
 { _Member = m; }


} // namespace Puma

#endif /* __CMemberAliasInfo_h__ */
