#ifndef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_src_CCSyntax_cc__
#endif // __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__

#ifndef __ac_h_
#define __ac_h_
namespace AC {
  typedef const char* Type;
  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };
  struct Action {
    void **_args; void *_result; void *_target; void *_that; void *_fptr;
    void (*_wrapper)(Action &);
    inline void trigger () { _wrapper (*this); }
  };
  struct AnyResultBuffer {};
  template <typename T> struct ResultBuffer : public AnyResultBuffer {
    char _data[sizeof (T)];
    ~ResultBuffer () { ((T*)_data)->T::~T(); }
    operator T& () const { return *(T*)_data; }
  };
  template <class Aspect, int Index>
  struct CFlow {
    static int &instance () {
      static int counter = 0;
      return counter;
    }
    CFlow () { instance ()++; }
    ~CFlow () { instance ()--; }
    static bool active () { return instance () > 0; }
  };
}
inline void * operator new (__SIZE_TYPE__, AC::AnyResultBuffer *p) { return p; }
inline void operator delete (void *, AC::AnyResultBuffer *) { } // for VC++
#endif // __ac_h_
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CMatchSyntax_ah__
#define __CMatchSyntax_ah__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __C_WILDCARD_TOKENS__
#define __C_WILDCARD_TOKENS__

namespace Puma {


enum CWildcardTokens {
  TOK_WC_AND = 500,
  TOK_WC_OR,
  TOK_WC_XOR,
  TOK_WC_SEQ,
  TOK_WC_IF,
  TOK_WC_ELIF,
  TOK_WC_ENDIF,
  TOK_WC_NOT,
  TOK_WC_EXACT,
  TOK_WC_FIRST,
  TOK_WC_LAST,
  TOK_WC_LEAF,
  TOK_WC_PRUNE,
  TOK_WC_COLLECT,
  TOK_WC_NODENAME,
  TOK_WC_ELEMENT,

  TOK_DO_EXPR,
  TOK_DO_EXPR_LIST,
  TOK_DO_ID_EXPR,
  TOK_DO_IDENTIFIER,
  TOK_DO_DECL_SPEC,
  TOK_DO_DECL_SPEC_SEQ,
  TOK_DO_INIT_DECLARATOR_LIST,
  TOK_DO_INIT_DECLARATOR,
  TOK_DO_DECLARATOR,
  TOK_DO_INIT,
  TOK_DO_ARG_DECL_SEQ,
  TOK_DO_FCT_BODY,
  TOK_DO_CLASS_SPEC,
  TOK_DO_MEMBER_SPEC,
  TOK_DO_MEMBER_DECL,
  TOK_DO_BASE_CLAUSE,
  TOK_DO_CTOR_INIT,
  TOK_DO_MEM_INIT,
  TOK_DO_STMT,
  TOK_DO_STMT_SEQ,

  TOK_ANY_EXPR,
  TOK_ANY_EXPR_LIST,
  TOK_ANY_ID_EXPR,
  TOK_ANY_IDENTIFIER,
  TOK_ANY_DECL_SPEC,
  TOK_ANY_DECL_SPEC_SEQ,
  TOK_ANY_INIT_DECLARATOR_LIST,
  TOK_ANY_INIT_DECLARATOR,
  TOK_ANY_DECLARATOR,
  TOK_ANY_INIT,
  TOK_ANY_ARG_DECL_SEQ,
  TOK_ANY_FCT_BODY,
  TOK_ANY_CLASS_SPEC,
  TOK_ANY_MEMBER_SPEC,
  TOK_ANY_MEMBER_DECL,
  TOK_ANY_BASE_CLAUSE,
  TOK_ANY_CTOR_INIT,
  TOK_ANY_MEM_INIT,
  TOK_ANY_STMT,
  TOK_ANY_STMT_SEQ,
  
  TOK_IS_CLASS,
  TOK_IS_ENUM,
  TOK_IS_TYPEDEF
};


} // namespace Puma

#endif /* __WILDCARD_TOKENS__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __C_TOKENS__
#define __C_TOKENS__

namespace Puma {

enum CTokens {

  // core tokens, i.e. numbers, operator symbols, brackets, etc.
  TOK_AT = 100,
  TOK_ZERO_VAL,
  TOK_INT_VAL,
  TOK_FLT_VAL,
  TOK_COMMA,
  TOK_ASSIGN,
  TOK_QUESTION,
  TOK_OR,
  TOK_ROOF,
  TOK_AND,
  TOK_PLUS,
  TOK_MINUS,
  TOK_MUL,
  TOK_DIV,
  TOK_MODULO,
  TOK_LESS,
  TOK_GREATER,
  TOK_OPEN_ROUND,
  TOK_CLOSE_ROUND,
  TOK_OPEN_SQUARE,
  TOK_CLOSE_SQUARE,
  TOK_OPEN_CURLY,
  TOK_CLOSE_CURLY,
  TOK_SEMI_COLON,
  TOK_COLON,
  TOK_NOT,
  TOK_TILDE,
  TOK_DOT,
  TOK_MUL_EQ,
  TOK_DIV_EQ,
  TOK_MOD_EQ,
  TOK_ADD_EQ,
  TOK_SUB_EQ,
  TOK_LSH_EQ,
  TOK_RSH_EQ,
  TOK_AND_EQ,
  TOK_XOR_EQ,
  TOK_IOR_EQ,
  TOK_OR_OR,
  TOK_AND_AND,
  TOK_EQL,
  TOK_NEQ,
  TOK_LEQ,
  TOK_GEQ,
  TOK_LSH,
  TOK_RSH,
  TOK_DOT_STAR,
  TOK_PTS_STAR,
  TOK_INCR,
  TOK_DECR,
  TOK_PTS,
  TOK_COLON_COLON,
  TOK_ELLIPSIS,
  TOK_LAST_CORE = TOK_ELLIPSIS, // this is a group separator for the scanner!
  
  // C keywords:
  TOK_ASM,
  TOK_AUTO,
  TOK_BREAK,
  TOK_CASE,
  TOK_CHAR,
  TOK_CONST,
  TOK_CONTINUE,
  TOK_DEFAULT,
  TOK_DO,
  TOK_DOUBLE,
  TOK_ELSE,
  TOK_ENUM,
  TOK_EXTERN,
  TOK_FLOAT,
  TOK_FOR,
  TOK_GOTO,
  TOK_IF,
  TOK_INLINE,
  TOK_INT,
  TOK_LONG,
  TOK_REGISTER,
  TOK_RESTRICT,
  TOK_RETURN,
  TOK_SHORT,
  TOK_SIGNED,
  TOK_SIZEOF,
  TOK_STATIC,
  TOK_STRUCT,
  TOK_SWITCH,
  TOK_TYPEDEF,
  TOK_UNION,
  TOK_UNSIGNED,
  TOK_VOID,
  TOK_VOLATILE,
  TOK_WCHAR_T,
  TOK_WHILE,

  // C compatibility keywords

  TOK_ASM_2,
  TOK_ASM_3,
  TOK_BOOL_2,
  TOK_CONST_2,
  TOK_CONST_3,
  TOK_INLINE_2,
  TOK_INLINE_3,
  TOK_RESTRICT_2,
  TOK_RESTRICT_3,
  TOK_SIGNED_2,
  TOK_SIGNED_3,
  TOK_VOLATILE_2,
  TOK_VOLATILE_3,
  TOK_WCHAR_T_2,
  TOK_TYPEOF,
  TOK_TYPEOF_2,
  TOK_TYPEOF_3,

  // C win specific keywords

  TOK_INT64,
  TOK_CDECL,
  TOK_CDECL_2,
  TOK_STDCALL,
  TOK_STDCALL_2,
  TOK_FASTCALL,
  TOK_FASTCALL_2,
  TOK_IF_EXISTS,
  TOK_IF_NOT_EXISTS,

  TOK_LAST_C = TOK_IF_NOT_EXISTS,
  
  // a boolean constant:
  TOK_BOOL_VAL,

  // C++ keywords:

  TOK_BOOL,
  TOK_CATCH,
  TOK_CLASS,
  TOK_CONST_CAST,
  TOK_DELETE,
  TOK_DYN_CAST,
  TOK_EXPLICIT,
  TOK_EXPORT,
  TOK_FRIEND,
  TOK_MUTABLE,
  TOK_NAMESPACE,
  TOK_NEW,
  TOK_OPERATOR,
  TOK_PRIVATE,
  TOK_PROTECTED,
  TOK_PUBLIC,
  TOK_REINT_CAST,
  TOK_STAT_CAST,
  TOK_TEMPLATE,
  TOK_THIS,
  TOK_THROW,
  TOK_TRY,
  TOK_TYPEID,
  TOK_TYPENAME,
  TOK_USING,
  TOK_VIRTUAL,

  // C++ alternative representation of operators (ISO 646):

  TOK_AND_AND_ISO_646,
  TOK_AND_EQ_ISO_646,
  TOK_AND_ISO_646,
  TOK_OR_ISO_646,
  TOK_TILDE_ISO_646,
  TOK_NOT_ISO_646,
  TOK_NEQ_ISO_646,
  TOK_OR_OR_ISO_646,
  TOK_IOR_EQ_ISO_646,
  TOK_ROOF_ISO_646,
  TOK_XOR_EQ_ISO_646,

  TOK_LAST_CC = TOK_XOR_EQ_ISO_646,
  
  // AspectC++ keywords:

  TOK_POINTCUT,
  TOK_ASPECT,
  TOK_ADVICE,
  TOK_SLICE,
  TOK_UNKNOWN_T,

  TOK_LAST_AC = TOK_UNKNOWN_T,
  
  // further [A](C|C++) token
  TOK_STRING_VAL,
  TOK_CHAR_VAL,
  TOK_ID,

  // These two always have to be the ** last ** token listed here!!!
  TOK_EPSILON,
  TOK_NO
  
};

} // namespace Puma

#endif /* __C_TOKENS__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __str_col__
#define __str_col__

// Collection of functions handling strings.

namespace Puma {


class Unit;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StrCol {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  StrCol () {}
        
public:
  // Return true if c is a white space character.
  static bool isSpace (const char c);

  // Return true if the string consists only of spaces.
  static bool onlySpaces (const char *);

  // Return true if the two strings differ not only in spaces.
  static bool effectivelyDifferent (const char *, const char *);

  // Build a string from a unit.
  static char *buildString (Unit *);
        
  // Duplicate a string
  static char *dup (const char *);
  static char *dup (const char *, int);
};


} // namespace Puma

#endif /* __str_col__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Config_h__
#define __Config_h__

// Class Config provides evaluation of configuration 
// information from file or command line.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Flags_h__
#define __Flags_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Flags {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  enum Flag {
    NONE                       = 0x0,
    
    SKIP_FCT_BODY              = 0x1,
    SKIP_INITS                 = 0x2,
    
    // GNU extensions
    GNU_NESTED_FCT             = 0x4,
    GNU_CONDITION_SCOPE        = 0x8,
    GNU_PARAM_DECL             = 0x10,
    GNU_FCT_DECL               = 0x20,
    GNU_PARAM_SCOPE            = 0x40,
    GNU_DEFAULT_ARGS           = 0x80,
    GNU_EXTENDED_ASM           = 0x100,
    GNU_EXTENDED_EXPR          = 0x200,
    GNU_LONG_LONG              = 0x400,
    GNU_NAME_SCOPE             = 0x800, 
    GNU_IMPLICIT_INT           = 0x1000,
    GNU_FCT_ATTRIBUTE          = 0x2000,
    GNU_IF_THEN_EXPR           = 0x4000
  };
  
private:
  Flag _Flags;
  
public:
  Flags ();
  Flags (const Flags &);
  Flags &operator =(const Flags &);

  // add/remove flag
  Flags &operator +=(Flag);
  Flags &operator -=(Flag);
  
  // test for flag
  bool operator ==(Flag) const;
  bool operator !=(Flag) const;
};

inline Flags::Flags () : _Flags (NONE) 
 {}
inline Flags::Flags (const Flags &f)
 { _Flags = f._Flags; }
inline Flags &Flags::operator =(const Flags &f)
 { _Flags = f._Flags; return *(Flags*)this; }

inline Flags &Flags::operator +=(Flags::Flag f)
 { _Flags = (Flag)(_Flags | f); return *(Flags*)this; }
inline Flags &Flags::operator -=(Flags::Flag f)
 { _Flags = (Flag)(_Flags ^ (_Flags & f)); return *(Flags*)this; }

inline bool Flags::operator ==(Flags::Flag f) const
 { return _Flags & f; }
inline bool Flags::operator !=(Flags::Flag f) const
 { return ! (_Flags & f); }


} // namespace Puma

#endif /* __Flags_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ConfOption_h__
#define __ConfOption_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __array_h__
#define __array_h__

#include <assert.h>

namespace Puma {

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
template <class Item>
class Array {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

   protected:
      static const long default_init_size = 5;
      static const long default_increment = 5;

   public:
      Array (long is = default_init_size, long incr = default_increment);
      Array (const Array<Item>& array);
      Array<Item>& operator =(const Array<Item>&);
      ~Array ();
      void append (const Item& item);
      void insert (long index, const Item& item);
      void prepend (const Item& item);
      void remove (long index);
      void reset ();
      Item& get (long index);
      Item& operator[] (long index);
      Item fetch (long index) const;
      Item& lookup (long index) const;
      long length () const;

   private:
      Item* data;
      long size;
      long count;
      long increment;
      
      void check (long wanted);
 };

template <class Item>
inline Array<Item>::Array (long is, long incr)
 {
   count     = 0; 
   size      = is;
   increment = incr;
   data      = new Item[size];
 }

template <class Item>
Array<Item>::Array (const Array<Item>& array)
 {
   count = 0;
   size  = array.size;
   data  = new Item[size];
   increment = array.increment;

   for (int pos = 0; pos < array.length (); pos++)
      append (array.lookup (pos));
 }

template <class Item>
Array<Item>& Array<Item>::operator =(const Array<Item>& array)
 {
   if (data)
      delete[] data;
   count = 0;
   size  = array.size;
   data  = new Item[size];
   increment = array.increment;

   for (int pos = 0; pos < array.length (); pos++)
      append (array.lookup (pos));
   return *this;
 }

template <class Item>
Array<Item>::~Array ()
 {
   if (data)
      delete[] data;
 }

template <class Item>
inline void Array<Item>::check (long wanted)
 {
   if (wanted >= size)
    {
      Item* new_data;

      while (wanted >= size)
      {
         size += increment;
         increment*=2;
      }
      new_data = new Item[size];
      for (int pos = 0; pos < count; pos++)
         new_data[pos] = data[pos];
      delete[] data;
      data = new_data;
    }
 }
   
template <class Item>
inline void Array<Item>::append (const Item& item)
 {
   check (count);
   data[count++] = item;
 }

template <class Item>
void Array<Item>::prepend (const Item& item)
 {
   insert (0, item);
 }

template <class Item>
void Array<Item>::insert (long index, const Item& item)
 {
   check (count);
   for (int pos = count; pos > index; pos--)
      data[pos] = data[pos - 1];
   data[index] = item;
   count++;
 }

template <class Item>
inline Item& Array<Item>::get (long index)
 {
   check (index);
   if (index >= count)
      count = index + 1;
   return data[index];
 }

template <class Item>
inline Item& Array<Item>::operator[] (long index)
 {
   return get (index);
 }

template <class Item>
inline Item Array<Item>::fetch (long index) const
 {
   assert(index < count);
   return data[index];
 }

template <class Item>
inline long Array<Item>::length () const
 {
   return count;
 }

template <class Item>
inline void Array<Item>::remove (long index)
 {
   if (index < count && count > 0)
    {
      for (int pos = index; pos < count - 1; pos++)
         data[pos] = data[pos + 1];
      count--;
    }
 }

#ifndef __puma
template <>
inline void Array<int>::reset () {
   count = 0; 
}
#endif

template <class Item>
void Array<Item>::reset ()
 {
   if (data)
      delete[] data;
   count     = 0; 
   size      = default_init_size;
   increment = default_increment;
   data      = new Item[size];
 }

template <class Item>
inline Item& Array<Item>::lookup (long index) const
 {
   assert(index >= 0 && index < count);
//   if (index >= count) index = count - 1; 
//   if (index < 0)      index = 0;
   return data[index];
 }


} // namespace Puma

// Array specialization for pointer types sharing method definitions

#ifndef __puma

#include "Puma/VoidPtrArray.h"

namespace Puma {


template <class Item>
class Array<Item*> : private VoidPtrArray {
  typedef VoidPtrArray Base;

public:
  Array (long is = default_init_size, long incr = default_increment) :
    Base (is, incr) {}
  Array (const Array<Item*> &array) : 
    Base (array) {}
  Array<Item*> &operator= (const Array<Item*> &array) 
   { return (Array<Item*>&)Base::operator= (array); }

  ~Array () {}

  void append (const Item *item)           { Base::append ((void*)item); }
  void insert (long idx, const Item *item) { Base::insert (idx, (void*)item); }
  void prepend (const Item *item)          { Base::prepend ((void*)item); }
  void remove (long idx)                   { Base::remove (idx); }
  void reset ()                            { Base::reset (); }

  Item *&get (long idx)          { return (Item*&)Base::get (idx); }
  Item *&operator[] (long idx)   { return (Item*&)Base::operator[] (idx); }
  Item *fetch (long idx) const   { return (Item*)Base::fetch (idx); }
  Item *&lookup (long idx) const { return (Item*&)Base::lookup (idx); }
  long length () const           { return Base::length (); }
};


} // namespace Puma

#endif /* __puma */

#endif /* __array_h__ */
#include <stdlib.h>

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ConfOption {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_name;
  Array<const char *> _args;
  
public:
  ConfOption (const char *);
  ConfOption (const char *, const char *);
  ConfOption (const char *, const char *, const char *);
  ~ConfOption ();
  
  const char *Name () const;
  unsigned Arguments () const;
  const char *Argument (unsigned) const;
  
  void addArgument (const char *);
};

inline ConfOption::ConfOption (const char *n) : _args (1, 1) 
 { _name = StrCol::dup (n); }
inline ConfOption::ConfOption (const char *n, const char *a1) : _args (1, 1) 
 { _name = StrCol::dup (n); addArgument (a1); }
inline ConfOption::ConfOption (const char *n, const char *a1, const char *a2) : _args (2, 1) 
 { _name = StrCol::dup (n); addArgument (a1); addArgument (a2); }
 
inline ConfOption::~ConfOption ()
 { delete[] _name; 
   for (unsigned i = 0; i < Arguments (); i++) 
     delete[] Argument (i);
 }

inline const char *ConfOption::Name () const 
 { return _name; }
inline unsigned ConfOption::Arguments () const
 { return _args.length (); }
inline const char *ConfOption::Argument (unsigned i) const
 { return _args.lookup (i); }
  
inline void ConfOption::addArgument (const char *a) 
 { if (a) _args.append (StrCol::dup (a)); }


} // namespace Puma

#endif /* __ConfOption_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_stream_h__
#define __error_stream_h__

// An ErrorStream is a special ErrorSink that prints out an error message
// as soon as it complete. It also stores the maximum error severity.
// The ErrorStream can be reset to it's initial state.

#include <sstream>
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_sink_h__
#define __error_sink_h__

// This is an interface for classes that may be used to consume error
// messages during a process where many errors can occur like parsing
// a program.
// The error information is handed over to the ErrorSink in stream-like
// style. Different severities of errors are predefined and can be used
// to classify error information that follows. Also a location can be
// handed over to the ErrorSink to specify where the error was found
// (filename, line, etc.). The error information itself can be of any
// standard data type or anything that is "Printable".
// Specializations of this class could either build and print error
// messages or collect them for a later processing.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_severity_h__
#define __error_severity_h__

// Severity of errors: represented by a short integer and a text

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ErrorSeverity {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  unsigned short _severity;
  const char *_text;

public:
  ErrorSeverity (unsigned short s = 0, const char* t = (const char*)0) :
    _severity (s), _text (t) {}
  ErrorSeverity (const ErrorSeverity &s) :
    _severity (s._severity), _text (s._text) {}
  ErrorSeverity &operator =(const ErrorSeverity &s) 
    { _severity = s._severity; _text = s._text; return *this; }

  int operator < (const ErrorSeverity &s) const
   { return _severity < s._severity; }
  int operator > (const ErrorSeverity &s) const
   { return _severity > s._severity; }
  int operator <= (const ErrorSeverity &s) const
   { return _severity < s._severity || _severity == s._severity; }
  int operator >= (const ErrorSeverity &s) const
   { return _severity > s._severity || _severity == s._severity; }
  int operator == (const ErrorSeverity &s) const
   { return _severity == s._severity; }
  int operator != (const ErrorSeverity &s) const
   { return _severity != s._severity; }
  const char *text () const
   { return _text; }
};

extern const ErrorSeverity sev_none;
extern const ErrorSeverity sev_message;
extern const ErrorSeverity sev_warning;
extern const ErrorSeverity sev_error;
extern const ErrorSeverity sev_fatal;
      

} // namespace Puma

#endif /* __error_severity_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __printable_h__
#define __printable_h__

#include <iostream>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  virtual ~Printable () {}
  virtual void print (ostream &os) const = 0;
};


inline ostream &operator << (ostream &os, const Printable &object) {
  object.print (os);
  return os;
}


} // namespace Puma

#endif /* __printable_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __location_h__
#define __location_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __smart_ptr_h__
#define __smart_ptr_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ref_cnt_h__
#define __ref_cnt_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class RefCnt {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _counter;

public:
  RefCnt () : _counter (0) {}
  virtual ~RefCnt () {}
  
  void ref () { _counter++; }
  void deref () { _counter--; }
  int counter () { return _counter; }
};


} // namespace Puma

#endif /* __ref_cnt_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class SmartPtr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  RefCnt *_data;

public:
  SmartPtr () : _data ((RefCnt*)0) {}
  ~SmartPtr () { clear (); }
  SmartPtr (const SmartPtr &copy);
  SmartPtr (RefCnt *rc) : _data (rc) {}
  SmartPtr &operator = (const SmartPtr &copy);

  void data (RefCnt *d);
  void clear ();
  RefCnt *data () const { return _data; }
  bool is_defined () const { return _data != (RefCnt*)0; }
};


} // namespace Puma

#endif /* __smart_ptr_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __location_info_h__
#define __location_info_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __filename_h__
#define __filename_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __filename_info_h__
#define __filename_info_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __DString_h__
#define __DString_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __StrHashTable_h__
#define __StrHashTable_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __StrHashKey_h__
#define __StrHashKey_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Chain_h__
#define __Chain_h__

//
// implements a simple chain
// 

#ifndef __puma
#include <iostream>
using namespace std;
#endif 

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Chain {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Chain *next;

public:
  Chain () { next = 0; }
   
  void select (Chain *c) { next = c; }
  Chain *select () const { return next; }

  Chain *unlink () {
    Chain *res = next;
    if (next) {
      next = next->select ();
    }
    return res;
  }

  void insert (Chain *c) {
    c->select (next);
    next = c;
  }
};

#ifndef __puma


//
// Chain with useage/max counter
// 

class ChainCnt : public Chain {
  const char* name;

public:
  long long max, use;
  
  ChainCnt (const char *n) : name (n) { max = use = 0; }
  ~ChainCnt () {
    cout << "max list " << name << ": " << max << endl;
  }

  Chain *unlink () {
    Chain *c = Chain::unlink ();
    if (c) 
      use--;
    return c;
  }
  
  void insert (Chain *c) {
    use++;
    if(use > max) 
      max = use;
    Chain::insert (c);
  }
};

#endif /* __puma */


} // namespace Puma

#endif /* __Chain_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StrHashKey : public Chain {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  unsigned int m_Magic;
  unsigned int m_Len;
  const char  *m_Str;

  StrHashKey () : m_Len (0), m_Str (0) {}

public:
  StrHashKey (int m, const char *s, int l) : 
    m_Magic (m), m_Len (l), m_Str (StrCol::dup (s, l)) {}

  unsigned int getMagic () const { return m_Magic; }
  unsigned int length () const { return m_Len; }
  const char  *c_str () const { return m_Str; }
};


} // namespace Puma

#endif /* __StrHashKey_h__ */
#include <assert.h>

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StrHashTable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  StrHashKey *_emptyKey;

public:
  StrHashTable () {
    _emptyKey = insert ("");
    assert (_emptyKey);
  }

  StrHashKey *empty () const { assert (_emptyKey); return _emptyKey; }
  StrHashKey *insert (const char *);
  void remove (StrHashKey *);

  enum { STRHASHTABLE_SIZE=0xffff };
  
private:
  Chain m_Table[STRHASHTABLE_SIZE];

  StrHashKey *find (unsigned int, const char *, unsigned int);
  unsigned int hash (const char *, unsigned int);
};


} // namespace Puma

#endif /* __StrHashTable_h__ */
#include <assert.h>

namespace Puma {


extern StrHashTable ___str_dict;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class DString {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  StrHashKey *m_Key;

public:
  DString () {
    m_Key = ___str_dict.empty ();
    assert (m_Key);
  }
  DString (const char *s) {
    if(s == 0) {
      m_Key = ___str_dict.empty ();
    } else {
      m_Key = ___str_dict.insert (s);
    }
    assert (m_Key);
  }
  DString (const DString &s) : m_Key (s.m_Key) {
    assert (s.m_Key);
  }
  
  DString &operator = (const DString &s) {
    assert (s.m_Key);
    m_Key = s.m_Key;
    return *this;
  }
  
  DString &operator = (const char *s) {
    if(s == 0) {
      m_Key = ___str_dict.empty ();
    } else {
      m_Key = ___str_dict.insert (s);
    }
    assert (m_Key);
    return *this;
  }

  bool operator == (const DString &s) const { 
    assert (m_Key && s.m_Key);
    return m_Key == s.m_Key; 
  }
  bool operator != (const DString &s) const { 
    assert (m_Key && s.m_Key);
    return m_Key != s.m_Key; 
  }

  const char *c_str() const { 
    assert (m_Key);
    return m_Key->c_str (); 
  }
  unsigned int length () const { 
    assert (m_Key);
    return m_Key->length (); 
  }
  bool empty () const {
    assert (m_Key);
    return m_Key->length () == 0;
  }
  unsigned int magic () const { 
    assert (m_Key);
    return m_Key->getMagic (); 
  }

  operator const char *() const {
    assert (m_Key);
    return c_str ();
  }
};


} // namespace Puma

#endif /* __DString_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class FilenameInfo : public RefCnt {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  DString _name;
  const char *_path;
  const char *_root;

public:
  FilenameInfo () : _path ((const char*)0), _root ((const char*)0) {}
  ~FilenameInfo ();
  void name (const char *n);
  void name (const DString &dsn) { _name = dsn; }
  const char *name () const { return _name.c_str (); }
  const char *path ();
  const char *root ();
  bool is_absolute () const;
  bool operator == (const FilenameInfo &rc) const {
    return _name == rc._name;
  }
};


} // namespace Puma

#endif /* __filename_info_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Filename : public SmartPtr, public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  FilenameInfo *info () const { return (FilenameInfo*)data (); }

public:
  Filename () {}
  Filename (const char *n) { name (n); }
  Filename &operator = (const char *n) { name (n); return *this; }
  void name (const char *n);
  const char *name () const;
  const char *path () const;
  const char *root () const;
  bool is_absolute () const;
  bool operator == (const Filename &f) const;
  bool operator != (const Filename &f) const { return !(*this == f); }
  virtual void print (ostream &os) const { if (info ()) os << name (); }
};


} // namespace Puma

#endif /* __filename_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class LocationInfo : public RefCnt {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Filename _filename;
  int _line;

public:
  LocationInfo () : _filename (), _line (0) {}
  void setup (Filename f, int l);
  const Filename &filename () const { return _filename; }
  int line () const { return _line; }
  bool operator < (const LocationInfo &l) const;
  bool operator == (const LocationInfo &l) const;
};


} // namespace Puma

#endif /* __location_info_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Location : public SmartPtr, public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  LocationInfo *info () const { return (LocationInfo*)data (); }

public:
  Location () {}
  Location (Filename f, int l) { setup (f, l); }
  Location (LocationInfo *lptr) : SmartPtr (lptr) {}
  LocationInfo *operator ~ () { if (info ()) info ()->ref (); return info (); }
  void setup (Filename f, int l);
  const Filename &filename () const   { return info ()->filename (); }
  int line () const;
  bool operator == (const Location &l) const;
  bool operator != (const Location &l) const { return ! (*this == l); }
  bool operator < (const Location &l) const;

  virtual void print (ostream &os) const {
    if (info ())
#ifdef VISUAL_STUDIO
      os << filename () << "(" << line () << ")";
#else
      os << filename () << ":" << line ();
#endif
  }
};


} // namespace Puma

#endif /* __location_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ErrorSink {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  virtual ~ErrorSink () {}
  virtual ErrorSink &operator << (const char *) = 0;
  virtual ErrorSink &operator << (long) = 0;
  virtual ErrorSink &operator << (unsigned) = 0;
  virtual ErrorSink &operator << (int) = 0;
  virtual ErrorSink &operator << (short) = 0;
  virtual ErrorSink &operator << (char) = 0;
  virtual ErrorSink &operator << (double) = 0;
  virtual ErrorSink &operator << (const ErrorSeverity &) = 0;
  virtual ErrorSink &operator << (Location) = 0;
  virtual ErrorSink &operator << (const Printable &) = 0;
  virtual ErrorSink &operator << (void (*f)(ErrorSink &)) = 0;
  virtual void endMessage () = 0;
};

void endMessage (ErrorSink &);


} // namespace Puma

#endif /* __error_sink_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ErrorStream : public ErrorSink {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  ostream *_ostream;
  ErrorSeverity _max_severity;
  ErrorSeverity _curr_severity;
  Location _location;
  bool _have_location;
  std::ostringstream *_msg;
  bool _silently;

  void output ();
  void clear ();

public:
  ErrorStream (std::ostream &s = cerr) : _ostream (&s), _msg ((std::ostringstream*)0)
   { reset (); _silently = false; }
  virtual ~ErrorStream () { delete _msg; }

  ErrorStream &operator << (const char *);
  ErrorStream &operator << (long);
  ErrorStream &operator << (unsigned);
  ErrorStream &operator << (int);
  ErrorStream &operator << (short);
  ErrorStream &operator << (char);
  ErrorStream &operator << (double);
  ErrorStream &operator << (const ErrorSeverity &);
  ErrorStream &operator << (Location);
  ErrorStream &operator << (const Printable &);
  ErrorStream &operator << (void (*f)(ErrorSink &));

  void endMessage ();
  void reset ();
  void silent ();
  void loud ();

  ErrorSeverity severity () const { return _max_severity; }
};


} // namespace Puma

#endif /* __error_stream_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __OptsParser_h__
#define __OptsParser_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __SimpleParser_h__
#define __SimpleParser_h__

#include <vector>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class SimpleParser {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  SimpleParser() {}
  ~SimpleParser() {}
   
  static int tokenize (const string &, vector<string> &, 
                       const string &delimiters = " ");
  static string strip (const string &);
};


} // namespace Puma

#endif /* __SimpleParser_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class OptsParser : public SimpleParser {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  vector<string> m_argv;
  unsigned int m_curarg;
  unsigned int m_tonext;
  int m_number;

  string m_arg;
  string m_opt;
   
public:
  
  enum {NOARG =-4, ERR = -3, NOOPTION = -2, UNKNOWN = -1, FINISH = 0 };
  
  enum ArgType { AT_NONE = 0, AT_MANDATORY = 1, AT_OPTIONAL = 2 };
  
  struct Option {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    int number;
    char key; 
    const char *name;
    const char *desc;
    ArgType args;
  };

private:
  const Option *m_opts;
   
public:
  OptsParser (int, char **, const Option *);
  OptsParser (const string &, const Option *);

  int getCurrentArgNum () const;
  int getNextArgNum () const;
  int getOption ();
  int getResult () const;
  
  const string &getArgument () const;
  const string &getOptionName () const;

  bool revokeArgument();
   
private:
  int  getShortOption (const string &);
  int  getLongOption  (const string &);
  bool processOption  (const string &, unsigned int,ArgType argtype);
};


} // namespace Puma

#endif /* __OptsParser_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Config {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Flags _flags;
  ErrorStream &_err;
  Array<const ConfOption *> _options;
  
public:
  enum OPTIONS {
    PRE_ASSERT = 1,
    PRE_DEFINE, 
    PRE_UNDEFINE, 
    PRE_LOCK_MACRO,
    PRE_INCLUDE,
    CFG_FILE, 
    PROJ_PATH, 
    PROJ_DESTINATION,
    SET_SUFFIX, 
    SET_EXTENSION, 
    SET_WRITE_PROTECTED,
    SET_OPTION, 
    SET_OPTION_ARG
  };
   
public:
  Config (ErrorStream &);
  Config (const Config &);
  ~Config ();
  
  // read config file
  Config (ErrorStream &, const char *);
  // read command line
  Config (ErrorStream &, int &, char **&);
  // read config file and command line
  Config (ErrorStream &, const char *, int &, char **&);
        
  // join with another configuration
  void Join (const Config &);

  // evaluate file, if file not given read from $PUMA_CONFIG
  // or /etc/puma.config
  void Read (const char * = (const char *)0);
  // evaluate command line
  void Read (int &, char **&);

  // add options to configuration
  void Add (const ConfOption *);
  void Add (const char *);
  void Add (const char *, const char *);
  void Add (const char *, const char *, const char *);

  // get options
  unsigned Options () const;
  const ConfOption *Option (unsigned) const;
  const ConfOption *Option (const char *) const;

  Flags FlagTable () const;
  
private:
  bool Valid (const char *, const char * = (const char *)0) const;

  bool Process (OptsParser&);
  bool ProcessAssert (const string&);
  bool ProcessDefine (const string&);
  bool ProcessLockMacro (const string&);
  bool ProcessUndefine (const string&);
  bool ProcessConfigFile (const string&,const string&);
  bool ProcessArgument (const string&,const string&);
  bool ProcessPathArgument (const string&,const string&);

};

inline Config::Config (ErrorStream &e) : _err (e)
 {}
inline Config::Config (const Config &c) : _err (c._err)
 { Join (c); }
  
inline Config::Config (ErrorStream &e, const char *file) : _err (e)
 { Read (file); }
inline Config::Config (ErrorStream &e, int &argc, char **&argv) : _err (e)
 { Read (argc, argv); }
inline Config::Config (ErrorStream &e, const char *file, int &argc, char **&argv) : _err (e)
 { Read (file); Read (argc, argv); }

inline Config::~Config  ()
 { for (unsigned i = 0; i < Options (); i++)
     delete (ConfOption *) Option (i);
 }

inline void Config::Add (const ConfOption *o) 
 { _options.append (o); }
inline void Config::Add (const char *n)
 { Add (new ConfOption (n)); }
inline void Config::Add (const char *n, const char *a1)
 { Add (new ConfOption (n, a1)); }
inline void Config::Add (const char *n, const char *a1, const char *a2)
 { Add (new ConfOption (n, a1, a2)); }

inline unsigned Config::Options () const
 { return _options.length (); }
inline const ConfOption *Config::Option (unsigned i) const
 { return _options.lookup (i); }

inline Flags Config::FlagTable () const
 { return _flags; }


} // namespace Puma

#endif /* __Config_h__ */
namespace Puma {
  class CSyntax;
  class CCSyntax;
  class CBuilder;
  class CSemantic;
  class Container;
  class CTree;
  class CStrLiteral;
  class CT_Any;
  class CT_AnyList;
  class CT_AnyExtension;
  class CT_AnyCondition;
  class CT_SimpleName;
} // namespace Puma


using namespace Puma;

namespace Puma {
  
  
  
}

class WinIfExists;
class WinImportHandler;
class WinMacros;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class CMatchSyntax {
public:
  static CMatchSyntax *aspectof () {
    static CMatchSyntax __instance;
    return &__instance;
  }
  static CMatchSyntax *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  
    
  
  

protected:
  // flag to enable/disable parsing match expressions
  bool match_expr;

protected:
  CMatchSyntax () : match_expr (false) {}
  
  // introduce wildcard rules to CSyntax and CCSyntax
  
  

  // extend CBuilder
  

  // extend CSemantic
  

  // let first parse wildcards before parsing anything else
  
public: template<class JoinPoint> void __a0_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr &&
	thisJoinPoint->that ()->parse (&__JP_That::wildcards)) 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().get_node (); 
    else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  // extend the syntax to parse ANYs

  
public: template<class JoinPoint> void __a1_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_EXPR)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a2_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_EXPR_LIST)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any_list (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a3_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_ID_EXPR)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a4_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_IDENTIFIER)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a5_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

      tjp->that ()->_decl_spec_1.set (TOK_ANY_DECL_SPEC);
  }
protected:

  
  
public: template<class JoinPoint> void __a6_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    CTree *&result = *(CTree**)tjp->result ();
    if (match_expr && !result &&
        tjp->that ()->parse (TOK_ANY_DECL_SPEC) &&
        tjp->that ()->parse (&__JP_That::wc_extension)) {
      result = tjp->that ()->builder().any ();
    }
  }
protected:


  
public: template<class JoinPoint> void __a7_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_DECL_SPEC_SEQ)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any_list (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a8_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_INIT_DECLARATOR_LIST)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any_list (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a9_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_INIT_DECLARATOR)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a10_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_DECLARATOR)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a11_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_INIT)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a12_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_ARG_DECL_SEQ)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any_list (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a13_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_FCT_BODY)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a14_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_CLASS_SPEC)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a15_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_MEMBER_SPEC)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any_list (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a16_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_MEMBER_DECL)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a17_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_STMT)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a18_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_STMT_SEQ)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any_list (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a19_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_BASE_CLAUSE)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any_list (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a20_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_CTOR_INIT)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a21_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_ANY_MEM_INIT)) {
      thisJoinPoint->that ()->parse (&__JP_That::wc_extension); 
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->builder ().any (); 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  // extend the syntax to be able to parse match trees

  
public: template<class JoinPoint> void __a22_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_IS_TYPEDEF)) {
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->parse (TOK_ID) ? 
        thisJoinPoint->that ()->builder ().is_name () : (CTree*)0; 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a23_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_IS_CLASS)) {
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->parse (TOK_ID) ? 
        thisJoinPoint->that ()->builder ().is_name () : (CTree*)0; 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  
public: template<class JoinPoint> void __a24_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;
 
    if (match_expr && thisJoinPoint->that ()->parse (TOK_IS_ENUM)) {
      *(CTree**)thisJoinPoint->result () = 
        thisJoinPoint->that ()->parse (TOK_ID) ? 
        thisJoinPoint->that ()->builder ().is_name () : (CTree*)0; 
    } else 
      thisJoinPoint->action ().trigger (); 
  }
protected:


  // configure parsing match expressions
  
  
public: void __a25_before (Config &config) {
    match_expr = (config.Option ("--match-expr"));
  }
protected:

};
namespace AC {
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a0_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a0_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a1_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a1_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a2_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a2_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a3_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a3_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a4_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a4_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a5_after (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a5_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a6_after (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a6_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a7_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a7_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a8_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a8_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a9_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a9_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a10_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a10_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a11_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a11_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a12_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a12_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a13_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a13_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a14_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a14_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a15_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a15_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a16_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a16_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a17_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a17_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a18_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a18_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a19_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a19_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a20_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a20_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a21_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a21_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a22_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a22_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a23_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a23_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a24_around (JoinPoint *tjp) {
    ::CMatchSyntax::aspectof()->__a24_around (tjp);
  }
  template <class JoinPoint, class Binding>
  inline void invoke_CMatchSyntax_CMatchSyntax_a25_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::CMatchSyntax::aspectof()->__a25_before ((Puma::Config &)Arg0::val (tjp));
  }
} 


// introduce wildcard rules to CSyntax


// introduce wildcard rules to CCSyntax


// extend CBuilder



	 










/*****************************************************************************/
/*                                                                           */
/*                              wildcard rules                               */
/*                                                                           */
/*****************************************************************************/














	    














#endif /* __CMatchSyntax_ah__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ext_ac_syntax_cc_ah__
#define __ext_ac_syntax_cc_ah__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ext_ac_syntax_h_ah__
#define __ext_ac_syntax_h_ah__

// *************************
// C and CC-Syntax extension
// *************************

// new C and CC Syntax member functions




// *************************
// C and CC-Syntax extension
// *************************

class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class ExtACSyntaxCoupling {
public:
  static ExtACSyntaxCoupling *aspectof () {
    static ExtACSyntaxCoupling __instance;
    return &__instance;
  }
  static ExtACSyntaxCoupling *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;


  // relevant pointcuts
  
  

  // structural extensions
  
  
  
  // behavioral extensions
  
public: template<class JoinPoint> void __a0_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    tjp->that ()->_class_key_1.set (TOK_ASPECT);
  }
private:


  
public: template<class JoinPoint> void __a1_around (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    // 1: pointcut_decl
    // 1: advice_decl
    // 1: class_slice_decl
    if (tjp->that ()->parse (&__JP_That::pointcut_decl) ||
        tjp->that ()->parse (&__JP_That::advice_decl) ||
        tjp->that ()->parse (&__JP_That::class_slice_decl) ||
        tjp->that ()->parse (&__JP_That::class_slice_member_decl))
      *tjp->result () = tjp->that ()->builder ().block_decl ();
    else 
      tjp->proceed ();
  }
private:


  
public: template<class JoinPoint> void __a2_around (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    // 1: pointcut_member_decl
    // 1: advice_member_decl
    if (tjp->that ()->parse (&__JP_That::pointcut_member_decl) ||
        tjp->that ()->parse (&__JP_That::advice_member_decl) ||
        tjp->that ()->parse (&__JP_That::class_slice_decl)) 
      *tjp->result () = tjp->that ()->builder ().member_decl ();
    else 
      tjp->proceed ();
  }
private:

};
namespace AC {
  template <class JoinPoint>
  inline void invoke_ExtACSyntaxCoupling_ExtACSyntaxCoupling_a0_after (JoinPoint *tjp) {
    ::ExtACSyntaxCoupling::aspectof()->__a0_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_ExtACSyntaxCoupling_ExtACSyntaxCoupling_a1_around (JoinPoint *tjp) {
    ::ExtACSyntaxCoupling::aspectof()->__a1_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_ExtACSyntaxCoupling_ExtACSyntaxCoupling_a2_around (JoinPoint *tjp) {
    ::ExtACSyntaxCoupling::aspectof()->__a2_around (tjp);
  }
} 


#endif /* __ext_ac_syntax_h_ah__ */
// *************************
// C and CC-Syntax extension
// *************************



































#endif /* __ext_ac_syntax_cc_ah__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __WinMemberExplSpec__
#define __WinMemberExplSpec__

/********************************************************/
/* Win member template explicit specialization          */
/* support aspect                                       */
/********************************************************/


namespace Puma {
  class CCSyntax;
  class CTree;
} // namespace Puma


using namespace Puma;

namespace Puma {
  
}

class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class WinMemberExplSpec {
public:
  static WinMemberExplSpec *aspectof () {
    static WinMemberExplSpec __instance;
    return &__instance;
  }
  static WinMemberExplSpec *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /********************************************************/
  /* Win member template explicit specialization          */
  /********************************************************/

  // pointcut definitions
  

  // introduce new rule to class CCSyntax
  

  // try first to parse a member template explicit specialization
  
public: template<class JoinPoint> void __a0_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (thisJoinPoint->that ()->parse (&__JP_That::member_explicit_specialization)) {
      CTree *&result = *(CTree**)thisJoinPoint->result ();
      result = thisJoinPoint->that ()->builder ().get_node ();
    } else
      thisJoinPoint->action ().trigger ();
  }
private:


protected:
  WinMemberExplSpec () {}
};
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinMemberExplSpec_WinMemberExplSpec_a0_around (JoinPoint *tjp) {
    ::WinMemberExplSpec::aspectof()->__a0_around (tjp);
  }
} 


namespace Puma {
  

  
}

#endif /* __WinMemberExplSpec__ */

#ifndef __ac_fwd_CMatchSyntax__
#define __ac_fwd_CMatchSyntax__
class CMatchSyntax;
namespace AC {
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a0_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a1_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a3_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a4_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a5_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a6_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a7_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a8_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a9_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a10_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a11_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a12_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a13_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a14_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a15_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a16_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a17_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a18_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a19_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a20_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a21_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a22_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a23_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a24_around (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_CMatchSyntax_CMatchSyntax_a25_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#endif

#ifndef __ac_fwd_ExtACSyntaxCoupling__
#define __ac_fwd_ExtACSyntaxCoupling__
class ExtACSyntaxCoupling;
namespace AC {
  template <class JoinPoint>
  inline void invoke_ExtACSyntaxCoupling_ExtACSyntaxCoupling_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACSyntaxCoupling_ExtACSyntaxCoupling_a1_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACSyntaxCoupling_ExtACSyntaxCoupling_a2_around (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#endif

#ifndef __ac_fwd_WinMemberExplSpec__
#define __ac_fwd_WinMemberExplSpec__
class WinMemberExplSpec;
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinMemberExplSpec_WinMemberExplSpec_a0_around (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#endif

#ifndef __ac_fwd_ExtGnu__
#define __ac_fwd_ExtGnu__
class ExtGnu;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a0_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a1_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a2_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a3_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a4_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a5_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a6_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a7_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a8_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a9_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a10_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a11_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a12_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a13_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a14_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a15_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#endif

#ifndef __ac_fwd_WinAsm__
#define __ac_fwd_WinAsm__
class WinAsm;
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinAsm_WinAsm_a0_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#endif

#ifndef __ac_fwd_WinDeclSpecs__
#define __ac_fwd_WinDeclSpecs__
class WinDeclSpecs;
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinDeclSpecs_WinDeclSpecs_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_WinDeclSpecs_WinDeclSpecs_a1_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_WinDeclSpecs_WinDeclSpecs_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_WinDeclSpecs_WinDeclSpecs_a3_around (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CCSyntax_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CCSyntax_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CCSyntax_h__
#define __CCSyntax_h__

// Parser for the C++ programming language


#ifndef __ac_fwd_CMatchSyntax__
#define __ac_fwd_CMatchSyntax__
class CMatchSyntax;
namespace AC {
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a0_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a1_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a3_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a4_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a5_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a6_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a7_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a8_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a9_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a10_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a11_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a12_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a13_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a14_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a15_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a16_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a17_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a18_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a19_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a20_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a21_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a22_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a23_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_CMatchSyntax_CMatchSyntax_a24_around (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_CMatchSyntax_CMatchSyntax_a25_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#endif

#ifndef __ac_fwd_ExtACSyntaxCoupling__
#define __ac_fwd_ExtACSyntaxCoupling__
class ExtACSyntaxCoupling;
namespace AC {
  template <class JoinPoint>
  inline void invoke_ExtACSyntaxCoupling_ExtACSyntaxCoupling_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACSyntaxCoupling_ExtACSyntaxCoupling_a1_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACSyntaxCoupling_ExtACSyntaxCoupling_a2_around (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#endif

#ifndef __ac_fwd_ExtGnu__
#define __ac_fwd_ExtGnu__
class ExtGnu;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a0_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a1_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a2_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a3_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a4_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a5_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a6_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a7_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a8_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a9_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a10_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a11_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a12_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a13_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a14_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a15_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#endif

#ifndef __ac_fwd_WinAsm__
#define __ac_fwd_WinAsm__
class WinAsm;
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinAsm_WinAsm_a0_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#endif

#ifndef __ac_fwd_WinDeclSpecs__
#define __ac_fwd_WinDeclSpecs__
class WinDeclSpecs;
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinDeclSpecs_WinDeclSpecs_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_WinDeclSpecs_WinDeclSpecs_a1_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_WinDeclSpecs_WinDeclSpecs_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_WinDeclSpecs_WinDeclSpecs_a3_around (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#endif

#ifndef __ac_fwd_WinTypeKeywords__
#define __ac_fwd_WinTypeKeywords__
class WinTypeKeywords;
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinTypeKeywords_WinTypeKeywords_a0_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ext_gnu_h__
#define __ext_gnu_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CCExprResolveH_ah__
#define __CCExprResolveH_ah__

// This aspect inserts resolve member functions into all syntax tree classes
// that represent expressions. As the function is virtual, an efficient
// run-time switch over the node type is implemented.

namespace Puma {
  class CCSemExpr;
}

using namespace Puma;

namespace Puma {
  
  
}

class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CExprResolve;
class CCExprResolve {
public:
  static CCExprResolve *aspectof () {
    static CCExprResolve __instance;
    return &__instance;
  }
  static CCExprResolve *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CExprResolve;

  
  
};
namespace AC {
} 


#endif /* __CCExprResolveH_ah__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CExprResolveH_ah__
#define __CExprResolveH_ah__

// This aspect inserts resolve member functions into all syntax tree classes
// that represent expressions. As the function is virtual, an efficient
// run-time switch over the node type is implemented.

namespace Puma {
  class CSemExpr;
}

using namespace Puma;

namespace Puma {
  
  
}

class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve {
public:
  static CExprResolve *aspectof () {
    static CExprResolve __instance;
    return &__instance;
  }
  static CExprResolve *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;

  
  
};
namespace AC {
} 


#endif /* __CExprResolveH_ah__ */
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_GnuCTree_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_GnuCTree_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __gnu_c_tree_h__
#define __gnu_c_tree_h__

namespace Puma {

// Syntax tree node hierarchy:
class   CT_GnuAsmDef;        // derived from CT_AsmDef
class   CT_GnuAsmOperand;    // derived from CTree
class     CT_GnuAsmOperands; // derived from CT_List
class     CT_GnuAsmClobbers; // derived from CT_List
class   CT_GnuStatementExpr; // derived from CT_Expression

} // namespace Puma


#ifndef __ac_fwd_ExtACTree__
#define __ac_fwd_ExtACTree__
class ExtACTree;
namespace AC {
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a1_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ExtACTree_ah__
#define __ExtACTree_ah__

// TODO:
// this shall be introduced by the ExtAC aspect as soon as the include cycle
// problem is solved!

namespace Puma {
  class CTree;
}

using namespace Puma;

class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class ExtACTree {
public:
  static ExtACTree *aspectof () {
    static ExtACTree __instance;
    return &__instance;
  }
  static ExtACTree *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  
  
  // implemented in a separate .cc file, because Builder.h is needed!
  void delete_tree (CTree *t);
  
  
  
  
public: template<class JoinPoint> void __a0_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    tjp->that ()->_intro_members = 0;
  }
private:

  
public: template<class JoinPoint> void __a1_before (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    delete_tree (tjp->that ()->_intro_members);
  }
private:

};
namespace AC {
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a0_after (JoinPoint *tjp) {
    ::ExtACTree::aspectof()->__a0_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a1_before (JoinPoint *tjp) {
    ::ExtACTree::aspectof()->__a1_before (tjp);
  }
} 


#endif // __ExtACTree_ah__
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTree_h__
#define __CTree_h__

namespace Puma {


// Syntax tree node hierarchy:
class CTree;
class   CT_Statement;          
class     CT_LabelStmt;
class     CT_IfStmt;
class     CT_IfElseStmt;
class     CT_SwitchStmt;
class     CT_BreakStmt;
class     CT_ExprStmt;
class     CT_WhileStmt;
class     CT_DoStmt;
class     CT_ForStmt;
class     CT_ContinueStmt;
class     CT_ReturnStmt;
class     CT_GotoStmt;
class     CT_DeclStmt;
class     CT_CaseStmt;
class     CT_DefaultStmt;
class     CT_TryStmt;
class   CT_Expression;
class     CT_ThrowExpr;
class     CT_NewExpr;
class     CT_DeleteExpr;
class     CT_ConstructExpr;
class     CT_Integer;
class     CT_Character;
class       CT_WideCharacter;
class     CT_Float;
class     CT_Bool;
class     CT_BracedExpr;
class     CT_BinaryExpr;
class       CT_MembPtrExpr;
class         CT_MembRefExpr;
class     CT_UnaryExpr;
class       CT_PostfixExpr;
class       CT_AddrExpr;
class       CT_DerefExpr;
class     CT_IfThenExpr;
class     CT_CmpdLiteral;
class     CT_IndexExpr;
class     CT_CallExpr;
class     CT_CastExpr;
class     CT_StaticCast;
class       CT_ConstCast;
class       CT_ReintCast;
class       CT_DynamicCast;
class     CT_TypeidExpr;
class     CT_SizeofExpr;
class     CT_MembDesignator;
class     CT_IndexDesignator;
class     CT_ImplicitCast;
class   CT_DeclSpec;
class     CT_PrimDeclSpec;
class     CT_NamedType;
class     CT_ClassSpec;
class       CT_UnionSpec;
class       CT_EnumSpec;
class     CT_ExceptionSpec;
class   CT_Declarator;
class     CT_InitDeclarator;
class     CT_BracedDeclarator;
class     CT_ArrayDeclarator;
class     CT_FctDeclarator;
class     CT_RefDeclarator;
class     CT_PtrDeclarator;
class     CT_MembPtrDeclarator;
class     CT_BitFieldDeclarator;
class   CT_Decl;
class     CT_ObjDecl;
class     CT_ArgDecl;
class     CT_AccessDecl;
class       CT_UsingDecl;
class     CT_FctDef;
class     CT_AsmDef;
class     CT_EnumDef;
class     CT_ClassDef;
class       CT_UnionDef;
class     CT_Enumerator;
class     CT_LinkageSpec;
class     CT_Handler;
class     CT_TemplateDecl;
class     CT_TemplateParamDecl;
class       CT_TypeParamDecl;
class       CT_NonTypeParamDecl;
class     CT_NamespaceDef;
class     CT_NamespaceAliasDef;
class     CT_UsingDirective;
class   CT_List;
class     CT_CmpdStmt;
class     CT_DeclSpecSeq;
class     CT_HandlerSeq;
class     CT_DesignatorSeq;
class     CT_DeclList;
class       CT_Program;
class       CT_ArgDeclList;
class         CT_ArgNameList;
class       CT_ArgDeclSeq;
class       CT_MembList;
class     CT_ExprList;
class     CT_DeclaratorList;
class     CT_BaseSpecList;
class     CT_MembInitList;
class     CT_SimpleName;
class       CT_SpecialName;
class         CT_PrivateName;
class         CT_OperatorName;
class         CT_DestructorName;
class         CT_ConversionName;
class         CT_TemplateName;
class       CT_QualName;
class         CT_RootQualName;
class     CT_String;
class       CT_WideString;
class     CT_TemplateParamList;
class     CT_TemplateArgList;
class   CT_Token;
class   CT_Error;
class   CT_Condition;
class   CT_BaseSpec;
class   CT_AccessSpec;
class   CT_ArrayDelimiter;
class   CT_Any;
class   CT_AnyList;
class   CT_AnyExtension;
class   CT_AnyCondition;


} // namespace Puma

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CSemObject_h__
#define __CSemObject_h__

namespace Puma {


class CObjectInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CObjectInfo *_obj;

public:
  CSemObject () : _obj ((CObjectInfo*)0) {}
  void Object (CObjectInfo *o) { _obj = o; }
  /*virtual*/ CObjectInfo *Object () const { return _obj; }
};


} // namespace Puma

#endif /* __CSemObject_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CSemScope_h__
#define __CSemScope_h__

namespace Puma {


class CStructure;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CStructure *_scope;

public:
  CSemScope () : _scope ((CStructure*)0) {}
  void Scope (CStructure *s) { _scope = s; }
  CStructure *Scope () const { return _scope; }
};


} // namespace Puma

#endif /* __CSemScope_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CSemValue_h__
#define __CSemValue_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CExprValue_h__
#define __CExprValue_h__

using std::ostream;

namespace Puma {


class CTypeInfo;
class CConstant;
class CStrLiteral;
class CWStrLiteral;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CExprValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTypeInfo *_type;
  
protected:
  CExprValue (CTypeInfo *t) : _type (t) {}
  
public:
  virtual ~CExprValue () {}

  CTypeInfo *Type () const { return _type; }
  virtual void print (ostream &out) const = 0;
  
  virtual CConstant *Constant () const { return (CConstant*)0; }
  virtual CStrLiteral *StrLiteral () const { return (CStrLiteral*)0; }
  virtual CWStrLiteral *WStrLiteral () const { return (CWStrLiteral*)0; }
};

inline ostream& operator << (ostream &out, const CExprValue &ev) {
  ev.print (out);
  return out;
}

} // namespace Puma

#endif /* __CExprValue_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeInfo_h__
#define __CTypeInfo_h__

namespace Puma {


class CClassDatabase;
class CRecord;
class CClassInfo;
class CUnionInfo;
class CEnumInfo;
class CFunctionInfo;
class CTypeList;
class CTypeQualified;
class CTypeFunction;
class CTypeBitField; 
class CTypePointer; 
class CTypeMemberPointer; 
class CTypeTemplateParam; 
class CTypeAddress; 
class CTypeArray; 
class CTypeVarArray;
class CTypeClass;
class CTypeUnion;
class CTypeEnum;
class CTypePrimitive;
class CTypeRecord;
class CT_ExprList;
class CObjectInfo;
class CScopeInfo;
//class ostream;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeInfo : public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  // needed for type printing
  enum PrintState {
    PRINT_STD = 0,  // standard
    PRINT_PRE = 1,  // printing a declarator prefix like '*' or '&'
    PRINT_ABS = 2,  // printing absolute names
    PRINT_TPL = 4,  // printing template argument list
    PRINT_TDN = 8   // print typedef names instead of defined type
  };

public:
  enum TypeId {
    /* DO NOT CHANGE THIS ORDER */
    TYPE_BOOL,
    TYPE_SIGNED_CHAR,
    TYPE_UNSIGNED_CHAR,
    TYPE_CHAR,
    TYPE_UNSIGNED_SHORT,
    TYPE_SHORT,
    TYPE_UNSIGNED_INT,
    TYPE_WCHAR_T,
    TYPE_INT,
    TYPE_UNSIGNED_LONG,
    TYPE_LONG,
    TYPE_UNSIGNED_LONG_LONG,
    TYPE_LONG_LONG,
    TYPE_FLOAT,
    TYPE_DOUBLE,
    TYPE_LONG_DOUBLE,

    TYPE_VOID,
    TYPE_UNDEFINED,
    TYPE_UNKNOWN_T,
    TYPE_ELLIPSIS,
    
    TYPE_CLASS,
    TYPE_UNION,
    TYPE_ENUM,
    TYPE_POINTER,
    TYPE_ADDRESS,
    TYPE_MEMBER_POINTER,
    TYPE_FUNCTION,
    TYPE_ARRAY,
    TYPE_VAR_ARRAY,
    TYPE_QUALIFIED,
    TYPE_BIT_FIELD,
    
    TYPE_TEMPLATE_PARAM,
    TYPE_EMPTY
  };
  
  // internal representation of size_t and ptrdiff_t types
  static CTypeInfo *CTYPE_SIZE_T;
  static CTypeInfo *CTYPE_PTRDIFF_T;

private:
  CTypeInfo   *_Base;
  TypeId       _Id;
  CObjectInfo *_TypedefInfo;

public:
  CTypeInfo (CTypeInfo *, TypeId);
  ~CTypeInfo ();

  bool operator ==(const CTypeInfo &) const;
  bool operator !=(const CTypeInfo &) const;
  
  void print (ostream& os) const;
  void TypeText (ostream &, const char * = (const char*)0,
                 bool abs = false, bool tdef = false) const;
  long int Dimension () const;
  
  long int Size () const;
  long int Align () const;

  TypeId Id () const;

  CTypeInfo *BaseType () const;
  void BaseType (CTypeInfo *);

  bool isTypedef () const;
  CObjectInfo *TypedefInfo () const;
  CTypeInfo *TypedefInfo (CObjectInfo *);

  bool isComplete (unsigned long = 0) const;
  bool isConst () const;
  bool isVolatile () const;
  bool isRestrict () const;
  bool isDependent (bool = true) const;
  
  CRecord *Record () const;
  CClassInfo *ClassInfo () const;
  CUnionInfo *UnionInfo () const;
  CEnumInfo *EnumInfo () const;
  CFunctionInfo *FunctionInfo () const;

  CTypeInfo *PtrBaseType () const;
  CTypeList *ArgTypes () const;
  CTypeInfo *VirtualType () const;
  CTypeInfo *UnqualType () const;
    
  CTypeFunction *PtrToFct () const;
  CTypeArray *PtrToArray () const;
  
  CTypeQualified *TypeQualified () const;
  CTypeFunction *TypeFunction () const;
  CTypeBitField *TypeBitField () const; 
  CTypePointer *TypePointer () const; 
  CTypeMemberPointer *TypeMemberPointer () const; 
  CTypeAddress *TypeAddress () const; 
  CTypeArray *TypeArray () const; 
  CTypeVarArray *TypeVarArray () const;
  CTypeClass *TypeClass () const;
  CTypeUnion *TypeUnion () const;
  CTypeRecord *TypeRecord () const;
  CTypeEnum *TypeEnum () const;
  CTypePrimitive *TypePrimitive () const;
  CTypeInfo *TypeEmpty () const;
  CTypeTemplateParam *TypeTemplateParam () const;

  bool isQualified () const;
  bool isPointer () const;
  bool isPointerOrArray () const;
  bool isAddress () const;
  bool isRecord () const;
  bool isClass () const;
  bool isUnion () const;
  bool isArray () const;
  bool isFixedArray () const;
  bool isVarArray () const;
  bool isArithmetic () const;
  bool isScalar () const;
  bool isAggregate () const;
  bool isInteger () const;
  bool isVoid () const;
  bool isEnum () const;
  bool isReal () const;
  bool isMemberPointer () const;
  bool isUndefined () const;
  bool isFunction () const;
  bool isBitField () const;
  bool isMethod () const;
  bool isStdFunction () const;
  bool isTemplate () const;
  bool isTemplateInstance () const;
  bool isTemplateParam () const;
  bool isTypeParam () const;
  bool isNonTypeParam () const;
  bool isObject (unsigned long = 0) const;

  // Primitive types.
  bool is_bool () const;
  bool is_char () const;
  bool is_wchar_t () const;
  bool is_short () const;
  bool is_int () const;
  bool is_long () const;
  bool is_long_long () const;
  bool is_signed_char () const;
  bool is_unsigned_char () const;
  bool is_unsigned_short () const;
  bool is_unsigned_int () const;
  bool is_unsigned_long () const;
  bool is_unsigned_long_long () const;
  bool is_float () const;
  bool is_double () const;
  bool is_long_double () const;
  bool is_void () const;
  bool is_undefined () const;
  bool is_unknown_t () const;
  bool is_ellipsis () const;
  
  bool is_signed () const;
  bool is_unsigned () const;

  // arithmetic conversion rank (C only)
  unsigned conv_rank () const;
  // compare arithmetic types (C only)
  bool operator >(const CTypeInfo &) const;
  bool operator >=(const CTypeInfo &) const;
  bool operator <=(const CTypeInfo &) const;
  bool operator <(const CTypeInfo &) const;
  
  // rank C++ arithmetic types
  unsigned rank () const;
  
public:
  // Duplicate the given type structure.
#ifndef __puma // PUMA is confused by static and non-static declaration
  static
#endif
  CTypeInfo *Duplicate (const CTypeInfo *);
  // Duplicate this.
  CTypeInfo *Duplicate () const;

  // Destroy the given type structure.
  static void Destroy (CTypeInfo *);

  void Mangled (ostream &) const;

private:
  void TypeText (char, ostream &, const char * = (const char*)0) const;
  void printName (char, ostream &, CObjectInfo *) const;
  void printScope (char, ostream &, CObjectInfo *) const;
};

extern CTypeInfo CTYPE_EMPTY;

} // namespace Puma


// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypePrimitive_h__
#define __CTypePrimitive_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypePrimitive : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_Text;

public:
  CTypePrimitive (const char *, TypeId);
  ~CTypePrimitive ();
  
  const char *TypeName () const;
};

inline CTypePrimitive::CTypePrimitive (const char *t, CTypeInfo::TypeId id) :
  CTypeInfo (&CTYPE_EMPTY, id),
  _Text (t)
 {}
inline CTypePrimitive::~CTypePrimitive () 
 {}
 
inline const char *CTypePrimitive::TypeName () const
 { return _Text; }

// Basic types //////////////////////////////////////////////////

extern CTypePrimitive CTYPE_BOOL;
extern CTypePrimitive CTYPE_CHAR;
extern CTypePrimitive CTYPE_SIGNED_CHAR;
extern CTypePrimitive CTYPE_UNSIGNED_CHAR;
extern CTypePrimitive CTYPE_WCHAR_T;
extern CTypePrimitive CTYPE_SHORT;
extern CTypePrimitive CTYPE_UNSIGNED_SHORT;
extern CTypePrimitive CTYPE_INT;
extern CTypePrimitive CTYPE_UNSIGNED_INT;
extern CTypePrimitive CTYPE_LONG;
extern CTypePrimitive CTYPE_UNSIGNED_LONG;
extern CTypePrimitive CTYPE_LONG_LONG;
extern CTypePrimitive CTYPE_UNSIGNED_LONG_LONG;
extern CTypePrimitive CTYPE_FLOAT;
extern CTypePrimitive CTYPE_DOUBLE;
extern CTypePrimitive CTYPE_LONG_DOUBLE;
extern CTypePrimitive CTYPE_VOID;
extern CTypePrimitive CTYPE_UNKNOWN_T;
extern CTypePrimitive CTYPE_UNDEFINED;
extern CTypePrimitive CTYPE_ELLIPSIS;


} // namespace Puma

#endif /* __CTypePrimitive_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeQualified_h__
#define __CTypeQualified_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeQualified : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  bool _Const;
  bool _Volatile;
  bool _Restrict;

protected:
  CTypeQualified (CTypeInfo *, bool, bool, bool, TypeId);
  
public:
  CTypeQualified (CTypeInfo *, bool, bool, bool);
  ~CTypeQualified ();

  bool isConst () const;
  bool isVolatile () const;
  bool isRestrict () const;

  void isConst (bool);
  void isVolatile (bool);
  void isRestrict (bool);
};

inline CTypeQualified::CTypeQualified (CTypeInfo *base, bool c, bool v, bool r, 
 CTypeInfo::TypeId id) :
  CTypeInfo (base, id),
  _Const (c),
  _Volatile (v),
  _Restrict (r)
 {}
inline CTypeQualified::CTypeQualified (CTypeInfo *base, bool c, bool v, bool r) :
  CTypeInfo (base, CTypeInfo::TYPE_QUALIFIED),
  _Const (c),
  _Volatile (v),
  _Restrict (r)
 {}
inline CTypeQualified::~CTypeQualified ()
 {}
 
inline bool CTypeQualified::isConst () const
 { return _Const; }
inline bool CTypeQualified::isVolatile () const
 { return _Volatile; }
inline bool CTypeQualified::isRestrict () const
 { return _Restrict; }

inline void CTypeQualified::isConst (bool v)
 { _Const = v; }
inline void CTypeQualified::isVolatile (bool v)
 { _Volatile = v; }
inline void CTypeQualified::isRestrict (bool v)
 { _Restrict = v; }


} // namespace Puma

#endif /* __CTypeQualified_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeAddress_h__
#define __CTypeAddress_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeAddress : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CTypeAddress (CTypeInfo *);
  ~CTypeAddress ();
};

inline CTypeAddress::CTypeAddress (CTypeInfo *base) :
  CTypeInfo (base, CTypeInfo::TYPE_ADDRESS)
 {}
inline CTypeAddress::~CTypeAddress ()
 {}


} // namespace Puma

#endif /* __CTypeAddress_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeBitField_h__
#define __CTypeBitField_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeBitField : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  long int _Size;

public:
  CTypeBitField (CTypeInfo *);
  ~CTypeBitField ();

  void Dimension (long int);
  long int Dimension () const;
};

inline CTypeBitField::CTypeBitField (CTypeInfo *base) :
  CTypeInfo (base, CTypeInfo::TYPE_BIT_FIELD),
  _Size (0)
 {}
inline CTypeBitField::~CTypeBitField ()
 {}
 
inline void CTypeBitField::Dimension (long int v) 
 { _Size = v; }
inline long int CTypeBitField::Dimension () const
 { return _Size; }


} // namespace Puma

#endif /* __CTypeBitField_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeArray_h__
#define __CTypeArray_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeArray : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  long int _Size;
  bool _isFixed;
  CTypeQualified *_Quals;
  CTypeTemplateParam *_DepDim;

protected:
  CTypeArray (CTypeInfo *, CTypeQualified *, TypeId);
  
public:
  CTypeArray (CTypeInfo *, CTypeQualified * = 0);
  ~CTypeArray ();

  void Dimension (long int);
  long int Dimension () const;
  
  void isFixed (bool);
  bool isFixed () const;
  
  CTypeQualified *Qualifiers () const;
  
  void DepDim (CTypeTemplateParam *);
  CTypeTemplateParam *DepDim () const;
};

inline CTypeArray::CTypeArray (CTypeInfo *base, CTypeQualified *quals) :
  CTypeInfo (base, CTypeInfo::TYPE_ARRAY),
  _Size (0),
  _isFixed (false),
  _Quals (quals),
  _DepDim (0)
 {}
inline CTypeArray::CTypeArray (CTypeInfo *base, CTypeQualified *quals, CTypeInfo::TypeId id) :
  CTypeInfo (base, id),
  _Size (0),
  _isFixed (false),
  _Quals (quals),
  _DepDim (0)
 {}
inline CTypeArray::~CTypeArray ()
 { if (_Quals) CTypeInfo::Destroy (_Quals); }

inline void CTypeArray::Dimension (long int d)
 { _Size = d; }
inline long int CTypeArray::Dimension () const
 { return _Size; }

inline void CTypeArray::isFixed (bool v)
 { _isFixed = v; }
inline bool CTypeArray::isFixed () const
 { return _isFixed; }

inline CTypeQualified *CTypeArray::Qualifiers () const
 { return _Quals; }
 
inline void CTypeArray::DepDim (CTypeTemplateParam *tp) 
 { _DepDim = tp; }
inline CTypeTemplateParam *CTypeArray::DepDim () const
 { return _DepDim; }


} // namespace Puma

#endif /* __CTypeArray_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeVarArray_h__
#define __CTypeVarArray_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeVarArray : public CTypeArray {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CTypeVarArray (CTypeInfo *, CTypeQualified * = 0);
  ~CTypeVarArray ();
};

inline CTypeVarArray::CTypeVarArray (CTypeInfo *base, CTypeQualified *quals) :
  CTypeArray (base, quals, CTypeInfo::TYPE_VAR_ARRAY)
 {}
inline CTypeVarArray::~CTypeVarArray ()
 {}


} // namespace Puma

#endif /* __CTypeVarArray_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypePointer_h__
#define __CTypePointer_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypePointer : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CTypePointer (CTypeInfo *, CTypeInfo::TypeId);

public:
  CTypePointer (CTypeInfo *);
  ~CTypePointer ();
};

inline CTypePointer::CTypePointer (CTypeInfo *base) :
  CTypeInfo (base, CTypeInfo::TYPE_POINTER)
 {}
inline CTypePointer::CTypePointer (CTypeInfo *base, CTypeInfo::TypeId id) :
  CTypeInfo (base, id)
 {}
inline CTypePointer::~CTypePointer ()
 {}
 

} // namespace Puma

#endif /* __CTypePointer_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeMemberPointer_h__
#define __CTypeMemberPointer_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CObjectInfo;
class CRecord;
class CTemplateParamInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeMemberPointer : public CTypePointer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CObjectInfo *_Class;

public:
  CTypeMemberPointer (CTypeInfo *, CObjectInfo *);
  ~CTypeMemberPointer ();

  CRecord *Record () const;
  CTemplateParamInfo *TemplateParam () const;
};

inline CTypeMemberPointer::CTypeMemberPointer (CTypeInfo *base, CObjectInfo *c) :
  CTypePointer (base, CTypeInfo::TYPE_MEMBER_POINTER),
  _Class (c)
 {}
inline CTypeMemberPointer::~CTypeMemberPointer ()
 {}


} // namespace Puma

#endif /* __CTypeMemberPointer_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeFunction_h__
#define __CTypeFunction_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeList_h__
#define __CTypeList_h__

namespace Puma {


class CTypeInfo;
class CT_ArgDeclList;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeList {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Array<CTypeInfo*> _List;
  CT_ArgDeclList *_ArgumentList;

public:
  CTypeList (int len = 3);
  ~CTypeList ();

  unsigned Entries () const;
  CTypeInfo *Entry (unsigned) const;
  void ReplaceEntry (unsigned, CTypeInfo *);
  
  CT_ArgDeclList *ArgumentList () const;
  void ArgumentList (CT_ArgDeclList *);
  
  void AddEntry (CTypeInfo *);
  
  bool isDependent () const;
};

inline CTypeList::CTypeList (int len) :
  _List (len),
  _ArgumentList ((CT_ArgDeclList*)0)
 {}
inline CTypeList::~CTypeList ()
 {}

inline CT_ArgDeclList *CTypeList::ArgumentList () const
 { return _ArgumentList; }
inline void CTypeList::ArgumentList (CT_ArgDeclList *al)
 { _ArgumentList = al; }

inline unsigned CTypeList::Entries () const
 { return _List.length (); }
inline CTypeInfo *CTypeList::Entry (unsigned i) const
 { return _List.lookup (i); }
 
inline void CTypeList::AddEntry (CTypeInfo *info) 
 { if (info) _List.append (info); }
inline void CTypeList::ReplaceEntry (unsigned i, CTypeInfo *info)
 { if (info && (i < Entries ())) _List[i] = info; }


} // namespace Puma

#endif /* __CTypeList_h__ */
namespace Puma {


class CFunctionInfo;
class CRecord;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeFunction : public CTypeQualified {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTypeList *_ArgTypes;
  CFunctionInfo *_Function;
  bool _hasPrototype;

public:
  CTypeFunction (CTypeInfo *, CTypeList *, bool);
  ~CTypeFunction ();

  CTypeList *ArgTypes () const;
  CTypeInfo *ReturnType () const;  

  CFunctionInfo *FunctionInfo () const;
  CRecord *Record () const;

  bool hasPrototype () const;
  void FunctionInfo (CFunctionInfo *);
  
  bool isStatic () const;
};

inline CTypeFunction::CTypeFunction (CTypeInfo *base, CTypeList *l, 
  bool prototype) :
  CTypeQualified (base, false, false, false, CTypeInfo::TYPE_FUNCTION),
  _ArgTypes (l),
  _Function (0),
  _hasPrototype (prototype)
 {}
inline CTypeFunction::~CTypeFunction ()
 {}
 
inline bool CTypeFunction::hasPrototype () const
 { return _hasPrototype; }
inline CTypeList *CTypeFunction::ArgTypes () const 
 { return _ArgTypes; }
inline CTypeInfo *CTypeFunction::ReturnType () const 
 { return BaseType (); }
inline CFunctionInfo *CTypeFunction::FunctionInfo () const 
 { return _Function; }
inline void CTypeFunction::FunctionInfo (CFunctionInfo *info)
 { _Function = info; }


} // namespace Puma

#endif /* __CTypeFunction_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeEnum_h__
#define __CTypeEnum_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CEnumInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeEnum : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CEnumInfo *_Enum;

public:
  CTypeEnum (CEnumInfo *);
  ~CTypeEnum ();

  CEnumInfo *EnumInfo () const;
  bool isComplete (unsigned long = 0) const;
};

inline CTypeEnum::CTypeEnum (CEnumInfo *e) :
  CTypeInfo (&CTYPE_EMPTY, CTypeInfo::TYPE_ENUM),
  _Enum (e)
 {}
inline CTypeEnum::~CTypeEnum ()
 {}
 
inline CEnumInfo *CTypeEnum::EnumInfo () const 
 { return _Enum; }
 

} // namespace Puma

#endif /* __CTypeEnum_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeRecord_h__
#define __CTypeRecord_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CRecord;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeRecord : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  bool _hasConstMember;

  long int _Size;
  long int _Align;

  CRecord *_Record;

protected:
  CTypeRecord (TypeId, CRecord *);

public:
  ~CTypeRecord ();

  long int Size ();
  long int Align ();

  void hasConstMember (bool);
  bool hasConstMember () const;

  bool isComplete (unsigned long = 0) const;

  CRecord *Record () const;
  void Record (CRecord *);
};

inline CTypeRecord::CTypeRecord (CTypeInfo::TypeId id, CRecord *r) :
  CTypeInfo (&CTYPE_EMPTY, id),
  _hasConstMember (false),
  _Size (0),
  _Align (0),
  _Record (r)
 {}
inline CTypeRecord::~CTypeRecord ()
 {}

inline CRecord *CTypeRecord::Record () const 
 { return _Record; }
inline void CTypeRecord::Record (CRecord *r)
 { _Record = r; }

inline long int CTypeRecord::Align () 
 { return (Size (), _Align); }

inline bool CTypeRecord::hasConstMember () const
 { return _hasConstMember; }
inline void CTypeRecord::hasConstMember (bool v)
 { _hasConstMember = v; }


} // namespace Puma

#endif /* __CTypeRecord_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeClass_h__
#define __CTypeClass_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CClassInfo;
class CRecord;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeClass : public CTypeRecord {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CTypeClass (CRecord *);
  ~CTypeClass ();

  CClassInfo *ClassInfo () const;
};

inline CTypeClass::CTypeClass (CRecord *c) :
  CTypeRecord (CTypeInfo::TYPE_CLASS, c)
 {}
inline CTypeClass::~CTypeClass ()
 {}
 

} // namespace Puma

#endif /* __CTypeClass_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeUnion_h__
#define __CTypeUnion_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CUnionInfo;
class CRecord;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeUnion : public CTypeRecord {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CTypeUnion (CRecord *);
  ~CTypeUnion ();
  
  CUnionInfo *UnionInfo () const;
};

inline CTypeUnion::CTypeUnion (CRecord *u) :
  CTypeRecord (CTypeInfo::TYPE_UNION, u)
 {}
inline CTypeUnion::~CTypeUnion ()
 {}


} // namespace Puma

#endif /* __CTypeUnion_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeTemplateParam_h__
#define __CTypeTemplateParam_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CTemplateParamInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeTemplateParam : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTemplateParamInfo *_TemplateParam;

public:
  CTypeTemplateParam (CTemplateParamInfo *);
  ~CTypeTemplateParam ();

  CTemplateParamInfo *TemplateParamInfo () const;
  bool isType () const;
  bool isNonType () const;
};

inline CTypeTemplateParam::CTypeTemplateParam (CTemplateParamInfo *t) :
  CTypeInfo (&CTYPE_EMPTY, CTypeInfo::TYPE_TEMPLATE_PARAM),
  _TemplateParam (t)
 {}
inline CTypeTemplateParam::~CTypeTemplateParam ()
 {}
 
inline CTemplateParamInfo *CTypeTemplateParam::TemplateParamInfo () const 
 { return _TemplateParam; }
 
inline bool CTypeTemplateParam::isNonType () const
 { return (! isType ()); }


} // namespace Puma

#endif /* __CTypeTemplateParam_h__ */
namespace Puma {

inline CTypeInfo::CTypeInfo (CTypeInfo *info, CTypeInfo::TypeId id) :
  _Base (info ? info : this), 
  _Id (id),
  _TypedefInfo (0)
 {}
inline CTypeInfo::~CTypeInfo () 
 {}

inline CTypeInfo *CTypeInfo::Duplicate () const 
 { 
#ifndef __puma
return Duplicate (this);
#endif
 }

inline CTypeInfo::TypeId CTypeInfo::Id () const 
 { return _Id; }

inline bool CTypeInfo::operator !=(const CTypeInfo &type) const 
 { return ! (*this == type); }

inline void CTypeInfo::print (ostream& out) const 
 { TypeText ((char)PRINT_STD, out); }
inline void CTypeInfo::TypeText (ostream &out, const char *t, bool abs, bool tdef) const
 { char flags = (char)(abs ? PRINT_ABS : PRINT_STD);
   if (tdef) flags |= (char)PRINT_TDN; TypeText (flags, out, t); }

inline long int CTypeInfo::Dimension () const
 { return TypeArray () ? TypeArray ()->Dimension () : 
          TypeBitField () ? TypeBitField ()->Dimension () : -1; }
 
inline bool CTypeInfo::isTypedef () const
 { return (bool)_TypedefInfo; }
inline CObjectInfo *CTypeInfo::TypedefInfo () const
 { return _TypedefInfo; }

inline bool CTypeInfo::isConst () const
 { return TypeQualified () && TypeQualified ()->isConst (); }
inline bool CTypeInfo::isVolatile () const
 { return TypeQualified () && TypeQualified ()->isVolatile (); }
inline bool CTypeInfo::isRestrict () const
 { return TypeQualified () && TypeQualified ()->isRestrict (); }
  
inline CRecord *CTypeInfo::Record () const
 { return TypeRecord () ? TypeRecord ()->Record () :
          TypeFunction () ? TypeFunction ()->Record () :
          TypeMemberPointer () ? TypeMemberPointer ()->Record () : (CRecord*)0; }
inline CEnumInfo *CTypeInfo::EnumInfo () const
 { return TypeEnum () ? TypeEnum ()->EnumInfo () : (CEnumInfo*)0; }
inline CFunctionInfo *CTypeInfo::FunctionInfo () const
 { return TypeFunction () ? TypeFunction ()->FunctionInfo () : (CFunctionInfo*)0; }

inline CTypeInfo *CTypeInfo::BaseType () const
 { assert(_Base); return _Base; }
inline void CTypeInfo::BaseType (CTypeInfo *type)
 { _Base = type; }
inline CTypeInfo *CTypeInfo::PtrBaseType () const
 { return VirtualType ()->BaseType (); }

inline CTypeList *CTypeInfo::ArgTypes () const
 { return TypeFunction () ? TypeFunction ()->ArgTypes () :
          TypeQualified () ? TypeQualified ()->ArgTypes () : (CTypeList*)0; }

inline CTypePrimitive *CTypeInfo::TypePrimitive () const
 { return _Id < TYPE_CLASS ? (CTypePrimitive*)this : (CTypePrimitive*)0; }
inline CTypeQualified *CTypeInfo::TypeQualified () const
 { return _Id == TYPE_QUALIFIED ? (CTypeQualified*)this : (CTypeQualified*)0; }
inline CTypeFunction *CTypeInfo::TypeFunction () const
 { return _Id == TYPE_FUNCTION ? (CTypeFunction*)this : (CTypeFunction*)0; }
inline CTypeBitField *CTypeInfo::TypeBitField () const 
 { return _Id == TYPE_BIT_FIELD ? (CTypeBitField*)this : (CTypeBitField*)0; }
inline CTypePointer *CTypeInfo::TypePointer () const
 { return _Id == TYPE_POINTER || _Id == TYPE_MEMBER_POINTER ? (CTypePointer*)this : (CTypePointer*)0; }
inline CTypeMemberPointer* CTypeInfo::TypeMemberPointer () const
 { return _Id == TYPE_MEMBER_POINTER ? (CTypeMemberPointer*)this : (CTypeMemberPointer*)0; }
inline CTypeAddress *CTypeInfo::TypeAddress () const
 { return _Id == TYPE_ADDRESS ? (CTypeAddress*)this : (CTypeAddress*)0; }
inline CTypeArray *CTypeInfo::TypeArray () const
 { return _Id == TYPE_ARRAY || _Id == TYPE_VAR_ARRAY ? (CTypeArray*)this : (CTypeArray*)0; }
inline CTypeVarArray *CTypeInfo::TypeVarArray () const
 { return _Id == TYPE_VAR_ARRAY ? (CTypeVarArray*)this : (CTypeVarArray*)0; }
inline CTypeRecord *CTypeInfo::TypeRecord () const
 { return _Id == TYPE_CLASS || _Id == TYPE_UNION ? (CTypeRecord*)this : (CTypeRecord*)0; }
inline CTypeClass *CTypeInfo::TypeClass () const
 { return _Id == TYPE_CLASS ? (CTypeClass*)this : (CTypeClass*)0; }
inline CTypeUnion *CTypeInfo::TypeUnion () const
 { return _Id == TYPE_UNION ? (CTypeUnion*)this : (CTypeUnion*)0; }
inline CTypeEnum *CTypeInfo::TypeEnum () const
 { return _Id == TYPE_ENUM ? (CTypeEnum*)this : (CTypeEnum*)0; }
inline CTypeInfo *CTypeInfo::TypeEmpty () const
 { return _Id == TYPE_EMPTY ? (CTypeInfo*)this : (CTypeInfo*)0; }
inline CTypeTemplateParam *CTypeInfo::TypeTemplateParam () const
 { return _Id == TYPE_TEMPLATE_PARAM ? (CTypeTemplateParam*)this : (CTypeTemplateParam*)0; }

inline CTypeInfo *CTypeInfo::VirtualType () const 
 { return TypeQualified () || TypeBitField () || TypeAddress () ?
          BaseType ()->VirtualType () : (CTypeInfo*)this; }
inline CTypeInfo *CTypeInfo::UnqualType () const 
 { return TypeQualified () ? BaseType ()->UnqualType () : (CTypeInfo*)this; }

inline bool CTypeInfo::isQualified () const 
 { return TypeQualified (); }
inline bool CTypeInfo::isTemplateParam () const 
 { return VirtualType ()->TypeTemplateParam (); }
inline bool CTypeInfo::isPointer () const 
 { return VirtualType ()->TypePointer (); }
inline bool CTypeInfo::isMemberPointer () const
 { return VirtualType ()->TypeMemberPointer (); }
inline bool CTypeInfo::isClass () const
 { return VirtualType ()->TypeClass (); }
inline bool CTypeInfo::isUnion () const
 { return VirtualType ()->TypeUnion (); }
inline bool CTypeInfo::isArray () const
 { return VirtualType ()->TypeArray (); }
inline bool CTypeInfo::isFixedArray () const
 { return VirtualType ()->TypeArray () && 
          VirtualType ()->TypeArray ()->isFixed (); }
inline bool CTypeInfo::isVarArray () const
 { return VirtualType ()->TypeVarArray (); }
inline bool CTypeInfo::isEnum () const
 { return VirtualType ()->TypeEnum (); }
inline bool CTypeInfo::isFunction () const
 { return VirtualType ()->TypeFunction (); }
inline bool CTypeInfo::isBitField () const
 { return TypeBitField (); }
inline bool CTypeInfo::isUndefined () const
 { return VirtualType ()->is_undefined (); }
inline bool CTypeInfo::isInteger () const 
 { return VirtualType ()->_Id < TYPE_FLOAT || VirtualType ()->isEnum (); }
inline bool CTypeInfo::isReal () const 
 { CTypeInfo *base = VirtualType ();
   return base->is_float () || base->is_double () || base->is_long_double (); }
inline bool CTypeInfo::isMethod () const 
 { CTypeInfo *base = VirtualType ();
   return base->TypeFunction () && base->TypeFunction ()->Record (); }
inline bool CTypeInfo::isStdFunction () const
 { return VirtualType ()->TypeFunction () && ! isMethod (); }
inline bool CTypeInfo::isPointerOrArray () const 
 { CTypeInfo *base = VirtualType ();
   return base->TypePointer () || base->TypeArray (); }
inline bool CTypeInfo::isAddress () const 
 { return TypeAddress () || ((TypeQualified () || TypeBitField ()) && 
                             BaseType ()->isAddress ()); }
inline bool CTypeInfo::isRecord () const 
 { return VirtualType ()->TypeRecord (); }
inline bool CTypeInfo::isScalar () const 
 { return isArithmetic () || isPointer (); }
inline bool CTypeInfo::isAggregate () const 
 { return isArray () || isClass () || isUnion (); }
inline bool CTypeInfo::isVoid () const
 { return VirtualType ()->is_void (); }
inline bool CTypeInfo::isObject (unsigned long pos) const
 { return ! isFunction () && (pos ? isComplete (pos) : true); }
inline bool CTypeInfo::isTypeParam () const
 { return isTemplateParam () && 
          VirtualType ()->TypeTemplateParam ()->isType (); }
inline bool CTypeInfo::isNonTypeParam () const
 { return isTemplateParam () && 
          ! VirtualType ()->TypeTemplateParam ()->isType (); }

inline bool CTypeInfo::is_bool () const 
 { return _Id == TYPE_BOOL; }
inline bool CTypeInfo::is_char () const 
 { return _Id == TYPE_CHAR; }
inline bool CTypeInfo::is_wchar_t () const 
 { return _Id == TYPE_WCHAR_T; }
inline bool CTypeInfo::is_short () const 
 { return _Id == TYPE_SHORT; }
inline bool CTypeInfo::is_int () const 
 { return _Id == TYPE_INT; }
inline bool CTypeInfo::is_long () const 
 { return _Id == TYPE_LONG; }
inline bool CTypeInfo::is_long_long () const 
 { return _Id == TYPE_LONG_LONG; }
inline bool CTypeInfo::is_signed_char () const 
 { return _Id == TYPE_SIGNED_CHAR; }
inline bool CTypeInfo::is_unsigned_char () const 
 { return _Id == TYPE_UNSIGNED_CHAR; }
inline bool CTypeInfo::is_unsigned_short () const 
 { return _Id == TYPE_UNSIGNED_SHORT; }
inline bool CTypeInfo::is_unsigned_int () const 
 { return _Id == TYPE_UNSIGNED_INT; }
inline bool CTypeInfo::is_unsigned_long () const 
 { return _Id == TYPE_UNSIGNED_LONG; }
inline bool CTypeInfo::is_unsigned_long_long () const 
 { return _Id == TYPE_UNSIGNED_LONG_LONG; }
inline bool CTypeInfo::is_float () const 
 { return _Id == TYPE_FLOAT; }
inline bool CTypeInfo::is_double () const 
 { return _Id == TYPE_DOUBLE; }
inline bool CTypeInfo::is_long_double () const 
 { return _Id == TYPE_LONG_DOUBLE; }
inline bool CTypeInfo::is_void () const 
 { return _Id == TYPE_VOID; }
inline bool CTypeInfo::is_unknown_t () const 
 { return _Id == TYPE_UNKNOWN_T; }
inline bool CTypeInfo::is_undefined () const 
 { return _Id == TYPE_UNDEFINED; }
inline bool CTypeInfo::is_ellipsis () const 
 { return _Id == TYPE_ELLIPSIS; }

inline bool CTypeInfo::operator <=(const CTypeInfo &type) const
 { return ! (*this > type); }
inline bool CTypeInfo::operator >=(const CTypeInfo &type) const
 { return ! (*this < type); }


} // namespace Puma

#endif /* __CTypeInfo_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  bool value_ref;
  bool type_ref;

protected:
  CExprValue *value;
  CTypeInfo *type;

public:
  CSemValue ();
  virtual ~CSemValue ();

  void setValue (CExprValue *);
  void setValueRef (CExprValue *);
  void setType (CTypeInfo *);
  void setTypeRef (CTypeInfo *);
};

inline CSemValue::CSemValue () : 
  value_ref (false),
  type_ref (true),
  value ((CExprValue*)0), 
  type (&CTYPE_UNDEFINED)
 {}
inline CSemValue::~CSemValue () 
 { if (value && ! value_ref) delete value; 
   if (type && ! type_ref) CTypeInfo::Destroy (type); }

inline void CSemValue::setValue (CExprValue *v) 
 { if (value && ! value_ref) delete value; 
   value = v; value_ref = false; }
inline void CSemValue::setValueRef (CExprValue *v) 
 { if (value && ! value_ref) delete value; 
   value = v; value_ref = true; }

inline void CSemValue::setType (CTypeInfo *t) 
 { if (type && ! type_ref) CTypeInfo::Destroy (type); 
   type = t; type_ref = false; }
inline void CSemValue::setTypeRef (CTypeInfo *t) 
 { if (type && ! type_ref) CTypeInfo::Destroy (type); 
   type = t; type_ref = true; }


} // namespace Puma

#endif /* __CSemValue_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CStrLiteral_h__
#define __CStrLiteral_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CStrLiteral : public CExprValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_string;
  unsigned long _len;
  
public:
  CStrLiteral (const char *s, unsigned long len, CTypeInfo *t) : 
    CExprValue (t), _string (s), _len (len) {}
  virtual ~CStrLiteral () { if (_string) delete[] _string; }

  virtual void print (ostream &out) const { out << "\"" << String () << "\""; }
  const char *String () const { return _string; }
  unsigned long Length () const { return _len; }

  CStrLiteral *StrLiteral () const { return (CStrLiteral*)this; }
};


} // namespace Puma

#endif /* __CStrLiteral_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Token_h__
#define __Token_h__

// Abstract interface of a language token. A token is created by an
// invocation of a scanner's 'scan' method. The token encapsulates a
// lexical unit of the scanned text.

#include <stdlib.h>
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __language_id_h__
#define __language_id_h__

// A language ID is a unique identifier for a language

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class LanguageID {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_id;

public:
  LanguageID () : _id ((const char*)0) {}
  LanguageID (const char *id) : _id (id) {}
  operator const char *() const { return _id; }
  bool operator == (const LanguageID &id) const
   { return _id == (const char*)id; }
};


} // namespace Puma

#endif /* __language_id_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __list_element_h__
#define __list_element_h__

// Base class for objects that may be inserted into a List. Lists
// autonomously delete or copy list element. So it's necessary to
// define a destructor and a duplicate method in the derived
// classes.

#include <assert.h>

namespace Puma {


class List;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ListElement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  friend class List;

  List        *_belonging_to;
  ListElement *_next;
  ListElement *_prev;

public:
  ListElement () : _belonging_to ((List*)0) {}
  virtual ~ListElement () { assert (! _belonging_to); };

  virtual ListElement *duplicate () = 0;
  List *belonging_to () const { return _belonging_to; }
};


} // namespace Puma

#endif /* __list_element_h__ */
#include <assert.h>
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Token : public ListElement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _type, _real_type;

  Location _location;
  LanguageID _language;
  DString _text;

  Array<int> *_cont_lines;
   
  enum TK_Flags {
          TK_COMMENT = (0x01 << 0),
          TK_CORE = (0x01 << 1),
          TK_MACRO_CALL = (0x01 << 2),
          TK_MACRO_GENERATED = (0x01 << 3)
  };
  unsigned short _flags;

public:
  enum {
    ID_END_OF_FILE = -1,
    ID_UNKNOWN = -2,
    ID_ERROR = -3,
    ID_WARNING = -4
  };

  static LanguageID comment_id, pre_id, dir_id, cpp_id, white_id, 
                    wildcard_id, keyword_id, open_id, macro_op_id,
                    identifier_id, comma_id, close_id;

public:
  Token (int = 0, LanguageID lang = LanguageID(0), const char * = "");
  Token (const Token &);
  virtual ~Token ();

//  virtual void print (ostream &) const;
  void print (ostream &) const;
  virtual ListElement *duplicate () { return new Token (*this); }

  void reset (int = 0, const char * = 0, LanguageID = LanguageID(0));
  
  void location (const Location &loc)      { _location = loc; }
  void cont_lines (Array<int> *cl)  { _cont_lines = cl; }
  int line_breaks () const;
  void macro_generated ()           { _flags |= TK_MACRO_GENERATED; }
  void macro_call ()                { _flags |= TK_MACRO_CALL; }
  
  const DString &text () const     { return _text; }
  char *get_static_text () const;
  int type () const                 { return _type; }
  const Location &location () const { return _location; }
   
  // functions to query token flags
  bool is_macro_generated () const  { return (_flags & TK_MACRO_GENERATED) != 0; }
  bool is_macro_call () const       { return (_flags & TK_MACRO_CALL) != 0; }
  bool is_core () const;
  bool is_identifier () const;    // subset of core
  bool is_keyword () const;       // subset of identifier
  bool is_wildcard () const;      // subset of core
  bool is_preprocessor () const;  // a preprocessor directive (include, etc.)
  bool is_directive () const;     // a compiler directive (pragma, line, etc.)
  bool is_whitespace () const;
  bool is_comment () const;
  bool is_macro_op () const;
  bool is_open () const;          // subset of core
  bool is_comma () const;         // subset of core
  bool is_close () const;         // subset of core

  void *operator new (size_t);
  void  operator delete (void *);

private:
  int get_general_type () const;
  LanguageID language () const { return _language; }
  void is_comment_internal ();
  void is_core_internal ();
};


inline void Token::is_core_internal () {
  if (_language == cpp_id || _language == wildcard_id || 
      _language == open_id || _language == comma_id || 
      _language == close_id || is_identifier ())
    _flags |= TK_CORE;
}
inline void Token::is_comment_internal () { 
  if (_language == comment_id) 
    _flags |= TK_COMMENT;
}

inline bool Token::is_core () const 
 { return (_flags & TK_CORE) != 0; }
inline bool Token::is_identifier () const 
 { return _language == identifier_id || is_keyword ();}
inline bool Token::is_keyword () const 
 { return _language == keyword_id; }
inline bool Token::is_wildcard () const 
 { return _language == wildcard_id; }
inline bool Token::is_preprocessor () const 
 { return _language == pre_id; }
inline bool Token::is_directive () const 
 { return _language == dir_id; }
inline bool Token::is_whitespace () const 
 { return _language == white_id; }
inline bool Token::is_comment () const 
 { return (_flags & TK_COMMENT) != 0; }
inline bool Token::is_macro_op () const 
 { return _language == macro_op_id; }
inline bool Token::is_open () const 
 { return _language == open_id; }
inline bool Token::is_comma () const 
 { return _language == comma_id; }
inline bool Token::is_close () const 
 { return _language == close_id; }

inline ostream &operator << (ostream &os, const Token &object) {
  object.print (os);
  return os;
}

} // namespace Puma

#endif /* __Token_h__ */
using namespace std;

namespace Puma {


class ErrorStream;
class CObjectInfo;
class CStructure;

/*****************************************************************************/
/*                                                                           */
/*                    S y n t a x  t r e e  n o d e s                        */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  /*DEBUG*/static int alloc;
  /*DEBUG*/static int release;

protected:
  CTree *Son (CTree * const *, int, int) const;
  int Sons (CTree * const *, int) const;
  void ReplaceSon (CTree * const *, int, CTree *, CTree *) const;
  
protected:
  CTree () { /*DEBUG*/alloc++; }

public:
  virtual ~CTree () { /*DEBUG*/release++; }
  virtual int Sons () const = 0;
  virtual CTree *Son (int n) const { return (CTree*)0; }
  virtual const char *NodeName () const = 0;
  virtual Token *token () const;
  virtual Token *end_token () const;
  virtual CT_Token *token_node () const;
  virtual CT_Token *end_token_node () const;
  virtual void ReplaceSon (CTree *, CTree *) {}

public: // semantic information
  virtual CTypeInfo *Type () const { return (CTypeInfo*)0; }
  virtual CExprValue *Value () const { return (CExprValue*)0; }
  
  virtual CSemValue *SemValue () const { return (CSemValue*)0; }
  virtual CSemObject *SemObject () const { return (CSemObject*)0; }
  
public: // node classification function
  virtual CT_SimpleName *IsSimpleName () { return 0; }
  virtual CT_Declarator *IsDeclarator () { return 0; }
   private:
  typedef CTree CCExprResolveCTree;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CTree CExprResolveCTree;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Error : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Token : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Token *_token;
  unsigned long int _number;
  
public:
  CT_Token (Token *t, unsigned long int n = 0) : 
    _token (t), _number (n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
  Token *token () const { return _token; }
  Token *end_token () const { return _token; }
  CT_Token *token_node () const { return (CT_Token*)this; }
  CT_Token *end_token_node () const { return (CT_Token*)this; }
  void Number (unsigned long int n) { _number = n; }
  unsigned long int Number () const { return _number; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
};

/*****************************************************************************/
/*                                                                           */
/*                              List nodes                                   */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_List : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Array<CTree*> _sons;
  int _properties;

protected:
  CT_List(int size = 5, int incr = 5, int props = 0) : 
    _sons (size, incr), _properties (props) {}

public:
  enum {
    OPEN = 1,         // has a start token like ':' in ":a(1),b(2)"
    CLOSE = 2,
    OPEN_CLOSE = 3,   // has opening and closing delimiters, e.g. '(' ')'
    SEPARATORS = 4,   // the list has separators like ','
    FORCE_EMPTY = 8,  // pretend to be empty, e.g. for "(void)"
    END_SEP = 16,     // has separator after last element, e.g. "a,b,c,"
    NO_LAST_SEP = 32, // no separator before last element, e.g. "(a,b...)"
    INTRO = 64        // has an introduction char, e.g. "=" in "={a,b}"
  };
 
  int Entries () const;
  CTree *Entry (int no) const;
  int Sons () const { return _sons.length (); }
  CTree *Son (int n) const { return _sons.lookup (n); }
  int GetProperties () const { return _properties; }
  void AddProperties (int p) { _properties |= p; }
  void AddSon (CTree *s) { if (s) _sons.append (s); }
  void PrefixSon (CTree *s) { if (s) _sons.prepend (s); }
  void InsertSon (CTree *, CTree *);  // before given son
  void ReplaceSon (CTree *, CTree *);
  void RemoveSon (CTree *);
  void InsertSon (int idx, CTree *s)
   { if (idx <= Sons ()) _sons.insert (idx, s); }
  void ReplaceSon (int idx, CTree *s) 
   { if (idx < Sons ()) _sons[idx] = s; }
  void RemoveSon (int idx) 
   { if (idx < Sons ()) _sons.remove (idx); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExprList : public CT_List, public CSemValue, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ExprList () { AddProperties (SEPARATORS); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclaratorList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumeratorList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_EnumeratorList () { AddProperties (SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
   
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DeclList (int size = 20, int incr = 20) : CT_List (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void Linkage (CT_LinkageSpec *l);
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclSpecSeq : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CmpdStmt : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_CmpdStmt () { AddProperties (OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_HandlerSeq : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateParamList : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateParamList () { AddProperties (INTRO | SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateArgList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateArgList () { AddProperties (SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

/*****************************************************************************/
/*                                                                           */
/*                              Expressions                                  */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Expression : public CTree, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_Expression () {}

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
   private:
  typedef CT_Expression CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Expression CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_String : public CT_List, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_String (int size) : CT_List (size, 1) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
   private:
  typedef CT_String CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_String CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WideString : public CT_String {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_WideString (int size) : CT_String (size) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_WideString CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_WideString CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Integer : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Integer (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return _value ? 1 : 0; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Integer CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Integer CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Character : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Character (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Character CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Character CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WideCharacter : public CT_Character {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_WideCharacter (CTree *t) : CT_Character (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_WideCharacter CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_WideCharacter CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Float : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Float (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Float CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Float CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Bool : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Bool (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Bool CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Bool CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BracedExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // open, expr, close

public:
  CT_BracedExpr (CTree *o, CTree *e, CTree *c) { 
    sons[0] = o; sons[1] = e; sons[2] = c; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Expr () const { return sons[1]; }
  CTypeInfo *Type () const { return Expr ()->Type (); }
  CExprValue *Value () const { return Expr ()->Value (); }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
   private:
  typedef CT_BracedExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_BracedExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SimpleName : public CT_List, public Printable, 
                      public CSemValue, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_SimpleName (int size) : CT_List (size, 1) {}
  CT_SimpleName (int size, int properties) : 
    CT_List (size, 2, properties) {}
  
public:
  CT_SimpleName (CTree *n) : CT_List (1, 1) { AddSon (n); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  virtual const char *Text () const 
   { return Son (Sons ()-1)->token ()->text (); }
  virtual void print (ostream &os) const { os << Text (); }
  virtual CT_SimpleName *Name () const { return (CT_SimpleName*)this; }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
  // classification function
  virtual CT_SimpleName *IsSimpleName () { return this; }  
   private:
  typedef CT_SimpleName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_SimpleName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SpecialName : public CT_SimpleName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  char *_name;
  
protected:
  CT_SpecialName (int size = 1) : CT_SimpleName (size), _name (0) {}
  
public:
  ~CT_SpecialName () { if (_name) delete[] _name; }
  const char *Text () const { return _name; }
  void Name (const char *n) { 
    if (n) { 
      _name = new char[strlen(n) + 1];
      strcpy (_name,n);
    }
  }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_SpecialName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_SpecialName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PrivateName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_PrivateName (const char *n) { Name (n); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
  CTree *Son (int n) const { return (CTree*)0; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_PrivateName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_PrivateName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DestructorName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DestructorName (CTree *, CTree *);
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_DestructorName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DestructorName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateName (CTree *n, CTree *a) 
   { AddSon (n); AddSon (a); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CT_TemplateArgList *Arguments () const 
   { return (CT_TemplateArgList*)Son (Sons ()-1); }
  CT_SimpleName *TemplateName () const 
   { return (CT_SimpleName*)Son (Sons ()-2); }
  // may change in the future
  const char *Text () const { return TemplateName ()->Text (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_TemplateName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_TemplateName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_OperatorName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _oper;

public:
  enum { // complex operators
    FCT_CALL = -100,
    SUBSCRIPT,
    NEW_ARRAY,
    DEL_ARRAY
  };
 
public:
  CT_OperatorName (CTree *);
  CT_OperatorName (CTree *, CTree *, CTree *, CTree *);
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Operator () const { return _oper; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_OperatorName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_OperatorName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ConversionName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ConversionName (CTree *, CTree *);
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CT_NamedType *TypeName () const { return (CT_NamedType*)Son (Sons ()-1); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_ConversionName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ConversionName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_QualName : public CT_SimpleName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_QualName (int size = 3) : 
    CT_SimpleName (size, CT_List::SEPARATORS) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void print (ostream &) const;
  CT_SimpleName *Name () const { return (CT_SimpleName*)Son (Sons ()-1); }
  const char *Text () const { return Name ()->Text (); }
  CTypeInfo *Type () const { return Name ()->Type (); }
  CExprValue *Value () const { return Name ()->Value (); }
  CSemValue *SemValue () const { return Name ()->SemValue (); }
  CSemObject *SemObject () const { return Name ()->SemObject (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_QualName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_QualName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_RootQualName : public CT_QualName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_RootQualName (int size = 2) : 
    CT_QualName (size) { AddProperties (INTRO); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_RootQualName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_RootQualName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BinaryExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // expr, oper, expr

public:
  CT_BinaryExpr (CTree *l, CTree *o, CTree *r) {
    sons[0] = l; sons[1] = o; sons[2] = r;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
   private:
  typedef CT_BinaryExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_BinaryExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembPtrExpr : public CT_BinaryExpr, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembPtrExpr (CTree *e, CTree *o, CTree *i) :
    CT_BinaryExpr (e, o, i) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_MembPtrExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembPtrExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembRefExpr : public CT_MembPtrExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembRefExpr (CTree *e, CTree *o, CTree *i) :
    CT_MembPtrExpr (e, o, i) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_MembRefExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembRefExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UnaryExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // oper, expr

public:
  CT_UnaryExpr (CTree *o, CTree *e) { sons[0] = o; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[1]; }
   private:
  typedef CT_UnaryExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_UnaryExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PostfixExpr : public CT_UnaryExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_PostfixExpr (CTree *e, CTree *o) :
    CT_UnaryExpr (e, o) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_PostfixExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_PostfixExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AddrExpr : public CT_UnaryExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_AddrExpr (CTree *o, CTree *e) :
    CT_UnaryExpr (o, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_AddrExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_AddrExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DerefExpr : public CT_UnaryExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DerefExpr (CTree *o, CTree *e) :
    CT_UnaryExpr (o, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_DerefExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DerefExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeleteExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // oper, expr

public:
  CT_DeleteExpr (CTree *op, CTree *e) { sons[0] = op; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[1]; }
  CT_SimpleName *OperName () const { return (CT_SimpleName*)sons[0]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_DeleteExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DeleteExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NewExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[6]; // oper, placement, open, type, close, init

public:
  CT_NewExpr (CTree *op, CTree *p, CTree *o, CTree *t, CTree *c, CTree *i) {
    sons[0] = op; sons[1] = p; sons[2] = o; sons[3] = t; sons[4] = c; sons[5] = i; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 6); }
  CTree *Son (int n) const { return CTree::Son (sons, 6, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 6, old_son, new_son);
  }
  CT_SimpleName *OperName () const { return (CT_SimpleName*)sons[0]; }
  CT_ExprList *Placement () const { return (CT_ExprList*)sons[1];; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[5]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[3]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_NewExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_NewExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IfThenExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // cond, oper, left, colon, right

public:
  CT_IfThenExpr (CTree *c1, CTree *o, CTree *l, CTree *c2, CTree *r) {
    sons[0] = c1; sons[1] = o; sons[2] = l; sons[3] = c2; sons[4] = r;
  }
  CT_IfThenExpr (CTree *c1, CTree *o, CTree *c2, CTree *r) {
    sons[0] = c1; sons[1] = o; sons[2] = 0; sons[3] = c2; sons[4] = r;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CTree *Condition () const { return sons[0]; }
  CTree *LeftOperand () const { return sons[2]; }
  CTree *RightOperand () const { return sons[4]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
   private:
  typedef CT_IfThenExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_IfThenExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CmpdLiteral : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // open, type, close, init

public:
  CT_CmpdLiteral (CTree *r, CTree *t, CTree *cr, CTree *i) {
    sons[0] = r; sons[1] = t; sons[2] = cr; sons[3] = i;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[1]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[3]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_CmpdLiteral CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_CmpdLiteral CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ConstructExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // type, init

public:
  CT_ConstructExpr (CTree *t, CTree *i) { sons[0] = t; sons[1] = i; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[0]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_ConstructExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ConstructExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ThrowExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // throw, expr

public:
  CT_ThrowExpr (CTree *t, CTree *e = (CTree*)0) { sons[0] = t; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[1]; }
   private:
  typedef CT_ThrowExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ThrowExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IndexExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // expr, open, index, close

public:
  CT_IndexExpr (CTree *e, CTree *o, CTree *i, CTree *c) {
    sons[0] = e; sons[1] = o; sons[2] = i; sons[3] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
   private:
  typedef CT_IndexExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_IndexExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CallExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // expr, args

public:
  CT_CallExpr (CTree *e) { sons[0] = e; sons[1] = 0; }
  CT_CallExpr (CTree *e, CTree *l) { sons[0] = e; sons[1] = l; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); } 
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[0]; }
  CT_ExprList *Arguments () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_CallExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_CallExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CastExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // open, type, close, expr

public:
  CT_CastExpr (CTree *o, CTree *t, CTree *c, CTree *e) {
    sons[0] = o; sons[1] = t; sons[2] = c; sons[3] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CTree *Expr () const { return sons[3]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[1]; }
   private:
  typedef CT_CastExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_CastExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_StaticCast : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // cast, open, type, close, expr

public:
  CT_StaticCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) {
    sons[0] = cst; sons[1] = o; sons[2] = t; sons[3] = c; sons[4] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Expr () const { return sons[4]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[2]; }
   private:
  typedef CT_StaticCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_StaticCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ConstCast : public CT_StaticCast {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ConstCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) :
    CT_StaticCast (cst, o, t, c, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_ConstCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ConstCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ReintCast : public CT_StaticCast {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ReintCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) :
    CT_StaticCast (cst, o, t, c, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_ReintCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ReintCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DynamicCast : public CT_StaticCast {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DynamicCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) :
    CT_StaticCast (cst, o, t, c, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_DynamicCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DynamicCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ImplicitCast : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_expr; // casted expression

public:
  CT_ImplicitCast (CTree *e) : _expr (e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return n == 0 ? _expr : (CTree*)0; }
  CTree *Expr () const { return _expr; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _expr) _expr = new_son; }
   private:
  typedef CT_ImplicitCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ImplicitCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TypeidExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // typeid, open, type_id/expr, close

public:
  CT_TypeidExpr (CTree *tid, CTree *o, CTree *e, CTree *c) {
    sons[0] = tid; sons[1] = o; sons[2] = e; sons[3] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CTree *Arg () const { return sons[2]; }
   private:
  typedef CT_TypeidExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_TypeidExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SizeofExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // key, open, type, close, expr

public:
  CT_SizeofExpr (CTree *k, CTree *o, CTree *t, CTree *c) {
    sons[0] = k; sons[1] = o; sons[2] = t; sons[3] = c; sons[4] = 0;
  }
  CT_SizeofExpr (CTree *k, CTree *e) {
    sons[0] = k; sons[1] = 0; sons[2] = 0; sons[3] = 0; sons[4] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Expr () const { return sons[4]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[2]; }
   private:
  typedef CT_SizeofExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_SizeofExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IndexDesignator : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // open, index, close

public:
  CT_IndexDesignator (CTree *o, CTree *i, CTree *c) {
    sons[0] = o; sons[1] = i; sons[2] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
   private:
  typedef CT_IndexDesignator CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_IndexDesignator CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembDesignator : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // dot, member

public:
  CT_MembDesignator (CTree *d, CTree *m) { sons[0] = d; sons[1] = m; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
   private:
  typedef CT_MembDesignator CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembDesignator CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DesignatorSeq : public CT_List, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DesignatorSeq (int size = 1) : CT_List (size, 2) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
};

/*****************************************************************************/
/*                                                                           */
/*                         Declaration specifiers                            */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclSpec : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_DeclSpec () {}
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PrimDeclSpec : public CT_DeclSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  enum Type { PDS_FRIEND, PDS_TYPEDEF, PDS_AUTO, PDS_REGISTER, PDS_STATIC, 
              PDS_EXTERN, PDS_MUTABLE, PDS_INLINE, PDS_VIRTUAL, PDS_EXPLICIT, 
              PDS_CONST, PDS_VOLATILE, PDS_RESTRICT, PDS_CHAR, PDS_WCHAR_T, 
              PDS_BOOL, PDS_SHORT, PDS_INT, PDS_LONG, PDS_SIGNED, PDS_UNSIGNED, 
              PDS_FLOAT, PDS_DOUBLE, PDS_VOID, 
              // AspectC++ specific type specifier
              PDS_UNKNOWN_T,
              // Win specific declaration specifiers
              PDS_CDECL, PDS_STDCALL, PDS_FASTCALL, PDS_INT64,
              PDS_UNKNOWN, PDS_NUM };

private:
  Type _type;
  CT_Token *_token;

  void determine_type ();

public:
  CT_PrimDeclSpec (CT_Token *t) : _token (t) { determine_type (); }
  CT_PrimDeclSpec (Type t) : _token (0) { _type = t; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return _token ? 1 : 0; }
  CTree *Son (int n) const 
   { return (n == 0) ? _token : (CTree*)0; }
  const char *SpecText () const 
   { return _token ? _token->token ()->text ().c_str () : " "; }
  Type SpecType () const { return _type; }
  static const int NumTypes = PDS_NUM;
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NamedType : public CT_DeclSpec, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // declspecs, declarator

public:
  CT_NamedType (CTree *dss, CTree *d) { sons[0] = dss; sons[1] = d; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Declarator () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};
      
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ClassSpec : public CT_DeclSpec, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // key, name
  
public:
  CT_ClassSpec (CTree *k, CTree *n) { sons[0] = k; sons[1] = n; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); } 
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UnionSpec : public CT_ClassSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_UnionSpec (CTree *k, CTree *n) : CT_ClassSpec (k, n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumSpec : public CT_ClassSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_EnumSpec (CTree *k, CTree *n) : CT_ClassSpec (k, n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExceptionSpec : public CT_DeclSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // throw, type_id_list
  
public:
  CT_ExceptionSpec (CTree *k, CTree *l) { sons[0] = k; sons[1] = l; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CT_ArgDeclList *Arguments () const { return (CT_ArgDeclList*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Declarations                                 */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Decl : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;
 
  CT_LinkageSpec *_linkage;
protected:
  CT_Decl () : _linkage (0) {}
public:
  void Linkage (CT_LinkageSpec *l) { _linkage = l; }
  CT_LinkageSpec *Linkage () const { return _linkage; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Program : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_Program (int size = 20, int incr = 20) : CT_DeclList (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
   
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ObjDecl : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declspecs, declarators, colon

public:
  CT_ObjDecl (CTree *dsl, CTree *dl, CTree *c) {
    sons[0] = dsl; sons[1] = dl; sons[2] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CT_DeclaratorList *Declarators () const { return (CT_DeclaratorList*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateDecl : public CT_Decl, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // export, param_list, decl

public:
  CT_TemplateDecl (CTree *e, CTree *p, CTree *d) {
    sons[0] = e; sons[1] = p; sons[2] = d;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son); 
  }
  CTree *Export () const { return sons[0]; }
  CT_TemplateParamList *Parameters () const { 
    return (CT_TemplateParamList*)sons[1]; 
  }
  CTree *Declaration () const { return sons[2]; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateParamDecl : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_TemplateParamDecl () {}
  
public:
  virtual CT_ExprList *DefaultArgument () const = 0;
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NonTypeParamDecl : public CT_TemplateParamDecl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declspecs, declarator, init

public:
  CT_NonTypeParamDecl (CTree *dsl, CTree *d, CTree *i = (CTree*)0) {
    sons[0] = dsl; sons[1] = d; sons[2] = i;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_ExprList *DefaultArgument () const { return (CT_ExprList*)sons[2]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Initializer (CTree *i) { sons[2] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TypeParamDecl : public CT_TemplateParamDecl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // params, key, id, init

public:
  CT_TypeParamDecl (CTree *t, CTree *k, CTree *id, CTree *i = (CTree*)0) { 
    sons[0] = t; sons[1] = k; sons[2] = id; sons[3] = i;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_TemplateParamList *Parameters () const { 
    return (CT_TemplateParamList*)sons[0]; 
  }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[2]; }
  CT_ExprList *DefaultArgument () const { return (CT_ExprList*)sons[3]; }
  void Initializer (CTree *i) { sons[3] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // key, name, enumerators

public:
  CT_EnumDef (CTree *k, CTree *n) {
    sons[0] = k; sons[1] = n; sons[2] = 0; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  void Enumerators (CTree *el) { sons[2] = el; }
  CT_EnumeratorList *Enumerators () const { return (CT_EnumeratorList*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Enumerator : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // name, init

public:
  CT_Enumerator (CTree *n) { sons[0] = n; sons[1] = 0; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[0]; }
  void Initializer (CTree *i) { sons[1] = i; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son); 
  }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_FctDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[7]; // declspecs, declarator, try, ctor_init, args, body, handlers

public:
  CT_FctDef (CTree *dss, CTree *d, CTree *t, CTree *ci, CTree *as, 
             CTree *b, CTree *hs) {
    sons[0] = dss; sons[1] = d; sons[2] = t; sons[3] = ci; sons[4] = as; 
    sons[5] = b; sons[6] = hs; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 7); }
  CTree *Son (int n) const { return CTree::Son (sons, 7, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_Token *TryKey () const { return (CT_Token*)sons[2]; }
  CTree *CtorInit () const { return sons[3]; }
  CT_ArgDeclSeq *ArgDeclSeq () const { return (CT_ArgDeclSeq*)sons[4]; }
  CT_CmpdStmt *Body () const { return (CT_CmpdStmt*)sons[5]; }
  CT_HandlerSeq *Handlers () const { return (CT_HandlerSeq*)sons[6]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void CtorInit (CTree *i) { sons[3] = i; }
  void Body (CTree *b) { sons[5] = b; }
  void FctTryBlock (CTree *t, CTree *c, CTree *b, CTree *h) { 
    sons[2] = t; sons[3] = c; sons[5] = b; sons[6] = h;
  }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 7, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AsmDef : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // asm, open, str, close, semi_colon

public:
  CT_AsmDef (CTree *a, CTree *o, CTree *s, CTree *c, CTree *sc) {
    sons[0] = a; sons[1] = o; sons[2] = s; sons[3] = c; sons[4] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_String *Instructions () const { return (CT_String*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Handler : public CT_Decl, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // catch, exception_decl, stmt

public:
  CT_Handler (CTree *c, CTree *e, CTree *s) {
    sons[0] = c; sons[1] = e; sons[2] = s;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_ArgDeclList *Arguments () const { return (CT_ArgDeclList*)sons[1]; }
  CT_Statement *Statement () const { return (CT_Statement*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_LinkageSpec : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // extern, str, open, decls, close

public:
  CT_LinkageSpec (CTree *e, CTree *s, CTree *o, CTree *d, CTree *c) {
    sons[0] = e; sons[1] = s; sons[2] = o; sons[3] = d; sons[4] = c;
    if (isList ())
      ((CT_DeclList*)Decls ())->Linkage (this);
    else
      ((CT_Decl*)Decls ())->Linkage (this);
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_String *Linkage () const { return (CT_String*)sons[1]; }
  CTree *Decls () const { return sons[3]; }
  bool isList () const {
    return Decls ()->NodeName () == CT_DeclList::NodeId ();
  }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgDecl : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // declspecs, declarator, init, ellipsis

public:
  CT_ArgDecl (CTree *dsl, CTree *d) {
    sons[0] = dsl; sons[1] = d; sons[2] = 0; sons[3] = 0; 
  }
  CT_ArgDecl (CTree *ellipsis) {
    sons[0] = 0; sons[1] = 0; sons[2] = 0; sons[3] = ellipsis; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[2]; }
  CT_Token *Ellipsis () const { return (CT_Token*)sons[3]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Initializer (CTree *i) { sons[2] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgDeclList : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ArgDeclList (int size = 2, int props = SEPARATORS | OPEN_CLOSE) : 
   CT_DeclList (size, 2) { AddProperties (props); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgDeclSeq : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ArgDeclSeq (int size = 2) : CT_DeclList (size, 2) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgNameList : public CT_ArgDeclList {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ArgNameList () : CT_ArgDeclList () {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NamespaceDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // ns, name, members

public:
  CT_NamespaceDef (CTree *n, CTree *nm) {
    sons[0] = n; sons[1] = nm; sons[2] = 0; 
  }
  CT_NamespaceDef (CTree *n, CTree *nm, CTree *m) {
    sons[0] = n; sons[1] = nm; sons[2] = m; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void Members (CTree *m) { sons[2] = m; }
  CT_MembList *Members () const { return (CT_MembList*)sons[2]; }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NamespaceAliasDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // ns, alias, assign, name, semi_colon

public:
  CT_NamespaceAliasDef (CTree *n, CTree *a, CTree *as, CTree *nm, CTree *s) {
    sons[0] = n; sons[1] = a; sons[2] = as; sons[3] = nm; sons[4] = s; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[3]; }
  CT_SimpleName *Alias () const { return (CT_SimpleName*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UsingDirective : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // using, ns, name, semi_colon

public:
  CT_UsingDirective (CTree *u, CTree *ns, CTree *n, CTree *s) {
    sons[0] = u; sons[1] = ns; sons[2] = n; sons[3] = s; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Declarators                                  */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Declarator : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_Declarator () {}

public:
  virtual CTree *Declarator () const = 0;
  //classification function
  virtual CT_Declarator *IsDeclarator () { return this; }
  // locate the name node
  CT_SimpleName *Name ();
  CT_SimpleName *Name (CT_Declarator *&last_declarator);
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_InitDeclarator : public CT_Declarator, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // declarator, init
  CTree *obj_decl;

public:
  CT_InitDeclarator (CTree *d, CTree *i = (CTree*)0) {
    sons[0] = d; sons[1] = i; obj_decl = 0; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Declarator () const { return sons[0]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  CT_ObjDecl *ObjDecl () const { return (CT_ObjDecl*)obj_decl; }
  void Initializer (CTree* i) { sons[1] = i; }
  void ObjDecl (CTree *od) { obj_decl = od; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BracedDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // open, win_specs, declarator, close

public:
  CT_BracedDeclarator (CTree *o, CTree *d, CTree *c) {
    sons[0] = o; sons[1] = 0; sons[2] = d; sons[3] = c; 
  }
  CT_BracedDeclarator (CTree *o, CTree *ws, CTree *d, CTree *c) {
    sons[0] = o; sons[1] = ws; sons[2] = d; sons[3] = c; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CTree *Declarator () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArrayDelimiter : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // star, static, quals, expr
  bool pos0;

public:
  CT_ArrayDelimiter (CTree *m, CTree *s, CTree *q, CTree *e, bool p = false) {
    sons[0] = m; sons[1] = s; sons[2] = q; sons[3] = e; pos0 = p;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_Token *Star () const { return (CT_Token*)sons[0]; }
  CT_Token *Static () const { return (CT_Token*)sons[pos0?2:1]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[pos0?1:2]; }
  CTree *Expr () const { return sons[3]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArrayDeclarator : public CT_Declarator, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // declarator, open, delim, close

public:
  CT_ArrayDeclarator (CTree *d, CTree *o, CTree *ad, CTree *c) {
    sons[0] = d; sons[1] = o; sons[2] = ad; sons[3] = c; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CTree *Declarator () const { return sons[0]; }
  CT_ArrayDelimiter *Delimiter () const 
   { return (CT_ArrayDelimiter*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_FctDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // declarator, args, cv_quals, exception_specs

public:
  CT_FctDeclarator (CTree *d, CTree *args, CTree *cv, CTree *es) {
    sons[0] = d; sons[1] = args; sons[2] = cv; sons[3] = es; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CTree *Declarator () const { return sons[0]; }
  CT_ArgDeclList *Arguments () const { return (CT_ArgDeclList*)sons[1]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[2]; }
  CT_ExceptionSpec *ExceptionSpecs () const { return (CT_ExceptionSpec*)sons[3]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_RefDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // ref, declarator

public:
  CT_RefDeclarator (CTree *r, CTree *d) { sons[0] = r; sons[1] = d; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Declarator () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) {
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PtrDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // ptr, cv_quals, declarator

public:
  CT_PtrDeclarator (CTree *p, CTree *c, CTree *d) {
    sons[0] = p; sons[1] = c; sons[2] = d; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Declarator () const { return sons[2]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembPtrDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // class, colon, ptr, cv_quals, declarator

public:
  CT_MembPtrDeclarator (CTree *c, CTree *cc, CTree *p, CTree *q, CTree *d) {
    sons[0] = c; sons[1] = cc; sons[2] = p; sons[3] = q; sons[4] = d; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[0]; }
  CTree *Declarator () const { return sons[4]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[3]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BitFieldDeclarator : public CT_Declarator, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declarator, colon, expr

public:
  CT_BitFieldDeclarator (CTree *d, CTree *c, CTree *e = 0) {
    sons[0] = d; sons[1] = c; sons[2] = e; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Declarator () const { return sons[0]; }
  CTree *Expr () const { return sons[2]; }
  void FieldSize (CTree *s) { sons[2] = s; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Statements                                   */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Statement : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;
 
protected:
  CT_Statement () {}
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_LabelStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // id, colon, stmt

public:
  CT_LabelStmt (CTree *id, CTree *c, CTree *stmt) {
    sons[0] = id; sons[1] = c; sons[2] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[2]; }
  CT_SimpleName *Label () const { return (CT_SimpleName*)sons[0]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DefaultStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // keyword, colon, stmt

public:
  CT_DefaultStmt (CTree *kw, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = c; sons[2] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TryStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // try, stmt, handlers

public:
  CT_TryStmt (CTree *t, CTree *s, CTree *h) {
    sons[0] = t; sons[1] = s; sons[2] = h; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[1]; }
  CT_HandlerSeq *Handlers () const { return (CT_HandlerSeq*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CaseStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // keyword, expr, colon, stmt

public:
  CT_CaseStmt (CTree *kw, CTree *expr, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = expr; sons[2] = c; sons[3] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[3]; }
  CTree *Expr () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExprStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // expr, semi_colon

public:
  CT_ExprStmt (CTree *expr, CTree *sc) { sons[0] = expr; sons[1] = sc; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Expr () const { return sons[0]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_decl;

public:
  CT_DeclStmt (CTree *decl) : _decl (decl) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return n == 0 ? _decl : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _decl) _decl = new_son; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SwitchStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // keyword, open, cond, close, stmt

public:
  CT_SwitchStmt (CTree *kw, CTree *o, CTree *cond, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[4]; }
  CTree *Condition () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IfStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // keyword, open, cond, close, stmt

public:
  CT_IfStmt (CTree *kw, CTree *o, CTree *cond, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[4]; }
  CTree *Condition () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IfElseStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[7]; // if, open, cond, close, if_stmt, else, else_stmt

public:
  CT_IfElseStmt (CTree *i, CTree *o, CTree *cond, CTree *c, 
                 CTree *is, CTree *e, CTree *es) {
    sons[0] = i; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = is; 
    sons[5] = e; sons[6] = es; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 7; }
  CTree *Son (int n) const { return CTree::Son (sons, 7, n); }
  CTree *Condition () const { return sons[2]; }
  CT_Statement *IfPart () const { return (CT_Statement*)sons[4]; }
  CT_Statement *ElsePart () const { return (CT_Statement*)sons[6]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 7, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BreakStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // key, semi_colon

public:
  CT_BreakStmt (CTree *key, CTree *sc) { sons[0] = key; sons[1] = sc; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ContinueStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // key, semi_colon

public:
  CT_ContinueStmt (CTree *key, CTree *sc) { sons[0] = key; sons[1] = sc; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_GotoStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // key, label, semi_colon

public:
  CT_GotoStmt (CTree *key, CTree *l, CTree *sc) {
    sons[0] = key; sons[1] = l; sons[2] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_SimpleName *Label () const { return (CT_SimpleName*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ReturnStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // key, expr, semi_colon

public:
  CT_ReturnStmt (CTree *key, CTree *e, CTree *sc) {
    sons[0] = key; sons[1] = e; sons[2] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Expr () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WhileStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // key, open, cond, close, stmt

public:
  CT_WhileStmt (CTree *kw, CTree *o, CTree *cond, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[4]; }
  CTree *Condition () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DoStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[7]; // do, stmt, while, open, expr, close, semi_colon

public:
  CT_DoStmt (CTree *d, CTree *stmt, CTree *w, CTree *o, CTree *e, 
             CTree *c, CTree *sc) {
    sons[0] = d; sons[1] = stmt; sons[2] = w; sons[3] = o; sons[4] = e; 
    sons[5] = c; sons[6] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 7; }
  CTree *Son (int n) const { return CTree::Son (sons, 7, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[1]; }
  CTree *Expr () const { return sons[4]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 7, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ForStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[8]; // key, open, init, cond, semi_colon, expr, close, stmt

public:
  CT_ForStmt (CTree *k, CTree *o, CTree *i, CTree *co, CTree *sc,
              CTree *e, CTree *c, CTree *stmt) {
    sons[0] = k; sons[1] = o; sons[2] = i; sons[3] = co; 
    sons[4] = sc; sons[5] = e; sons[6] = c; sons[7] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 8); }
  CTree *Son (int n) const { return CTree::Son (sons, 8, n); }
  CTree *InitStmt () const { return sons[2]; }
  CTree *Condition () const { return sons[3]; }
  CTree *Expr () const { return sons[5]; }
  CT_Statement *Statement () const { return (CT_Statement*)sons[7]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 8, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Condition : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declspecs, declarator, init

public:
  CT_Condition (CTree *dsl, CTree *d) {
    sons[0] = dsl; sons[1] = d; sons[2] = 0;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[2]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Initializer (CTree *i) { sons[2] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Classes                                      */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ClassDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

   
  struct __ac_wrapper_sons {
    typedef ::Puma::CTree * E; typedef E A[4]; A _data;
    operator A& () { return _data; }
    operator A& () const { return (A&)*(::Puma::CTree * *)_data; }
    operator const A& () { return _data; }
    operator const A& () const { return _data; }
    operator void* () { return _data; }
    operator void* () const { return (void*)_data; }
    operator const void* () { return _data; }
    operator const void* () const { return _data; }
    template <typename I> E& operator [] (I i) { return _data[i]; } // for VC++ 2003
    template <typename I> const E& operator [] (I i) const { return _data[i]; } // for VC++ 2003
  } sons; // key, name, bases, members
  CTree *obj_decl;

public:
  

struct TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0 {
  typedef void Result;
  typedef ::Puma::CT_ClassDef That;
  typedef ::Puma::CT_ClassDef Target;
  static const int JPID = 4;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 3 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };
  template <int DUMMY> struct Arg<0, DUMMY> {
    typedef ::Puma::CTree * Type;
    typedef ::Puma::CTree * ReferredType;
  };
  template <int DUMMY> struct Arg<1, DUMMY> {
    typedef ::Puma::CTree * Type;
    typedef ::Puma::CTree * ReferredType;
  };
  template <int DUMMY> struct Arg<2, DUMMY> {
    typedef ::Puma::CTree * Type;
    typedef ::Puma::CTree * ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};

CT_ClassDef (CTree * arg0, CTree * arg1, CTree * arg2 = (CTree*)0) {
  TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0 tjp;
  tjp._that =  (TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0::That*)this;
this->__exec_old_C1(arg0, arg1, arg2);
  AC::invoke_ExtACTree_ExtACTree_a0_after<TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0> (&tjp);

}
inline void __exec_old_C1(::Puma::CTree * k,::Puma::CTree * n,::Puma::CTree * b){
    sons[0] = k; sons[1] = n; sons[2] = b; sons[3] = 0; obj_decl = 0; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  CT_MembList *Members () const { return (CT_MembList*)sons[3]; }
  CT_BaseSpecList *BaseClasses () const { return (CT_BaseSpecList*)sons[2]; }
  CT_ObjDecl *ObjDecl () const { return (CT_ObjDecl*)obj_decl; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Members (CTree *m) { sons[3] = m; }
  void BaseClasses (CTree *bc) { sons[2] = bc; }
  void ObjDecl (CTree *od) { obj_decl = od; }
  void ReplaceSon (CTree *old_son, CTree *new_son) {
    // &(...) is used here to avoid strange warnings by mingw32-g++
    CTree::ReplaceSon (&(sons[0]), 4, old_son, new_son);
  }
   private:
 CTree * _intro_members ;
public :
CTree * IntroMembers ( ) const { return _intro_members ; }
void IntroMembers ( CTree * members ) { _intro_members = members ; }
struct TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0 {
  typedef void Result;
  typedef ::Puma::CT_ClassDef That;
  typedef ::Puma::CT_ClassDef Target;
  static const int JPID = 4;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 1 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };
  template <int DUMMY> struct Arg<0, DUMMY> {
    typedef const ::Puma::CT_ClassDef & Type;
    typedef const ::Puma::CT_ClassDef ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};


public:
inline CT_ClassDef (const Puma::CT_ClassDef & arg0) : Puma::CT_Decl (arg0), Puma::CSemObject (arg0), sons (arg0.sons), obj_decl (arg0.obj_decl), _intro_members (arg0._intro_members) {
  TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0 tjp;
  tjp._that =  (TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0::That*)this;
  AC::invoke_ExtACTree_ExtACTree_a0_after<TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0> (&tjp);

}

struct TJP__ZN4Puma11CT_ClassDefD1Ev_0 {
  typedef void Result;
  typedef ::Puma::CT_ClassDef That;
  typedef ::Puma::CT_ClassDef Target;
  static const int JPID = 4;
  static const AC::JPType JPTYPE = (AC::JPType)32;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 0 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};


public:
inline ~CT_ClassDef () {
  TJP__ZN4Puma11CT_ClassDefD1Ev_0 tjp;
  tjp._that =  (TJP__ZN4Puma11CT_ClassDefD1Ev_0::That*)this;
  AC::invoke_ExtACTree_ExtACTree_a1_before<TJP__ZN4Puma11CT_ClassDefD1Ev_0> (&tjp);

}
};
      
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UnionDef : public CT_ClassDef {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_UnionDef (CTree *k, CTree *n, CTree *b = 0) : CT_ClassDef (k, n, b) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
      
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembList : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembList (int size = 10, int incr = 10) : 
    CT_DeclList (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembInitList : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembInitList (int size = 2) : 
    CT_List (size, 2, CT_List::OPEN) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembInit : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // name, init

public:
  CT_MembInit (CTree *n, CTree *i) { sons[0] = n; sons[1] = i; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[0]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_MembInit CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembInit CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BaseSpecList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_BaseSpecList (int size = 2) : 
    CT_List (size, 2, CT_List::OPEN|CT_List::SEPARATORS) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AccessSpec : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // access, colon

public:
  CT_AccessSpec (CTree *a, CTree *c) { sons[0] = a; sons[1] = c; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  int Access () const { return sons[0]->token ()->type (); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BaseSpec : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // virtual, access, name

public:
  CT_BaseSpec (CTree *v, CTree *a, CTree *n) {
    sons[0] = v; sons[1] = a; sons[2] = n; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  int Access () const { return sons[1]->token ()->type (); }
  CTree *AccessSpec () const { return sons[1]; }
  CTree *Virtual () const { return sons[0]; }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AccessDecl : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // name, semi_colon

public:
  CT_AccessDecl (CTree *n, CTree *s) { sons[0] = n; sons[1] = s; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CT_QualName *Member () const { return (CT_QualName*)sons[0]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UsingDecl : public CT_AccessDecl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // using, typename

public:
  CT_UsingDecl (CTree *u, CTree *n, CTree *s) : CT_AccessDecl (n, s) {
    sons[0] = u; sons[1] = 0; 
  }
  CT_UsingDecl (CTree *u, CTree *t, CTree *n, CTree *s) : CT_AccessDecl (n, s) {
    sons[0] = u; sons[1] = t; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2) + CT_AccessDecl::Sons (); }
  CTree *Son (int n) const {
    int num = CTree::Sons (sons, 2);
    CTree *result = CTree::Son (sons, 2, n);
    return result ? result : CT_AccessDecl::Son (n-num);
  }
  CTree *Typename () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
    CT_AccessDecl::ReplaceSon (old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Wildcards                                    */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Any : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // keyword, extension

public:
  CT_Any (CTree *k, CTree *e = (CTree*)0) { sons[0] = k; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  int AnyType () const { return sons[0]->token ()->type (); }
  CT_AnyExtension *Extension () const { return (CT_AnyExtension*)sons[1]; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AnyList : public CT_Any {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_AnyList (CTree *k, CTree *e = (CTree*)0) : CT_Any (k, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AnyExtension : public CTree, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // open, string, comma, cond, close

public:
  CT_AnyExtension (CTree *o, CTree *n, CTree *co, CTree *c, CTree *cr) {
    sons[0] = o; sons[1] = n; sons[2] = co; sons[3] = c; sons[4] = cr; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Condition () const { return sons[3]; }
  CT_Token *String () const { return (CT_Token*)sons[1]; }
  const char *Name () const { 
    return value ? value->StrLiteral ()->String () : (const char*)0; }

  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AnyCondition : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // arg1, arg2, arg3

public:
  CT_AnyCondition (CTree *a1, CTree *a2 = (CTree*)0, CTree *a3 = (CTree*)0) {
    sons[0] = a1; sons[1] = a2; sons[2] = a3; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};


} // namespace Puma

#endif /* __CTree_h__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_GnuAsmDef : public CT_AsmDef {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_cvqual;
  CTree *_operands0;
  CTree *_operands1;
  CTree *_clobbers;

public:

  CT_GnuAsmDef (CTree *a, CTree *cv, CTree *o, CTree *s, 
                CTree *op0, CTree *op1, CTree *cl, CTree *c, CTree *sc) :
    CT_AsmDef (a, o, s, c, sc) {
      _cvqual = cv; _operands0 = op0; _operands1 = op1; _clobbers = cl;
  }

  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }  

  virtual int Sons () const {
    return 5 +
           (_cvqual ? 1 : 0) +
           (_operands0 ? 1 : 0) +
           (_operands1 ? 1 : 0) +
           (_clobbers ? 1 : 0);
  }

  virtual CTree *Son (int n) const {
    int have_cv = _cvqual ? 1 : 0;
    int gnu_sons = Sons () - have_cv - 5;
    int gnu_first = 3 + have_cv;
    if (n == 0) return CT_AsmDef::Son (0);
    else if (n == 1 && _cvqual) return _cvqual;
    else if ((n == 1 && !_cvqual) || (n == 2 && _cvqual))
       return CT_AsmDef::Son (1);
    else if ((n == 2 && !_cvqual) || (n == 3 && _cvqual))
       return CT_AsmDef::Son (2);
    else if (n == gnu_first && gnu_sons >= 1) return _operands0;
    else if (n == gnu_first + 1 && gnu_sons >= 2) return _operands1;
    else if (n == gnu_first + 2 && gnu_sons >= 3) return _clobbers;
    else if (n == Sons () - 2)
       return CT_AsmDef::Son (3);
    else if (n == Sons () - 1)
       return CT_AsmDef::Son (4);
    else return (CTree*)0;
  }

  virtual void ReplaceSon (CTree *old_son, CTree *new_son) {
    if (old_son == _cvqual) _cvqual = new_son;
    else if (old_son == _operands0) _operands0 = new_son;
    else if (old_son == _operands1) _operands1 = new_son;
    else if (old_son == _clobbers) _clobbers = new_son;
    else CT_AsmDef::ReplaceSon (old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_GnuAsmOperand : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_string;
  CTree *_open;   // CT_Token
  CTree *_expr;
  CTree *_close;  // CT_Token

public:
  CT_GnuAsmOperand (CTree *s, CTree *o, CTree *e, CTree *c) :
    _string (s), _open (o), _expr (e), _close (c) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); } 
  int Sons () const { return 4; }
  CTree *Son (int n) const {
    switch (n) {
      case 0: return _string;
      case 1: return _open;
      case 2: return _expr;
      case 3: return _close;
      default: return (CTree*)0;
    }
  }
  CT_Expression *Expr () const { return (CT_Expression*)_expr; }
  CT_String *String () const { return (CT_String*)_string; }
  void ReplaceSon (CTree *old_son, CTree *new_son) {
    if (old_son == _expr) _expr = new_son;
    else if (old_son == _string) _string = new_son;
    else if (old_son == _open) _open = new_son;
    else if (old_son == _close) _close = new_son;
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_GnuAsmOperands : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_GnuAsmOperands () { AddProperties (OPEN | SEPARATORS); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }  
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_GnuAsmClobbers : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_GnuAsmClobbers () { AddProperties (OPEN | SEPARATORS); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }  
};

/*****************************************************************************/
/*                                                                           */
/*                              Expressions                                  */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_GnuStatementExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_open;
  CTree *_stmt;
  CTree *_close;
public:
  CT_GnuStatementExpr (CTree *o, CTree *s, CTree *c) :
    _open (o), _stmt (s), _close (c) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }  
  int Sons () const { return 3; }
  CTree *Son (int n) const {
    switch (n) {
      case 0: return _open;
      case 1: return _stmt;
      case 2: return _close;
      default: return (CTree*)0;
    }
  }
  CT_CmpdStmt *CmpdStmt () const { return (CT_CmpdStmt*)Son (1); }
   private:
  typedef CT_GnuStatementExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_GnuStatementExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

/*****************************************************************************/
/*                                                                           */
/*                         Declaration specifiers                            */
/*                                                                           */
/*****************************************************************************/

// typeof(expr) or typeof(named type) feature
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_GnuTypeof : public CT_DeclSpec, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // key, open, type, close, expr

public:
  CT_GnuTypeof (CTree *k, CTree *o, CTree *t, CTree *c) {
    sons[0] = k; sons[1] = o; sons[2] = t; sons[3] = c; sons[4] = 0;
  }
  CT_GnuTypeof (CTree *k, CTree *e) {
    sons[0] = k; sons[1] = 0; sons[2] = 0; sons[3] = 0; sons[4] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Expr () const { return sons[4]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[2]; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  CTypeInfo *Type () const { return type; }
};

} // namespace Puma

#endif /* __gnu_c_tree_h__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_GnuCTree_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CStructure_h__
#define __CStructure_h__

// base class of everything that also is a scope
// (function, class, union, namespace...)
// stores semantic info objects for variables, 
// enumerators, function and template parameters,
// typedefs, classes, unions, enumerations, 
// namespaces, using-directives, friend function 
// declarations, functions, class methods, class 
// data members, function and class templates,
// function and class template instances, member 
// aliases

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CScopeInfo_h__
#define __CScopeInfo_h__

// scope info

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CObjectInfo_h__
#define __CObjectInfo_h__

// base class of all semantic infos
// knows the type of the info, the name of the entity it
// represents, its qualified name (on demand), its type,
// its object linkage, its storage duration, its class
// member access level (protection), and the specifiers 
// that were used at the declaration of the entity,
// knows the source file location of the entity's declaration,
// the corresponding syntax tree node, the class database 
// it belongs to, and other semantic info objects that refer
// to the same entity

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CSourceInfo_h__
#define __CSourceInfo_h__

// stores source file information
// knows the file and the start token where an entity
// was declared in a program

namespace Puma {


class CFileInfo;
class CT_Token;
class Token;
class Unit;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CSourceInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CFileInfo *_FileInfo; 
  CT_Token *_StartToken;

public: 
  CSourceInfo ();
  ~CSourceInfo ();
  
  bool operator ==(const CSourceInfo &) const;
  bool operator !=(const CSourceInfo &) const;
  bool operator <(const CSourceInfo &) const;
  bool operator >(const CSourceInfo &) const;
  bool operator <=(const CSourceInfo &) const;
  bool operator >=(const CSourceInfo &) const;

  bool operator ==(const CT_Token *) const;
  bool operator !=(const CT_Token *) const;
  bool operator <(const CT_Token *) const;
  bool operator >(const CT_Token *) const;
  bool operator <=(const CT_Token *) const;
  bool operator >=(const CT_Token *) const;

  bool operator ==(const Token *) const;

  // Get ...
  CFileInfo *FileInfo () const;
  CT_Token *StartToken () const;
  const char *FileName () const; // the file where it is located
  int Line () const;
  Unit *SrcUnit () const;

  // Set ... 
  void FileInfo (CFileInfo *);
  void StartToken (CT_Token *);
};

inline CSourceInfo::CSourceInfo () :
  _FileInfo ((CFileInfo*)0),
  _StartToken ((CT_Token*)0)
 {}
 
inline CSourceInfo::~CSourceInfo ()
 {}

inline bool CSourceInfo::operator !=(const CSourceInfo &info) const 
 { return ! (*this == info); }
inline bool CSourceInfo::operator <=(const CSourceInfo &info) const 
 { return ! (*this > info); }
inline bool CSourceInfo::operator >=(const CSourceInfo &info) const 
 { return ! (*this < info); }

inline bool CSourceInfo::operator !=(const CT_Token *token) const 
 { return ! (*this == token); }
inline bool CSourceInfo::operator <=(const CT_Token *token) const 
 { return ! (*this > token); }
inline bool CSourceInfo::operator >=(const CT_Token *token) const 
 { return ! (*this < token); }

inline CFileInfo *CSourceInfo::FileInfo () const
 { return _FileInfo; }
inline CT_Token *CSourceInfo::StartToken () const
 { return _StartToken; }

inline void CSourceInfo::FileInfo (CFileInfo *info)
 { _FileInfo = info; }
inline void CSourceInfo::StartToken (CT_Token *token)
 { _StartToken = token; }


} // namespace Puma

#endif /* __CSourceInfo_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CProtection_h__
#define __CProtection_h__

// C++ class member protection

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
struct CProtection {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  enum Type {
    PROT_PUBLIC, 
    PROT_PROTECTED, 
    PROT_PRIVATE,
    PROT_NONE
  };
};


} // namespace Puma

#endif /* __CProtection_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CStorage_h__
#define __CStorage_h__

// C++ storage classes

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
struct CStorage {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  enum Type {
    CLASS_STATIC,
    CLASS_AUTOMATIC, 
    CLASS_DYNAMIC,
    CLASS_NONE
  };
};


} // namespace Puma

#endif /* __CStorage_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CLinkage_h__
#define __CLinkage_h__

// C++ object linkage

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
struct CLinkage {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  enum Type {
    LINK_INTERNAL, 
    LINK_EXTERNAL, 
    LINK_NONE
  };
};


} // namespace Puma

#endif /* __CLinkage_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CLanguage_h__
#define __CLanguage_h__

// Entity name encoding language; language linkage

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CLanguage {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  enum LangType {
    LANG_C,
    LANG_CPLUSPLUS,
    LANG_OTHER,
    LANG_UNDEFINED
  };
    
private:
  LangType m_Type;
  DString m_Text;

public:
  CLanguage () : m_Type (LANG_UNDEFINED), m_Text ("") {}
  
  void Type (LangType lt) { 
    m_Type = lt; m_Text = (lt==LANG_C)?"C":(lt==LANG_CPLUSPLUS)?"C++":""; 
  }
  void Type (LangType lt, const char *txt) { 
    m_Type = lt; m_Text = (lt==LANG_C)?"C":(lt==LANG_CPLUSPLUS)?"C++":(lt==LANG_OTHER)?txt:""; 
  }

  LangType Type () const { return m_Type; }
  const DString &Text () const { return m_Text; }

  bool operator== (const CLanguage &lang) { return (m_Type == lang.Type ()) && (m_Text == lang.Text ()); }
  bool operator== (LangType lt) { return (m_Type == lt); }
};


} // namespace Puma

#endif /* __CLanguage_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CSpecifiers__
#define __CSpecifiers__

// C++ declaration specifiers

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CSpecifiers {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  enum Spec {
    SPEC_NONE     = 0x0,
    SPEC_VIRTUAL  = 0x1,
    SPEC_STATIC   = 0x2,
    SPEC_EXTERN   = 0x4,
    SPEC_MUTABLE  = 0x8,
    SPEC_REGISTER = 0x10,
    SPEC_EXPLICIT = 0x20,
    SPEC_AUTO     = 0x40,
    SPEC_INLINE   = 0x80
  };

private:
  unsigned char _specs;
  
public:
  CSpecifiers ();
  CSpecifiers (const CSpecifiers &);
  CSpecifiers &operator =(const CSpecifiers &);

  // add/remove specifier
  CSpecifiers &operator +=(Spec);
  CSpecifiers &operator -=(Spec);
  
  // test for specifier
  bool operator ==(Spec) const;
  bool operator !=(Spec) const;
};

inline CSpecifiers::CSpecifiers () : _specs (SPEC_NONE) 
 {}
inline CSpecifiers::CSpecifiers (const CSpecifiers &s)
 { _specs = s._specs; }
inline CSpecifiers &CSpecifiers::operator =(const CSpecifiers &s)
 { _specs = s._specs; return *(CSpecifiers*)this; }

inline CSpecifiers &CSpecifiers::operator +=(CSpecifiers::Spec s)
 { _specs = _specs | (unsigned char)s; return *(CSpecifiers*)this; }
inline CSpecifiers &CSpecifiers::operator -=(CSpecifiers::Spec s)
 { _specs = _specs ^ (_specs & (unsigned char)s); return *(CSpecifiers*)this; }

inline bool CSpecifiers::operator ==(CSpecifiers::Spec s) const
 { return _specs & (unsigned char)s; }
inline bool CSpecifiers::operator !=(CSpecifiers::Spec s) const
 { return ! (_specs & (unsigned char)s); }


} // namespace Puma

#endif /* __CSpecifiers__ */
namespace Puma {


class CRecord;
class CStructure;
class CFileInfo;
class CClassInfo;
class CBaseClassInfo;
class CMemberAliasInfo;
class CTypeInfo;
class CScopeInfo;
class CLabelInfo;
class CUnionInfo;
class CLocalScope;
class CEnumInfo;
class CUsingInfo;
class CEnumeratorInfo;
class CTypedefInfo;
class CFunctionInfo;
class CArgumentInfo;
class CAttributeInfo;
class CTemplateParamInfo;
class CTemplateInfo;
class CNamespaceInfo;
class CClassInstance;
class CUnionInstance;
class CFctInstance;
class CClassDatabase;
class CTree;
class CT_ExprList;
class CTemplateInstance;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CObjectInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  enum ObjectId {
    FILE_INFO, 
    UNION_INFO, 
    CLASS_INFO,
    BASECLASS_INFO,
    MEMBERALIAS_INFO,
    ENUM_INFO, 
    TYPEDEF_INFO, 
    FUNCTION_INFO, 
    LABEL_INFO,
    ENUMERATOR_INFO,
    ATTRIBUTE_INFO, 
    TEMPLATE_PARAM_INFO,
    TEMPLATE_INFO,
    CLASS_INSTANCE_INFO,
    UNION_INSTANCE_INFO,
    FCT_INSTANCE_INFO,
    ARGUMENT_INFO, 
    LOCAL_INFO, 
    NAMESPACE_INFO,
    USING_INFO
  };

  bool               _DeleteMembersOnly;
  
private:
  DString            _Name;
  const char        *_QualName;         // Full qualified name
  CTypeInfo         *_TypeInfo;
  CObjectInfo       *_BaseObject;       // corresponding object of base class
  CObjectInfo       *_Next;             // next linked object
  CObjectInfo       *_Prev;             // previous linked object
  CClassDatabase    *_ClassDB;
  CTree             *_Tree;             // corresponding syntax tree
  ObjectId           _Id;               // object type
  CSpecifiers        _Specifiers;
  CSourceInfo        _SourceInfo;       // location in source file
  CProtection::Type  _Protection;
  CLinkage::Type     _Linkage;
  CStorage::Type     _Storage;            
  CLanguage          _Language;

protected:
  CStructure        *_QualScope;        // != 0 only in CAttributeInfo, CFunctionInfo, and CRecord
  CStructure        *_AssignedScope;    // -real- scope of friend classes
  Array<CStructure*> _Registered;         
  
public: 
  ~CObjectInfo ();
  
  // compares the addresses of this and all linked objects
  // to determine whether two objects denote the same entity
  bool operator ==(const CObjectInfo &) const;
  bool operator !=(const CObjectInfo &) const;

  // ask the object info type
  CObjectInfo        *ObjectInfo () const;
  CLabelInfo         *LabelInfo () const;
  CMemberAliasInfo   *MemberAliasInfo () const; 
  CBaseClassInfo     *BaseClassInfo () const;
  CUsingInfo         *UsingInfo () const;
  CTypedefInfo       *TypedefInfo () const;
  CArgumentInfo      *ArgumentInfo () const;
  CAttributeInfo     *AttributeInfo () const;
  CTemplateParamInfo *TemplateParamInfo () const; 
  CStructure         *Structure () const; 
  CFileInfo          *FileInfo () const;  
  CRecord            *Record () const;        
  CLocalScope        *LocalScope () const;
  CScopeInfo         *ScopeInfo () const; 
  CClassInfo         *ClassInfo () const;
  CUnionInfo         *UnionInfo () const;
  CEnumInfo          *EnumInfo () const;
  CFunctionInfo      *FunctionInfo () const;
  CNamespaceInfo     *NamespaceInfo () const;
  CEnumeratorInfo    *EnumeratorInfo () const;
  CTemplateInfo      *TemplateInfo () const; 
  CClassInstance     *ClassInstance () const; 
  CFctInstance       *FctInstance () const; 
  CUnionInstance     *UnionInstance () const; 
  CTemplateInstance  *TemplateInstance () const;
  CRecord            *ClassScope () const;

  // Get ...
  ObjectId            Id () const;
  const DString&      Name () const; 
  const char         *QualName ();                // created on demand
  CObjectInfo        *DefObject () const;         // info of the definition
  CTypeInfo          *TypeInfo () const;
  CScopeInfo         *Scope () const;             // enclosing scope
  CStructure         *QualifiedScope () const;    // scope of qualified names
  CSourceInfo        *SourceInfo () const;        // location in source file
  CClassDatabase     *ClassDB () const; 
  CTree              *Tree () const;
  CObjectInfo        *NextObject () const;        // next linked object
  CObjectInfo        *PrevObject () const;        // previous linked object
  bool                isAnonymous () const;       // has only a private name?
  bool                isTemplate () const;
  bool                isTemplateInstance () const;
  bool                isBuiltin () const;         // has no tree?
  bool                isClassMember () const;     // is method or data member?
  CTemplateInfo      *Template () const;          // template info of template
  CObjectInfo        *BaseObject () const;        // base class object; not yet set
  CT_ExprList        *Init () const;              // get initializer (if any)
  CProtection::Type   Protection () const;        // member access level
  CLinkage::Type      Linkage () const;           // object linkage
  CStorage::Type      Storage () const;           // storage duration
  const CLanguage    &Language () const;          // entity encoding language
  CLanguage          &Language ();                // entity encoding language
  bool                isVirtual () const;         // defined virtual?
  bool                isStatic () const;          // defined static?
  bool                isExtern () const;          // defined extern?
  bool                isMutable () const;         // defined mutable?
  bool                isRegister () const;        // defined register?
  bool                isExplicit () const;        // defined explicit?
  bool                isInline () const;          // defined inline?
  bool                isAuto () const;            // defined auto?
  CStructure          *AssignedScope () const; 
  bool                isRegistered (const CStructure*) const;

  // Set ...
  void                Name (const char* s) { Name(DString(s==0?"":s)); }
  void                Name (const DString&);
  void                TypeInfo (CTypeInfo *);
  void                BaseObject (CObjectInfo *);
  void                Protection (CProtection::Type);
  void                Linkage (CLinkage::Type);
  void                Storage (CStorage::Type);
  void                FileInfo (CFileInfo *);
  void                Tree (CTree *);    
  void                ClassDB (CClassDatabase *);
  void                DeleteMembersOnly ();
  void                NextObject (CObjectInfo *); 
  void                PrevObject (CObjectInfo *); 
  void                Unlink (); 
  void                Register (CStructure *);
  void                Unregister (CStructure *);
  void                isVirtual (bool);
  void                isStatic (bool);
  void                isExtern (bool);
  void                isMutable (bool);
  void                isRegister (bool);
  void                isExplicit (bool);
  void                isInline (bool);
  void                isAuto (bool);
  void                AssignedScope (CStructure *);

protected:  
  CObjectInfo (ObjectId);

  void CleanUp ();
};

inline CObjectInfo::CObjectInfo (CObjectInfo::ObjectId id) :
  _DeleteMembersOnly (false),
  _Name              (),
  _QualName          ((const char*)0),
  _TypeInfo          ((CTypeInfo*)0),
  _BaseObject        ((CObjectInfo*)0),
  _Next              ((CObjectInfo*)this),
  _Prev              ((CObjectInfo*)this),
  _ClassDB           ((CClassDatabase*)0),
  _Tree              ((CTree*)0),
  _Id                (id),
  _Protection        (CProtection::PROT_NONE), 
  _Linkage           (CLinkage::LINK_NONE),
  _Storage           (CStorage::CLASS_NONE),
  _QualScope         ((CStructure*)0),
  _AssignedScope     ((CStructure*)0)
 {}

inline CObjectInfo::ObjectId CObjectInfo::Id () const
 { return _Id; }

inline bool CObjectInfo::operator !=(const CObjectInfo &info) const
 { return ! (*this == info); }

inline const DString& CObjectInfo::Name () const 
 { return _Name; }
inline CTypeInfo *CObjectInfo::TypeInfo () const
 { return _TypeInfo; }
inline CSourceInfo *CObjectInfo::SourceInfo () const
 { return (CSourceInfo*)&_SourceInfo; }
inline CProtection::Type CObjectInfo::Protection () const
 { return _Protection; }
inline CLinkage::Type CObjectInfo::Linkage () const
 { return _Linkage; }
inline CStorage::Type CObjectInfo::Storage () const
 { return _Storage; }
inline CLanguage &CObjectInfo::Language ()
 { return _Language; }
inline const CLanguage &CObjectInfo::Language () const
 { return _Language; }
inline CObjectInfo *CObjectInfo::BaseObject () const
 { return _BaseObject; }
inline CTree *CObjectInfo::Tree () const 
 { return _Tree; }
inline CClassDatabase *CObjectInfo::ClassDB () const
 { return _ClassDB; }
inline CT_ExprList *CObjectInfo::Init () const 
 { return (CT_ExprList*)0; }

inline void CObjectInfo::Protection (CProtection::Type s)
 { _Protection = s; }
inline void CObjectInfo::Linkage (CLinkage::Type s)
 { _Linkage = s; }
inline void CObjectInfo::Storage (CStorage::Type s)
 { _Storage = s; }
inline void CObjectInfo::BaseObject (CObjectInfo *info)
 { _BaseObject = info; }
inline void CObjectInfo::Tree (CTree *t)    
 { _Tree = t; }
inline void CObjectInfo::ClassDB (CClassDatabase *db) 
 { _ClassDB = db; }
inline void CObjectInfo::DeleteMembersOnly () 
 { _DeleteMembersOnly = true; }

inline void CObjectInfo::Register (CStructure *scope)
 { _Registered.append (scope); }

inline bool CObjectInfo::isAnonymous () const 
 { return (Name ().empty () || *Name ().c_str () == '%'); }
inline bool CObjectInfo::isBuiltin () const
 { return ! (Tree ()); }
inline bool CObjectInfo::isTemplateInstance () const 
 { return (ClassInstance () || UnionInstance () || FctInstance ()); }

inline bool CObjectInfo::isVirtual () const
 { return _Specifiers == CSpecifiers::SPEC_VIRTUAL; }
inline bool CObjectInfo::isStatic () const
 { return _Specifiers == CSpecifiers::SPEC_STATIC; }
inline bool CObjectInfo::isExtern () const
 { return _Specifiers == CSpecifiers::SPEC_EXTERN; }
inline bool CObjectInfo::isMutable () const
 { return _Specifiers == CSpecifiers::SPEC_MUTABLE; }
inline bool CObjectInfo::isRegister () const
 { return _Specifiers == CSpecifiers::SPEC_REGISTER; }
inline bool CObjectInfo::isExplicit () const
 { return _Specifiers == CSpecifiers::SPEC_EXPLICIT; }
inline bool CObjectInfo::isInline () const
 { return _Specifiers == CSpecifiers::SPEC_INLINE; }
inline bool CObjectInfo::isAuto () const
 { return _Specifiers == CSpecifiers::SPEC_AUTO; }

inline void CObjectInfo::isVirtual (bool v)
 { if (v) _Specifiers += CSpecifiers::SPEC_VIRTUAL; 
   else   _Specifiers -= CSpecifiers::SPEC_VIRTUAL; }
inline void CObjectInfo::isStatic (bool v)
 { if (v) _Specifiers += CSpecifiers::SPEC_STATIC; 
   else   _Specifiers -= CSpecifiers::SPEC_STATIC; }
inline void CObjectInfo::isExtern (bool v)
 { if (v) _Specifiers += CSpecifiers::SPEC_EXTERN; 
   else   _Specifiers -= CSpecifiers::SPEC_EXTERN; }
inline void CObjectInfo::isMutable (bool v)
 { if (v) _Specifiers += CSpecifiers::SPEC_MUTABLE; 
   else   _Specifiers -= CSpecifiers::SPEC_MUTABLE; }
inline void CObjectInfo::isRegister (bool v)
 { if (v) _Specifiers += CSpecifiers::SPEC_REGISTER; 
   else   _Specifiers -= CSpecifiers::SPEC_REGISTER; }
inline void CObjectInfo::isExplicit (bool v)
 { if (v) _Specifiers += CSpecifiers::SPEC_EXPLICIT; 
   else   _Specifiers -= CSpecifiers::SPEC_EXPLICIT; }
inline void CObjectInfo::isInline (bool v)
 { if (v) _Specifiers += CSpecifiers::SPEC_INLINE; 
   else   _Specifiers -= CSpecifiers::SPEC_INLINE; }
inline void CObjectInfo::isAuto (bool v)
 { if (v) _Specifiers += CSpecifiers::SPEC_AUTO; 
   else   _Specifiers -= CSpecifiers::SPEC_AUTO; }

// link objects

inline CObjectInfo *CObjectInfo::NextObject () const
 { return _Next; }
inline CObjectInfo *CObjectInfo::PrevObject () const
 { return _Prev; }

inline CMemberAliasInfo *CObjectInfo::MemberAliasInfo () const
 { return _Id == MEMBERALIAS_INFO ? (CMemberAliasInfo*)this : (CMemberAliasInfo*)0; }
inline CBaseClassInfo *CObjectInfo::BaseClassInfo () const
 { return _Id == BASECLASS_INFO ? (CBaseClassInfo*)this : (CBaseClassInfo*)0; }
inline CClassInfo *CObjectInfo::ClassInfo () const
 { return _Id == CLASS_INFO || _Id == CLASS_INSTANCE_INFO ? (CClassInfo*)this : (CClassInfo*)0; }
inline CUnionInfo *CObjectInfo::UnionInfo () const
 { return _Id == UNION_INFO || _Id == UNION_INSTANCE_INFO ? (CUnionInfo*)this : (CUnionInfo*)0; }
inline CEnumInfo *CObjectInfo::EnumInfo () const
 { return _Id == ENUM_INFO ? (CEnumInfo*)this : (CEnumInfo*)0; }
inline CUsingInfo *CObjectInfo::UsingInfo () const
 { return _Id == USING_INFO ? (CUsingInfo*)this : (CUsingInfo*)0; }
inline CEnumeratorInfo *CObjectInfo::EnumeratorInfo () const
 { return _Id == ENUMERATOR_INFO ? (CEnumeratorInfo*)this : (CEnumeratorInfo*)0; }
inline CTypedefInfo *CObjectInfo::TypedefInfo () const
 { return _Id == TYPEDEF_INFO ? (CTypedefInfo*)this : (CTypedefInfo*)0; }
inline CFunctionInfo *CObjectInfo::FunctionInfo () const
 { return _Id == FUNCTION_INFO || _Id == FCT_INSTANCE_INFO ? (CFunctionInfo*)this : (CFunctionInfo*)0; }
inline CArgumentInfo *CObjectInfo::ArgumentInfo () const
 { return _Id == ARGUMENT_INFO ? (CArgumentInfo*)this : (CArgumentInfo*)0; }
inline CAttributeInfo *CObjectInfo::AttributeInfo () const
 { return _Id == ATTRIBUTE_INFO || _Id == ENUMERATOR_INFO ? (CAttributeInfo*)this : (CAttributeInfo*)0; }
inline CNamespaceInfo *CObjectInfo::NamespaceInfo () const
 { return _Id == NAMESPACE_INFO || _Id == FILE_INFO ? (CNamespaceInfo*)this : (CNamespaceInfo*)0; }
inline CLabelInfo *CObjectInfo::LabelInfo () const
 { return _Id == LABEL_INFO ? (CLabelInfo*)this : (CLabelInfo*)0; }
inline CFileInfo *CObjectInfo::FileInfo () const
 { return _Id == FILE_INFO ? (CFileInfo*)this : (CFileInfo*)0; }
inline CStructure *CObjectInfo::Structure () const
 { return NamespaceInfo () || ClassInfo () || UnionInfo () || 
          FunctionInfo () || TemplateInfo () || LocalScope () ? 
          (CStructure*)this : (CStructure*)0; }
inline CRecord *CObjectInfo::Record () const
 { return ClassInfo () || UnionInfo () ? (CRecord*)this : (CRecord*)0; }
inline CLocalScope *CObjectInfo::LocalScope () const
 { return _Id == LOCAL_INFO ? (CLocalScope*)this : (CLocalScope*)0; }
inline CTemplateParamInfo *CObjectInfo::TemplateParamInfo () const
 { return _Id == TEMPLATE_PARAM_INFO ? (CTemplateParamInfo*)this : (CTemplateParamInfo*)0; }
inline CTemplateInfo *CObjectInfo::TemplateInfo () const
 { return _Id == TEMPLATE_INFO ? (CTemplateInfo*)this : (CTemplateInfo*)0; }
inline CScopeInfo *CObjectInfo::ScopeInfo () const
 { return /*_Id == SCOPE_INFO ||*/ Structure () ? (CScopeInfo*)this : (CScopeInfo*)0; }
inline CObjectInfo *CObjectInfo::ObjectInfo () const
 { return (CObjectInfo*)this; }
inline CClassInstance *CObjectInfo::ClassInstance () const
 { return _Id == CLASS_INSTANCE_INFO ? (CClassInstance*)this : (CClassInstance*)0; }
inline CUnionInstance *CObjectInfo::UnionInstance () const
 { return _Id == UNION_INSTANCE_INFO ? (CUnionInstance*)this : (CUnionInstance*)0; }
inline CFctInstance *CObjectInfo::FctInstance () const
 { return _Id == FCT_INSTANCE_INFO ? (CFctInstance*)this : (CFctInstance*)0; }

inline CStructure *CObjectInfo::QualifiedScope () const { 
  return _QualScope;
}

inline void CObjectInfo::AssignedScope (CStructure *s)
 { _AssignedScope = s; }
inline CStructure *CObjectInfo::AssignedScope () const
 { return _AssignedScope; } 


} // namespace Puma

#endif /* __CObjectInfo_h__ */
namespace Puma {


class CLocalScope;
class CFunctionInfo;
class CNamespaceInfo;
class CClassInfo;
class CUnionInfo;
class CTemplateInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScopeInfo : public CObjectInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Array<CScopeInfo*> _Children; // child scopes
  CScopeInfo *_Parent; // parent scope
 
protected:
  CScopeInfo (ObjectId);

public:
  ~CScopeInfo ();

  // Get ... 
  unsigned Children () const;           // children of this scope
  CScopeInfo *Child (unsigned) const;
  CScopeInfo *Parent () const;          // parent scope
  bool isFile () const;                 // is file?
  bool isNamespace () const;            // is namespace?
  bool isRecord () const;               // is class or union?
  bool isClass () const;                // is class?
  bool isUnion () const;                // is union?
  bool isFunction () const;             // is function?
  bool isMethod () const;               // is class method?
  bool isClassTemplate () const;        // is class template?
  bool isFctTemplate () const;          // is function template?
  bool insideTemplate () const;         // is inside class or function template?
  bool insideRecord () const;           // is inside class or union?
  bool insideClass () const;            // is inside class?
  bool insideUnion () const;            // is inside union?
  bool insideFunction () const;         // is inside function?
  bool insideMethod () const;           // is inside class method?
  bool isLocalScope () const;           // is local (block) scope?
  bool isLocalRecord () const;          // is local (block scope) class or union?
  bool isLocalClass () const;           // is local (block scope) class?
  bool isLocalUnion () const;           // is local (block scope) union?
  
  bool GlobalScope () const;            // global (file) scope

  // Set ...
  void Parent (const CScopeInfo *);
  void addChild (CScopeInfo *);
  void removeChild (const CScopeInfo *); // WILL NOT BE DESTROYED!
  
  // Create/Delete ...
  CLocalScope *newLocalScope ();
  CFunctionInfo *newFunction (bool = false);
  CClassInfo *newClass (bool = false);
  CUnionInfo *newUnion (bool = false);
  CNamespaceInfo *newNamespace ();
  CTemplateInfo *newTemplate ();
  void deleteLocalScope (const CLocalScope *);
  void deleteFunction (const CFunctionInfo *);
  void deleteClass (const CClassInfo *);
  void deleteUnion (const CUnionInfo *);
  void deleteNamespace (const CNamespaceInfo *);
  void deleteTemplate (const CTemplateInfo *);
};


inline CScopeInfo::CScopeInfo (CObjectInfo::ObjectId id) :
  CObjectInfo (id),
  _Children (20, 20),
  _Parent ((CScopeInfo*)this)
 {}
 
inline unsigned CScopeInfo::Children () const
 { return _Children.length (); }
inline CScopeInfo *CScopeInfo::Child (unsigned n) const
 { return _Children.lookup (n); }
inline CScopeInfo *CScopeInfo::Parent () const
 { return _Parent; }

inline bool CScopeInfo::isLocalScope () const
 { return LocalScope (); }
inline bool CScopeInfo::isFile () const 
 { return FileInfo (); }
inline bool CScopeInfo::isNamespace () const 
 { return NamespaceInfo (); }
inline bool CScopeInfo::isRecord () const 
 { return Record (); }
inline bool CScopeInfo::isClass () const 
 { return ClassInfo (); }
inline bool CScopeInfo::isUnion () const 
 { return UnionInfo (); }
inline bool CScopeInfo::isFunction () const 
 { return FunctionInfo (); }
inline bool CScopeInfo::GlobalScope () const 
 { return FileInfo (); }

inline bool CScopeInfo::insideFunction () const 
 { return isFunction () || (Parent () && Parent () != this && 
                            Parent ()->insideFunction ()); }
inline bool CScopeInfo::insideMethod () const 
 { return isMethod () || (Parent () && Parent () != this && 
                          Parent ()->insideMethod ()); }
inline bool CScopeInfo::insideRecord () const 
 { return isRecord () || (Parent () && Parent () != this && 
                          Parent ()->insideRecord ()); }
inline bool CScopeInfo::insideTemplate () const 
 { return isTemplate () || (Parent () && Parent () != this && 
                            Parent ()->insideTemplate ()); }
inline bool CScopeInfo::insideClass () const 
 { return isClass () || (Parent () && Parent () != this && 
                         Parent ()->insideClass ()); }
inline bool CScopeInfo::insideUnion () const 
 { return isUnion () || (Parent () && Parent () != this && 
                         Parent ()->insideUnion ()); }

inline bool CScopeInfo::isLocalClass () const 
 { return isClass () && insideFunction (); }
inline bool CScopeInfo::isLocalUnion () const 
 { return isUnion () && insideFunction (); }
inline bool CScopeInfo::isLocalRecord () const 
 { return isRecord () && insideFunction (); }


} // namespace Puma

#endif /* __CScopeInfo_h__ */
#ifndef __puma

#include <map>
#include <set>
#include <list>
#include <string>
#include "Puma/DString.h"
using namespace std;

#endif

namespace Puma {


class CAttributeInfo;
class CTemplateParamInfo;
class CFunctionInfo;
class CClassInfo;
class CUnionInfo;
class CEnumInfo;
class CTypedefInfo;
class CNamespaceInfo;
class CUsingInfo;
class CMemberAliasInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CStructure : public CScopeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
#ifndef __puma
  typedef list<CObjectInfo*> ObjectInfoList;
  typedef map<DString,ObjectInfoList> ObjectsByName;
  typedef set<CObjectInfo*> ObjectInfoSet;
#endif 

private:
  CStructure                *_Shared;
  Array<CObjectInfo*>        _Objects; // ALL objects (mixed, in the order added to)
  Array<CAttributeInfo*>     _Attributes;
  Array<CTemplateParamInfo*> _TemplateParams;
  Array<CFunctionInfo*>      _Functions;
  Array<CObjectInfo*>        _Types;
  Array<CUsingInfo*>         _Usings;     
  Array<CRecord*>            _Friends;
  Array<CNamespaceInfo*>     _Namespaces;     
  Array<CMemberAliasInfo*>   _Aliases;     
#ifndef __puma
  ObjectsByName              _ObjectMap;
  ObjectInfoSet              _ObjectSet;
#endif

protected:
  CStructure (ObjectId);

public:
  ~CStructure ();

  // Get ... 
#ifndef __puma
  ObjectsByName& ObjectInfoMap() { return _Shared->_ObjectMap; }
  const ObjectInfoSet& ObjectInfos() const { return _Shared->_ObjectSet; }
#endif 
  unsigned Objects () const;                        // all entities in scope
  unsigned Objects (const DString&) const;
  unsigned Types () const;                          // type declarations
  unsigned Types (const DString&) const;
  unsigned Attributes () const;                     // data objects
  unsigned Attributes (const DString&) const;
  unsigned TemplateParams () const;                 // template parameters
  unsigned TemplateParams (const DString&) const;
  unsigned Functions () const;                      // functions, methods, function
  unsigned Functions (const DString&) const;        // templates and its instances
  unsigned Usings () const;                         // using-directives
  unsigned Usings (const DString&) const;
  unsigned Namespaces () const;                     // namespaces
  unsigned Namespaces (const DString&) const;
  unsigned Friends () const;                        // friend function declarations
  unsigned Friends (const DString&) const;
  CObjectInfo *Object (unsigned) const;
  CObjectInfo *Object (const DString&, unsigned = 0) const;
  CObjectInfo *Type (unsigned) const;
  CObjectInfo *Type (const DString&, unsigned = 0) const;
  CUsingInfo *Using (unsigned) const;
  CUsingInfo *Using (const DString&, unsigned = 0) const;
  CNamespaceInfo *Namespace (unsigned) const;
  CNamespaceInfo *Namespace (const DString&, unsigned = 0) const;
  CRecord *Friend (unsigned) const;
  CRecord *Friend (const DString&, unsigned = 0) const;
  CAttributeInfo *Attribute (unsigned) const;
  CAttributeInfo *Attribute (const DString&, unsigned = 0) const;
  CTemplateParamInfo *TemplateParam (unsigned) const;
  CTemplateParamInfo *TemplateParam (const DString&, unsigned = 0) const;
  CFunctionInfo *Function (unsigned) const;
  CFunctionInfo *Function (const DString&, unsigned = 0) const;
  CFunctionInfo *Function (const DString&, CTypeInfo *) const;

  bool isMemberAlias (const CObjectInfo *) const; // is a member alias info?
  CMemberAliasInfo *MemberAlias (const CObjectInfo *) const; // get denoted member

  // Set ...
  void setShared (CStructure *);
  void addObject (CObjectInfo *);
  void addAttribute (CAttributeInfo *);
  void addTemplateParam (CTemplateParamInfo *);
  void addFunction (CFunctionInfo *);
  void addType (CObjectInfo *);
  void addUsing (CUsingInfo *);
  void addNamespace (CNamespaceInfo *);
  void addFriend (CRecord *);
  void removeObject (const CObjectInfo *);       // WILL NOT BE DESTROYED!
  void removeAttribute (const CAttributeInfo *); // WILL NOT BE DESTROYED!
  void removeTemplateParam (const CTemplateParamInfo *); // WILL NOT BE DESTROYED!
  void removeFunction (const CFunctionInfo *);   // WILL NOT BE DESTROYED!
  void removeType (const CObjectInfo *);         // WILL NOT BE DESTROYED!
  void removeUsing (const CUsingInfo *);         // WILL NOT BE DESTROYED!
  void removeNamespace (const CNamespaceInfo *); // WILL NOT BE DESTROYED!
  void removeFriend (const CRecord *);           // WILL NOT BE DESTROYED!
  void removeMemberAlias (const CMemberAliasInfo *); // WILL NOT BE DESTROYED!

  void removeRegisterEntry ();
  
  void addObjectName(CObjectInfo *); // internal use only, do not call directly
  void removeObjectName (const DString& name, CObjectInfo *info) ; // internal use only

  // Create/Delete ...
  CAttributeInfo *newAttribute ();
  CEnumInfo *newEnum ();
  CUsingInfo *newUsing ();
  CTypedefInfo *newTypedef ();
  CMemberAliasInfo *newMemberAlias (CObjectInfo *);
  void deleteAttribute (const CAttributeInfo *); 
  void deleteEnum (const CEnumInfo *);
  void deleteUsing (const CUsingInfo *);
  void deleteTypedef (const CTypedefInfo *);
  void deleteMemberAlias (const CMemberAliasInfo *);
};

#define INIT_SIZE 20
#define INCR_SIZE 20

inline CStructure::CStructure (CObjectInfo::ObjectId id) :
  CScopeInfo (id),
  _Shared (this),
  _Objects (INIT_SIZE, INCR_SIZE),
  _Attributes (INIT_SIZE, INCR_SIZE),
  _TemplateParams (INIT_SIZE, INCR_SIZE),
  _Functions (INIT_SIZE, INCR_SIZE),
  _Types (INIT_SIZE, INCR_SIZE),
  _Usings (INIT_SIZE, INCR_SIZE),
  _Friends (INIT_SIZE, INCR_SIZE),
  _Namespaces (INIT_SIZE, INCR_SIZE),
  _Aliases (INIT_SIZE, INCR_SIZE)
 {}
 
inline unsigned CStructure::Objects () const
 { return _Objects.length (); }
inline unsigned CStructure::Types () const
 { return _Types.length (); }
inline unsigned CStructure::Attributes () const
 { return _Attributes.length (); }
inline unsigned CStructure::TemplateParams () const
 { return _TemplateParams.length (); }
inline unsigned CStructure::Functions () const
 { return _Functions.length (); }
inline unsigned CStructure::Usings () const
 { return _Usings.length (); }
inline unsigned CStructure::Namespaces () const
 { return _Namespaces.length (); }
inline unsigned CStructure::Friends () const
 { return _Friends.length (); }
inline CObjectInfo *CStructure::Object (unsigned n) const
 { return _Objects.lookup (n); }
inline CObjectInfo *CStructure::Type (unsigned n) const
 { return _Types.lookup (n); }
inline CAttributeInfo *CStructure::Attribute (unsigned n) const
 { return _Attributes.lookup (n); }
inline CTemplateParamInfo *CStructure::TemplateParam (unsigned n) const
 { return _TemplateParams.lookup (n); }
inline CFunctionInfo *CStructure::Function (unsigned n) const
 { return _Functions.lookup (n); }
inline CUsingInfo *CStructure::Using (unsigned n) const
 { return _Usings.lookup (n); }
inline CNamespaceInfo *CStructure::Namespace (unsigned n) const
 { return _Namespaces.lookup (n); }
inline CRecord *CStructure::Friend (unsigned n) const
 { return _Friends.lookup (n); }

inline bool CStructure::isMemberAlias (const CObjectInfo *info) const
 { return (MemberAlias (info)); }
 

} // namespace Puma

#endif /* __CStructure_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CSemVisitor_h__
#define __CSemVisitor_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CVisitor_h__
#define __CVisitor_h__

// Iterate through a C++ syntax tree

namespace Puma {


class CTree;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CVisitor {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  bool _aborted;
  bool _pruned;

  void visit_sons (CTree *node);

public:
  CVisitor () : _aborted (false), _pruned (false) {}
  virtual ~CVisitor () {}

  void abort (bool v = true) { _aborted = v; }
  void prune (bool v = true) { _pruned = v; }
  bool aborted () const { return _aborted; }
  bool pruned () const { return _pruned; }
  
  void visit (CTree *node);

  virtual void pre_visit (CTree *node);
  virtual void post_visit (CTree *node);
};


} // namespace Puma

#endif /* __CVisitor_h__ */
/* This file was generated by the PUMA library, version 1.1. */

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Limits_h__
#define __Limits_h__

namespace Puma {


// type `long long' support

#if defined(__GNUC__) || defined(_MSC_VER)
typedef long long LONG_LONG;
typedef unsigned long long U_LONG_LONG;
#else /* __GNUC__ */
typedef long LONG_LONG;
typedef unsigned long U_LONG_LONG;
#endif /* __GNUC__ */

#ifndef LLONG_MAX
#  if defined(__GNUC__) || defined(_MSC_VER)
#    define LLONG_MAX        9223372036854775807LL
#    define LLONG_MIN        (-LLONG_MAX - 1LL)
#    define ULLONG_MAX        18446744073709551615ULL
#  else /* __GNUC__ */
#    define LLONG_MAX        LONG_MAX
#    define LLONG_MIN        LONG_MIN
#    define ULLONG_MAX       ULONG_MAX
#  endif /* __GNUC__ */
#endif /* LLONG_MAX */

// type size (in bits)

#define BOOL_SIZE             8
#define CHAR_SIZE             8
#define SCHAR_SIZE            8
#define UCHAR_SIZE            8
#define SHORT_SIZE            16
#define USHORT_SIZE           16
#define WCHAR_T_SIZE          32
#define INT_SIZE              32
#define UINT_SIZE             32
#define LONG_SIZE             32
#define ULONG_SIZE            32
#define LLONG_SIZE            64
#define ULLONG_SIZE           64

#define FLOAT_SIZE            32
#define DOUBLE_SIZE           64
#define LDOUBLE_SIZE          96

#define PTR_SIZE              32
#define MEMB_PTR_SIZE         64

#define ENUM_SIZE             32


} // namespace Puma

#endif /* __Limits_h__ */

#ifndef __ac_fwd_ExtACTree__
#define __ac_fwd_ExtACTree__
class ExtACTree;
namespace AC {
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a1_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#endif
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTree_h__
#define __CTree_h__

namespace Puma {


// Syntax tree node hierarchy:
class CTree;
class   CT_Statement;          
class     CT_LabelStmt;
class     CT_IfStmt;
class     CT_IfElseStmt;
class     CT_SwitchStmt;
class     CT_BreakStmt;
class     CT_ExprStmt;
class     CT_WhileStmt;
class     CT_DoStmt;
class     CT_ForStmt;
class     CT_ContinueStmt;
class     CT_ReturnStmt;
class     CT_GotoStmt;
class     CT_DeclStmt;
class     CT_CaseStmt;
class     CT_DefaultStmt;
class     CT_TryStmt;
class   CT_Expression;
class     CT_ThrowExpr;
class     CT_NewExpr;
class     CT_DeleteExpr;
class     CT_ConstructExpr;
class     CT_Integer;
class     CT_Character;
class       CT_WideCharacter;
class     CT_Float;
class     CT_Bool;
class     CT_BracedExpr;
class     CT_BinaryExpr;
class       CT_MembPtrExpr;
class         CT_MembRefExpr;
class     CT_UnaryExpr;
class       CT_PostfixExpr;
class       CT_AddrExpr;
class       CT_DerefExpr;
class     CT_IfThenExpr;
class     CT_CmpdLiteral;
class     CT_IndexExpr;
class     CT_CallExpr;
class     CT_CastExpr;
class     CT_StaticCast;
class       CT_ConstCast;
class       CT_ReintCast;
class       CT_DynamicCast;
class     CT_TypeidExpr;
class     CT_SizeofExpr;
class     CT_MembDesignator;
class     CT_IndexDesignator;
class     CT_ImplicitCast;
class   CT_DeclSpec;
class     CT_PrimDeclSpec;
class     CT_NamedType;
class     CT_ClassSpec;
class       CT_UnionSpec;
class       CT_EnumSpec;
class     CT_ExceptionSpec;
class   CT_Declarator;
class     CT_InitDeclarator;
class     CT_BracedDeclarator;
class     CT_ArrayDeclarator;
class     CT_FctDeclarator;
class     CT_RefDeclarator;
class     CT_PtrDeclarator;
class     CT_MembPtrDeclarator;
class     CT_BitFieldDeclarator;
class   CT_Decl;
class     CT_ObjDecl;
class     CT_ArgDecl;
class     CT_AccessDecl;
class       CT_UsingDecl;
class     CT_FctDef;
class     CT_AsmDef;
class     CT_EnumDef;
class     CT_ClassDef;
class       CT_UnionDef;
class     CT_Enumerator;
class     CT_LinkageSpec;
class     CT_Handler;
class     CT_TemplateDecl;
class     CT_TemplateParamDecl;
class       CT_TypeParamDecl;
class       CT_NonTypeParamDecl;
class     CT_NamespaceDef;
class     CT_NamespaceAliasDef;
class     CT_UsingDirective;
class   CT_List;
class     CT_CmpdStmt;
class     CT_DeclSpecSeq;
class     CT_HandlerSeq;
class     CT_DesignatorSeq;
class     CT_DeclList;
class       CT_Program;
class       CT_ArgDeclList;
class         CT_ArgNameList;
class       CT_ArgDeclSeq;
class       CT_MembList;
class     CT_ExprList;
class     CT_DeclaratorList;
class     CT_BaseSpecList;
class     CT_MembInitList;
class     CT_SimpleName;
class       CT_SpecialName;
class         CT_PrivateName;
class         CT_OperatorName;
class         CT_DestructorName;
class         CT_ConversionName;
class         CT_TemplateName;
class       CT_QualName;
class         CT_RootQualName;
class     CT_String;
class       CT_WideString;
class     CT_TemplateParamList;
class     CT_TemplateArgList;
class   CT_Token;
class   CT_Error;
class   CT_Condition;
class   CT_BaseSpec;
class   CT_AccessSpec;
class   CT_ArrayDelimiter;
class   CT_Any;
class   CT_AnyList;
class   CT_AnyExtension;
class   CT_AnyCondition;


} // namespace Puma

#include "Puma/ErrorSeverity.h"
#include "Puma/CSemObject.h"
#include "Puma/CSemScope.h"
#include "Puma/CSemValue.h"
#include "Puma/CExprValue.h"
#include "Puma/CStrLiteral.h"
#include "Puma/CTypeInfo.h"
#include "Puma/Printable.h"
#include "Puma/CTokens.h"
#include "Puma/Token.h"

#include <iostream>
#include <string.h>
using namespace std;

namespace Puma {


class ErrorStream;
class CObjectInfo;
class CStructure;

/*****************************************************************************/
/*                                                                           */
/*                    S y n t a x  t r e e  n o d e s                        */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  /*DEBUG*/static int alloc;
  /*DEBUG*/static int release;

protected:
  CTree *Son (CTree * const *, int, int) const;
  int Sons (CTree * const *, int) const;
  void ReplaceSon (CTree * const *, int, CTree *, CTree *) const;
  
protected:
  CTree () { /*DEBUG*/alloc++; }

public:
  virtual ~CTree () { /*DEBUG*/release++; }
  virtual int Sons () const = 0;
  virtual CTree *Son (int n) const { return (CTree*)0; }
  virtual const char *NodeName () const = 0;
  virtual Token *token () const;
  virtual Token *end_token () const;
  virtual CT_Token *token_node () const;
  virtual CT_Token *end_token_node () const;
  virtual void ReplaceSon (CTree *, CTree *) {}

public: // semantic information
  virtual CTypeInfo *Type () const { return (CTypeInfo*)0; }
  virtual CExprValue *Value () const { return (CExprValue*)0; }
  
  virtual CSemValue *SemValue () const { return (CSemValue*)0; }
  virtual CSemObject *SemObject () const { return (CSemObject*)0; }
  
public: // node classification function
  virtual CT_SimpleName *IsSimpleName () { return 0; }
  virtual CT_Declarator *IsDeclarator () { return 0; }
   private:
  typedef CTree CCExprResolveCTree;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CTree CExprResolveCTree;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Error : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Token : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Token *_token;
  unsigned long int _number;
  
public:
  CT_Token (Token *t, unsigned long int n = 0) : 
    _token (t), _number (n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
  Token *token () const { return _token; }
  Token *end_token () const { return _token; }
  CT_Token *token_node () const { return (CT_Token*)this; }
  CT_Token *end_token_node () const { return (CT_Token*)this; }
  void Number (unsigned long int n) { _number = n; }
  unsigned long int Number () const { return _number; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
};

/*****************************************************************************/
/*                                                                           */
/*                              List nodes                                   */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_List : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Array<CTree*> _sons;
  int _properties;

protected:
  CT_List(int size = 5, int incr = 5, int props = 0) : 
    _sons (size, incr), _properties (props) {}

public:
  enum {
    OPEN = 1,         // has a start token like ':' in ":a(1),b(2)"
    CLOSE = 2,
    OPEN_CLOSE = 3,   // has opening and closing delimiters, e.g. '(' ')'
    SEPARATORS = 4,   // the list has separators like ','
    FORCE_EMPTY = 8,  // pretend to be empty, e.g. for "(void)"
    END_SEP = 16,     // has separator after last element, e.g. "a,b,c,"
    NO_LAST_SEP = 32, // no separator before last element, e.g. "(a,b...)"
    INTRO = 64        // has an introduction char, e.g. "=" in "={a,b}"
  };
 
  int Entries () const;
  CTree *Entry (int no) const;
  int Sons () const { return _sons.length (); }
  CTree *Son (int n) const { return _sons.lookup (n); }
  int GetProperties () const { return _properties; }
  void AddProperties (int p) { _properties |= p; }
  void AddSon (CTree *s) { if (s) _sons.append (s); }
  void PrefixSon (CTree *s) { if (s) _sons.prepend (s); }
  void InsertSon (CTree *, CTree *);  // before given son
  void ReplaceSon (CTree *, CTree *);
  void RemoveSon (CTree *);
  void InsertSon (int idx, CTree *s)
   { if (idx <= Sons ()) _sons.insert (idx, s); }
  void ReplaceSon (int idx, CTree *s) 
   { if (idx < Sons ()) _sons[idx] = s; }
  void RemoveSon (int idx) 
   { if (idx < Sons ()) _sons.remove (idx); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExprList : public CT_List, public CSemValue, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ExprList () { AddProperties (SEPARATORS); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclaratorList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumeratorList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_EnumeratorList () { AddProperties (SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
   
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DeclList (int size = 20, int incr = 20) : CT_List (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void Linkage (CT_LinkageSpec *l);
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclSpecSeq : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CmpdStmt : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_CmpdStmt () { AddProperties (OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_HandlerSeq : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateParamList : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateParamList () { AddProperties (INTRO | SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateArgList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateArgList () { AddProperties (SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

/*****************************************************************************/
/*                                                                           */
/*                              Expressions                                  */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Expression : public CTree, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_Expression () {}

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
   private:
  typedef CT_Expression CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Expression CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_String : public CT_List, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_String (int size) : CT_List (size, 1) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
   private:
  typedef CT_String CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_String CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WideString : public CT_String {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_WideString (int size) : CT_String (size) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_WideString CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_WideString CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Integer : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Integer (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return _value ? 1 : 0; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Integer CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Integer CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Character : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Character (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Character CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Character CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WideCharacter : public CT_Character {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_WideCharacter (CTree *t) : CT_Character (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_WideCharacter CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_WideCharacter CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Float : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Float (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Float CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Float CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Bool : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Bool (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Bool CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Bool CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BracedExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // open, expr, close

public:
  CT_BracedExpr (CTree *o, CTree *e, CTree *c) { 
    sons[0] = o; sons[1] = e; sons[2] = c; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Expr () const { return sons[1]; }
  CTypeInfo *Type () const { return Expr ()->Type (); }
  CExprValue *Value () const { return Expr ()->Value (); }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
   private:
  typedef CT_BracedExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_BracedExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SimpleName : public CT_List, public Printable, 
                      public CSemValue, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_SimpleName (int size) : CT_List (size, 1) {}
  CT_SimpleName (int size, int properties) : 
    CT_List (size, 2, properties) {}
  
public:
  CT_SimpleName (CTree *n) : CT_List (1, 1) { AddSon (n); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  virtual const char *Text () const 
   { return Son (Sons ()-1)->token ()->text (); }
  virtual void print (ostream &os) const { os << Text (); }
  virtual CT_SimpleName *Name () const { return (CT_SimpleName*)this; }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
  // classification function
  virtual CT_SimpleName *IsSimpleName () { return this; }  
   private:
  typedef CT_SimpleName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_SimpleName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SpecialName : public CT_SimpleName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  char *_name;
  
protected:
  CT_SpecialName (int size = 1) : CT_SimpleName (size), _name (0) {}
  
public:
  ~CT_SpecialName () { if (_name) delete[] _name; }
  const char *Text () const { return _name; }
  void Name (const char *n) { 
    if (n) { 
      _name = new char[strlen(n) + 1];
      strcpy (_name,n);
    }
  }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_SpecialName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_SpecialName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PrivateName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_PrivateName (const char *n) { Name (n); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
  CTree *Son (int n) const { return (CTree*)0; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_PrivateName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_PrivateName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DestructorName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DestructorName (CTree *, CTree *);
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_DestructorName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DestructorName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateName (CTree *n, CTree *a) 
   { AddSon (n); AddSon (a); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CT_TemplateArgList *Arguments () const 
   { return (CT_TemplateArgList*)Son (Sons ()-1); }
  CT_SimpleName *TemplateName () const 
   { return (CT_SimpleName*)Son (Sons ()-2); }
  // may change in the future
  const char *Text () const { return TemplateName ()->Text (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_TemplateName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_TemplateName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_OperatorName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _oper;

public:
  enum { // complex operators
    FCT_CALL = -100,
    SUBSCRIPT,
    NEW_ARRAY,
    DEL_ARRAY
  };
 
public:
  CT_OperatorName (CTree *);
  CT_OperatorName (CTree *, CTree *, CTree *, CTree *);
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Operator () const { return _oper; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_OperatorName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_OperatorName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ConversionName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ConversionName (CTree *, CTree *);
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CT_NamedType *TypeName () const { return (CT_NamedType*)Son (Sons ()-1); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_ConversionName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ConversionName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_QualName : public CT_SimpleName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_QualName (int size = 3) : 
    CT_SimpleName (size, CT_List::SEPARATORS) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void print (ostream &) const;
  CT_SimpleName *Name () const { return (CT_SimpleName*)Son (Sons ()-1); }
  const char *Text () const { return Name ()->Text (); }
  CTypeInfo *Type () const { return Name ()->Type (); }
  CExprValue *Value () const { return Name ()->Value (); }
  CSemValue *SemValue () const { return Name ()->SemValue (); }
  CSemObject *SemObject () const { return Name ()->SemObject (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_QualName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_QualName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_RootQualName : public CT_QualName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_RootQualName (int size = 2) : 
    CT_QualName (size) { AddProperties (INTRO); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_RootQualName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_RootQualName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BinaryExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // expr, oper, expr

public:
  CT_BinaryExpr (CTree *l, CTree *o, CTree *r) {
    sons[0] = l; sons[1] = o; sons[2] = r;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
   private:
  typedef CT_BinaryExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_BinaryExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembPtrExpr : public CT_BinaryExpr, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembPtrExpr (CTree *e, CTree *o, CTree *i) :
    CT_BinaryExpr (e, o, i) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_MembPtrExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembPtrExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembRefExpr : public CT_MembPtrExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembRefExpr (CTree *e, CTree *o, CTree *i) :
    CT_MembPtrExpr (e, o, i) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_MembRefExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembRefExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UnaryExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // oper, expr

public:
  CT_UnaryExpr (CTree *o, CTree *e) { sons[0] = o; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[1]; }
   private:
  typedef CT_UnaryExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_UnaryExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PostfixExpr : public CT_UnaryExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_PostfixExpr (CTree *e, CTree *o) :
    CT_UnaryExpr (e, o) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_PostfixExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_PostfixExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AddrExpr : public CT_UnaryExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_AddrExpr (CTree *o, CTree *e) :
    CT_UnaryExpr (o, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_AddrExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_AddrExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DerefExpr : public CT_UnaryExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DerefExpr (CTree *o, CTree *e) :
    CT_UnaryExpr (o, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_DerefExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DerefExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeleteExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // oper, expr

public:
  CT_DeleteExpr (CTree *op, CTree *e) { sons[0] = op; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[1]; }
  CT_SimpleName *OperName () const { return (CT_SimpleName*)sons[0]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_DeleteExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DeleteExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NewExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[6]; // oper, placement, open, type, close, init

public:
  CT_NewExpr (CTree *op, CTree *p, CTree *o, CTree *t, CTree *c, CTree *i) {
    sons[0] = op; sons[1] = p; sons[2] = o; sons[3] = t; sons[4] = c; sons[5] = i; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 6); }
  CTree *Son (int n) const { return CTree::Son (sons, 6, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 6, old_son, new_son);
  }
  CT_SimpleName *OperName () const { return (CT_SimpleName*)sons[0]; }
  CT_ExprList *Placement () const { return (CT_ExprList*)sons[1];; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[5]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[3]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_NewExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_NewExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IfThenExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // cond, oper, left, colon, right

public:
  CT_IfThenExpr (CTree *c1, CTree *o, CTree *l, CTree *c2, CTree *r) {
    sons[0] = c1; sons[1] = o; sons[2] = l; sons[3] = c2; sons[4] = r;
  }
  CT_IfThenExpr (CTree *c1, CTree *o, CTree *c2, CTree *r) {
    sons[0] = c1; sons[1] = o; sons[2] = 0; sons[3] = c2; sons[4] = r;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CTree *Condition () const { return sons[0]; }
  CTree *LeftOperand () const { return sons[2]; }
  CTree *RightOperand () const { return sons[4]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
   private:
  typedef CT_IfThenExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_IfThenExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CmpdLiteral : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // open, type, close, init

public:
  CT_CmpdLiteral (CTree *r, CTree *t, CTree *cr, CTree *i) {
    sons[0] = r; sons[1] = t; sons[2] = cr; sons[3] = i;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[1]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[3]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_CmpdLiteral CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_CmpdLiteral CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ConstructExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // type, init

public:
  CT_ConstructExpr (CTree *t, CTree *i) { sons[0] = t; sons[1] = i; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[0]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_ConstructExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ConstructExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ThrowExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // throw, expr

public:
  CT_ThrowExpr (CTree *t, CTree *e = (CTree*)0) { sons[0] = t; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[1]; }
   private:
  typedef CT_ThrowExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ThrowExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IndexExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // expr, open, index, close

public:
  CT_IndexExpr (CTree *e, CTree *o, CTree *i, CTree *c) {
    sons[0] = e; sons[1] = o; sons[2] = i; sons[3] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
   private:
  typedef CT_IndexExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_IndexExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CallExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // expr, args

public:
  CT_CallExpr (CTree *e) { sons[0] = e; sons[1] = 0; }
  CT_CallExpr (CTree *e, CTree *l) { sons[0] = e; sons[1] = l; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); } 
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[0]; }
  CT_ExprList *Arguments () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_CallExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_CallExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CastExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // open, type, close, expr

public:
  CT_CastExpr (CTree *o, CTree *t, CTree *c, CTree *e) {
    sons[0] = o; sons[1] = t; sons[2] = c; sons[3] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CTree *Expr () const { return sons[3]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[1]; }
   private:
  typedef CT_CastExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_CastExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_StaticCast : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // cast, open, type, close, expr

public:
  CT_StaticCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) {
    sons[0] = cst; sons[1] = o; sons[2] = t; sons[3] = c; sons[4] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Expr () const { return sons[4]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[2]; }
   private:
  typedef CT_StaticCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_StaticCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ConstCast : public CT_StaticCast {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ConstCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) :
    CT_StaticCast (cst, o, t, c, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_ConstCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ConstCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ReintCast : public CT_StaticCast {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ReintCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) :
    CT_StaticCast (cst, o, t, c, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_ReintCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ReintCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DynamicCast : public CT_StaticCast {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DynamicCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) :
    CT_StaticCast (cst, o, t, c, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_DynamicCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DynamicCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ImplicitCast : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_expr; // casted expression

public:
  CT_ImplicitCast (CTree *e) : _expr (e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return n == 0 ? _expr : (CTree*)0; }
  CTree *Expr () const { return _expr; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _expr) _expr = new_son; }
   private:
  typedef CT_ImplicitCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ImplicitCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TypeidExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // typeid, open, type_id/expr, close

public:
  CT_TypeidExpr (CTree *tid, CTree *o, CTree *e, CTree *c) {
    sons[0] = tid; sons[1] = o; sons[2] = e; sons[3] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CTree *Arg () const { return sons[2]; }
   private:
  typedef CT_TypeidExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_TypeidExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SizeofExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // key, open, type, close, expr

public:
  CT_SizeofExpr (CTree *k, CTree *o, CTree *t, CTree *c) {
    sons[0] = k; sons[1] = o; sons[2] = t; sons[3] = c; sons[4] = 0;
  }
  CT_SizeofExpr (CTree *k, CTree *e) {
    sons[0] = k; sons[1] = 0; sons[2] = 0; sons[3] = 0; sons[4] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Expr () const { return sons[4]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[2]; }
   private:
  typedef CT_SizeofExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_SizeofExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IndexDesignator : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // open, index, close

public:
  CT_IndexDesignator (CTree *o, CTree *i, CTree *c) {
    sons[0] = o; sons[1] = i; sons[2] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
   private:
  typedef CT_IndexDesignator CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_IndexDesignator CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembDesignator : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // dot, member

public:
  CT_MembDesignator (CTree *d, CTree *m) { sons[0] = d; sons[1] = m; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
   private:
  typedef CT_MembDesignator CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembDesignator CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DesignatorSeq : public CT_List, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DesignatorSeq (int size = 1) : CT_List (size, 2) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
};

/*****************************************************************************/
/*                                                                           */
/*                         Declaration specifiers                            */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclSpec : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_DeclSpec () {}
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PrimDeclSpec : public CT_DeclSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  enum Type { PDS_FRIEND, PDS_TYPEDEF, PDS_AUTO, PDS_REGISTER, PDS_STATIC, 
              PDS_EXTERN, PDS_MUTABLE, PDS_INLINE, PDS_VIRTUAL, PDS_EXPLICIT, 
              PDS_CONST, PDS_VOLATILE, PDS_RESTRICT, PDS_CHAR, PDS_WCHAR_T, 
              PDS_BOOL, PDS_SHORT, PDS_INT, PDS_LONG, PDS_SIGNED, PDS_UNSIGNED, 
              PDS_FLOAT, PDS_DOUBLE, PDS_VOID, 
              // AspectC++ specific type specifier
              PDS_UNKNOWN_T,
              // Win specific declaration specifiers
              PDS_CDECL, PDS_STDCALL, PDS_FASTCALL, PDS_INT64,
              PDS_UNKNOWN, PDS_NUM };

private:
  Type _type;
  CT_Token *_token;

  void determine_type ();

public:
  CT_PrimDeclSpec (CT_Token *t) : _token (t) { determine_type (); }
  CT_PrimDeclSpec (Type t) : _token (0) { _type = t; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return _token ? 1 : 0; }
  CTree *Son (int n) const 
   { return (n == 0) ? _token : (CTree*)0; }
  const char *SpecText () const 
   { return _token ? _token->token ()->text ().c_str () : " "; }
  Type SpecType () const { return _type; }
  static const int NumTypes = PDS_NUM;
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NamedType : public CT_DeclSpec, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // declspecs, declarator

public:
  CT_NamedType (CTree *dss, CTree *d) { sons[0] = dss; sons[1] = d; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Declarator () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};
      
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ClassSpec : public CT_DeclSpec, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // key, name
  
public:
  CT_ClassSpec (CTree *k, CTree *n) { sons[0] = k; sons[1] = n; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); } 
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UnionSpec : public CT_ClassSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_UnionSpec (CTree *k, CTree *n) : CT_ClassSpec (k, n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumSpec : public CT_ClassSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_EnumSpec (CTree *k, CTree *n) : CT_ClassSpec (k, n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExceptionSpec : public CT_DeclSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // throw, type_id_list
  
public:
  CT_ExceptionSpec (CTree *k, CTree *l) { sons[0] = k; sons[1] = l; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CT_ArgDeclList *Arguments () const { return (CT_ArgDeclList*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Declarations                                 */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Decl : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;
 
  CT_LinkageSpec *_linkage;
protected:
  CT_Decl () : _linkage (0) {}
public:
  void Linkage (CT_LinkageSpec *l) { _linkage = l; }
  CT_LinkageSpec *Linkage () const { return _linkage; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Program : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_Program (int size = 20, int incr = 20) : CT_DeclList (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
   
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ObjDecl : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declspecs, declarators, colon

public:
  CT_ObjDecl (CTree *dsl, CTree *dl, CTree *c) {
    sons[0] = dsl; sons[1] = dl; sons[2] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CT_DeclaratorList *Declarators () const { return (CT_DeclaratorList*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateDecl : public CT_Decl, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // export, param_list, decl

public:
  CT_TemplateDecl (CTree *e, CTree *p, CTree *d) {
    sons[0] = e; sons[1] = p; sons[2] = d;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son); 
  }
  CTree *Export () const { return sons[0]; }
  CT_TemplateParamList *Parameters () const { 
    return (CT_TemplateParamList*)sons[1]; 
  }
  CTree *Declaration () const { return sons[2]; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateParamDecl : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_TemplateParamDecl () {}
  
public:
  virtual CT_ExprList *DefaultArgument () const = 0;
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NonTypeParamDecl : public CT_TemplateParamDecl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declspecs, declarator, init

public:
  CT_NonTypeParamDecl (CTree *dsl, CTree *d, CTree *i = (CTree*)0) {
    sons[0] = dsl; sons[1] = d; sons[2] = i;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_ExprList *DefaultArgument () const { return (CT_ExprList*)sons[2]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Initializer (CTree *i) { sons[2] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TypeParamDecl : public CT_TemplateParamDecl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // params, key, id, init

public:
  CT_TypeParamDecl (CTree *t, CTree *k, CTree *id, CTree *i = (CTree*)0) { 
    sons[0] = t; sons[1] = k; sons[2] = id; sons[3] = i;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_TemplateParamList *Parameters () const { 
    return (CT_TemplateParamList*)sons[0]; 
  }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[2]; }
  CT_ExprList *DefaultArgument () const { return (CT_ExprList*)sons[3]; }
  void Initializer (CTree *i) { sons[3] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // key, name, enumerators

public:
  CT_EnumDef (CTree *k, CTree *n) {
    sons[0] = k; sons[1] = n; sons[2] = 0; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  void Enumerators (CTree *el) { sons[2] = el; }
  CT_EnumeratorList *Enumerators () const { return (CT_EnumeratorList*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Enumerator : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // name, init

public:
  CT_Enumerator (CTree *n) { sons[0] = n; sons[1] = 0; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[0]; }
  void Initializer (CTree *i) { sons[1] = i; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son); 
  }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_FctDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[7]; // declspecs, declarator, try, ctor_init, args, body, handlers

public:
  CT_FctDef (CTree *dss, CTree *d, CTree *t, CTree *ci, CTree *as, 
             CTree *b, CTree *hs) {
    sons[0] = dss; sons[1] = d; sons[2] = t; sons[3] = ci; sons[4] = as; 
    sons[5] = b; sons[6] = hs; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 7); }
  CTree *Son (int n) const { return CTree::Son (sons, 7, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_Token *TryKey () const { return (CT_Token*)sons[2]; }
  CTree *CtorInit () const { return sons[3]; }
  CT_ArgDeclSeq *ArgDeclSeq () const { return (CT_ArgDeclSeq*)sons[4]; }
  CT_CmpdStmt *Body () const { return (CT_CmpdStmt*)sons[5]; }
  CT_HandlerSeq *Handlers () const { return (CT_HandlerSeq*)sons[6]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void CtorInit (CTree *i) { sons[3] = i; }
  void Body (CTree *b) { sons[5] = b; }
  void FctTryBlock (CTree *t, CTree *c, CTree *b, CTree *h) { 
    sons[2] = t; sons[3] = c; sons[5] = b; sons[6] = h;
  }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 7, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AsmDef : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // asm, open, str, close, semi_colon

public:
  CT_AsmDef (CTree *a, CTree *o, CTree *s, CTree *c, CTree *sc) {
    sons[0] = a; sons[1] = o; sons[2] = s; sons[3] = c; sons[4] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_String *Instructions () const { return (CT_String*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Handler : public CT_Decl, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // catch, exception_decl, stmt

public:
  CT_Handler (CTree *c, CTree *e, CTree *s) {
    sons[0] = c; sons[1] = e; sons[2] = s;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_ArgDeclList *Arguments () const { return (CT_ArgDeclList*)sons[1]; }
  CT_Statement *Statement () const { return (CT_Statement*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_LinkageSpec : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // extern, str, open, decls, close

public:
  CT_LinkageSpec (CTree *e, CTree *s, CTree *o, CTree *d, CTree *c) {
    sons[0] = e; sons[1] = s; sons[2] = o; sons[3] = d; sons[4] = c;
    if (isList ())
      ((CT_DeclList*)Decls ())->Linkage (this);
    else
      ((CT_Decl*)Decls ())->Linkage (this);
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_String *Linkage () const { return (CT_String*)sons[1]; }
  CTree *Decls () const { return sons[3]; }
  bool isList () const {
    return Decls ()->NodeName () == CT_DeclList::NodeId ();
  }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgDecl : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // declspecs, declarator, init, ellipsis

public:
  CT_ArgDecl (CTree *dsl, CTree *d) {
    sons[0] = dsl; sons[1] = d; sons[2] = 0; sons[3] = 0; 
  }
  CT_ArgDecl (CTree *ellipsis) {
    sons[0] = 0; sons[1] = 0; sons[2] = 0; sons[3] = ellipsis; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[2]; }
  CT_Token *Ellipsis () const { return (CT_Token*)sons[3]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Initializer (CTree *i) { sons[2] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgDeclList : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ArgDeclList (int size = 2, int props = SEPARATORS | OPEN_CLOSE) : 
   CT_DeclList (size, 2) { AddProperties (props); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgDeclSeq : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ArgDeclSeq (int size = 2) : CT_DeclList (size, 2) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgNameList : public CT_ArgDeclList {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ArgNameList () : CT_ArgDeclList () {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NamespaceDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // ns, name, members

public:
  CT_NamespaceDef (CTree *n, CTree *nm) {
    sons[0] = n; sons[1] = nm; sons[2] = 0; 
  }
  CT_NamespaceDef (CTree *n, CTree *nm, CTree *m) {
    sons[0] = n; sons[1] = nm; sons[2] = m; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void Members (CTree *m) { sons[2] = m; }
  CT_MembList *Members () const { return (CT_MembList*)sons[2]; }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NamespaceAliasDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // ns, alias, assign, name, semi_colon

public:
  CT_NamespaceAliasDef (CTree *n, CTree *a, CTree *as, CTree *nm, CTree *s) {
    sons[0] = n; sons[1] = a; sons[2] = as; sons[3] = nm; sons[4] = s; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[3]; }
  CT_SimpleName *Alias () const { return (CT_SimpleName*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UsingDirective : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // using, ns, name, semi_colon

public:
  CT_UsingDirective (CTree *u, CTree *ns, CTree *n, CTree *s) {
    sons[0] = u; sons[1] = ns; sons[2] = n; sons[3] = s; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Declarators                                  */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Declarator : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_Declarator () {}

public:
  virtual CTree *Declarator () const = 0;
  //classification function
  virtual CT_Declarator *IsDeclarator () { return this; }
  // locate the name node
  CT_SimpleName *Name ();
  CT_SimpleName *Name (CT_Declarator *&last_declarator);
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_InitDeclarator : public CT_Declarator, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // declarator, init
  CTree *obj_decl;

public:
  CT_InitDeclarator (CTree *d, CTree *i = (CTree*)0) {
    sons[0] = d; sons[1] = i; obj_decl = 0; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Declarator () const { return sons[0]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  CT_ObjDecl *ObjDecl () const { return (CT_ObjDecl*)obj_decl; }
  void Initializer (CTree* i) { sons[1] = i; }
  void ObjDecl (CTree *od) { obj_decl = od; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BracedDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // open, win_specs, declarator, close

public:
  CT_BracedDeclarator (CTree *o, CTree *d, CTree *c) {
    sons[0] = o; sons[1] = 0; sons[2] = d; sons[3] = c; 
  }
  CT_BracedDeclarator (CTree *o, CTree *ws, CTree *d, CTree *c) {
    sons[0] = o; sons[1] = ws; sons[2] = d; sons[3] = c; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CTree *Declarator () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArrayDelimiter : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // star, static, quals, expr
  bool pos0;

public:
  CT_ArrayDelimiter (CTree *m, CTree *s, CTree *q, CTree *e, bool p = false) {
    sons[0] = m; sons[1] = s; sons[2] = q; sons[3] = e; pos0 = p;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_Token *Star () const { return (CT_Token*)sons[0]; }
  CT_Token *Static () const { return (CT_Token*)sons[pos0?2:1]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[pos0?1:2]; }
  CTree *Expr () const { return sons[3]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArrayDeclarator : public CT_Declarator, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // declarator, open, delim, close

public:
  CT_ArrayDeclarator (CTree *d, CTree *o, CTree *ad, CTree *c) {
    sons[0] = d; sons[1] = o; sons[2] = ad; sons[3] = c; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CTree *Declarator () const { return sons[0]; }
  CT_ArrayDelimiter *Delimiter () const 
   { return (CT_ArrayDelimiter*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_FctDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // declarator, args, cv_quals, exception_specs

public:
  CT_FctDeclarator (CTree *d, CTree *args, CTree *cv, CTree *es) {
    sons[0] = d; sons[1] = args; sons[2] = cv; sons[3] = es; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CTree *Declarator () const { return sons[0]; }
  CT_ArgDeclList *Arguments () const { return (CT_ArgDeclList*)sons[1]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[2]; }
  CT_ExceptionSpec *ExceptionSpecs () const { return (CT_ExceptionSpec*)sons[3]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_RefDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // ref, declarator

public:
  CT_RefDeclarator (CTree *r, CTree *d) { sons[0] = r; sons[1] = d; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Declarator () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) {
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PtrDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // ptr, cv_quals, declarator

public:
  CT_PtrDeclarator (CTree *p, CTree *c, CTree *d) {
    sons[0] = p; sons[1] = c; sons[2] = d; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Declarator () const { return sons[2]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembPtrDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // class, colon, ptr, cv_quals, declarator

public:
  CT_MembPtrDeclarator (CTree *c, CTree *cc, CTree *p, CTree *q, CTree *d) {
    sons[0] = c; sons[1] = cc; sons[2] = p; sons[3] = q; sons[4] = d; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[0]; }
  CTree *Declarator () const { return sons[4]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[3]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BitFieldDeclarator : public CT_Declarator, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declarator, colon, expr

public:
  CT_BitFieldDeclarator (CTree *d, CTree *c, CTree *e = 0) {
    sons[0] = d; sons[1] = c; sons[2] = e; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Declarator () const { return sons[0]; }
  CTree *Expr () const { return sons[2]; }
  void FieldSize (CTree *s) { sons[2] = s; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Statements                                   */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Statement : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;
 
protected:
  CT_Statement () {}
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_LabelStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // id, colon, stmt

public:
  CT_LabelStmt (CTree *id, CTree *c, CTree *stmt) {
    sons[0] = id; sons[1] = c; sons[2] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[2]; }
  CT_SimpleName *Label () const { return (CT_SimpleName*)sons[0]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DefaultStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // keyword, colon, stmt

public:
  CT_DefaultStmt (CTree *kw, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = c; sons[2] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TryStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // try, stmt, handlers

public:
  CT_TryStmt (CTree *t, CTree *s, CTree *h) {
    sons[0] = t; sons[1] = s; sons[2] = h; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[1]; }
  CT_HandlerSeq *Handlers () const { return (CT_HandlerSeq*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CaseStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // keyword, expr, colon, stmt

public:
  CT_CaseStmt (CTree *kw, CTree *expr, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = expr; sons[2] = c; sons[3] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[3]; }
  CTree *Expr () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExprStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // expr, semi_colon

public:
  CT_ExprStmt (CTree *expr, CTree *sc) { sons[0] = expr; sons[1] = sc; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Expr () const { return sons[0]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_decl;

public:
  CT_DeclStmt (CTree *decl) : _decl (decl) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return n == 0 ? _decl : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _decl) _decl = new_son; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SwitchStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // keyword, open, cond, close, stmt

public:
  CT_SwitchStmt (CTree *kw, CTree *o, CTree *cond, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[4]; }
  CTree *Condition () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IfStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // keyword, open, cond, close, stmt

public:
  CT_IfStmt (CTree *kw, CTree *o, CTree *cond, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[4]; }
  CTree *Condition () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IfElseStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[7]; // if, open, cond, close, if_stmt, else, else_stmt

public:
  CT_IfElseStmt (CTree *i, CTree *o, CTree *cond, CTree *c, 
                 CTree *is, CTree *e, CTree *es) {
    sons[0] = i; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = is; 
    sons[5] = e; sons[6] = es; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 7; }
  CTree *Son (int n) const { return CTree::Son (sons, 7, n); }
  CTree *Condition () const { return sons[2]; }
  CT_Statement *IfPart () const { return (CT_Statement*)sons[4]; }
  CT_Statement *ElsePart () const { return (CT_Statement*)sons[6]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 7, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BreakStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // key, semi_colon

public:
  CT_BreakStmt (CTree *key, CTree *sc) { sons[0] = key; sons[1] = sc; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ContinueStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // key, semi_colon

public:
  CT_ContinueStmt (CTree *key, CTree *sc) { sons[0] = key; sons[1] = sc; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_GotoStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // key, label, semi_colon

public:
  CT_GotoStmt (CTree *key, CTree *l, CTree *sc) {
    sons[0] = key; sons[1] = l; sons[2] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_SimpleName *Label () const { return (CT_SimpleName*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ReturnStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // key, expr, semi_colon

public:
  CT_ReturnStmt (CTree *key, CTree *e, CTree *sc) {
    sons[0] = key; sons[1] = e; sons[2] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Expr () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WhileStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // key, open, cond, close, stmt

public:
  CT_WhileStmt (CTree *kw, CTree *o, CTree *cond, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[4]; }
  CTree *Condition () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DoStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[7]; // do, stmt, while, open, expr, close, semi_colon

public:
  CT_DoStmt (CTree *d, CTree *stmt, CTree *w, CTree *o, CTree *e, 
             CTree *c, CTree *sc) {
    sons[0] = d; sons[1] = stmt; sons[2] = w; sons[3] = o; sons[4] = e; 
    sons[5] = c; sons[6] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 7; }
  CTree *Son (int n) const { return CTree::Son (sons, 7, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[1]; }
  CTree *Expr () const { return sons[4]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 7, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ForStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[8]; // key, open, init, cond, semi_colon, expr, close, stmt

public:
  CT_ForStmt (CTree *k, CTree *o, CTree *i, CTree *co, CTree *sc,
              CTree *e, CTree *c, CTree *stmt) {
    sons[0] = k; sons[1] = o; sons[2] = i; sons[3] = co; 
    sons[4] = sc; sons[5] = e; sons[6] = c; sons[7] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 8); }
  CTree *Son (int n) const { return CTree::Son (sons, 8, n); }
  CTree *InitStmt () const { return sons[2]; }
  CTree *Condition () const { return sons[3]; }
  CTree *Expr () const { return sons[5]; }
  CT_Statement *Statement () const { return (CT_Statement*)sons[7]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 8, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Condition : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declspecs, declarator, init

public:
  CT_Condition (CTree *dsl, CTree *d) {
    sons[0] = dsl; sons[1] = d; sons[2] = 0;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[2]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Initializer (CTree *i) { sons[2] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Classes                                      */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ClassDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

   
  struct __ac_wrapper_sons {
    typedef ::Puma::CTree * E; typedef E A[4]; A _data;
    operator A& () { return _data; }
    operator A& () const { return (A&)*(::Puma::CTree * *)_data; }
    operator const A& () { return _data; }
    operator const A& () const { return _data; }
    operator void* () { return _data; }
    operator void* () const { return (void*)_data; }
    operator const void* () { return _data; }
    operator const void* () const { return _data; }
    template <typename I> E& operator [] (I i) { return _data[i]; } // for VC++ 2003
    template <typename I> const E& operator [] (I i) const { return _data[i]; } // for VC++ 2003
  } sons; // key, name, bases, members
  CTree *obj_decl;

public:
  

struct TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0 {
  typedef void Result;
  typedef ::Puma::CT_ClassDef That;
  typedef ::Puma::CT_ClassDef Target;
  static const int JPID = 4;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 3 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };
  template <int DUMMY> struct Arg<0, DUMMY> {
    typedef ::Puma::CTree * Type;
    typedef ::Puma::CTree * ReferredType;
  };
  template <int DUMMY> struct Arg<1, DUMMY> {
    typedef ::Puma::CTree * Type;
    typedef ::Puma::CTree * ReferredType;
  };
  template <int DUMMY> struct Arg<2, DUMMY> {
    typedef ::Puma::CTree * Type;
    typedef ::Puma::CTree * ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};

CT_ClassDef (CTree * arg0, CTree * arg1, CTree * arg2 = (CTree*)0) {
  TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0 tjp;
  tjp._that =  (TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0::That*)this;
this->__exec_old_C1(arg0, arg1, arg2);
  AC::invoke_ExtACTree_ExtACTree_a0_after<TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0> (&tjp);

}
inline void __exec_old_C1(::Puma::CTree * k,::Puma::CTree * n,::Puma::CTree * b){
    sons[0] = k; sons[1] = n; sons[2] = b; sons[3] = 0; obj_decl = 0; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  CT_MembList *Members () const { return (CT_MembList*)sons[3]; }
  CT_BaseSpecList *BaseClasses () const { return (CT_BaseSpecList*)sons[2]; }
  CT_ObjDecl *ObjDecl () const { return (CT_ObjDecl*)obj_decl; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Members (CTree *m) { sons[3] = m; }
  void BaseClasses (CTree *bc) { sons[2] = bc; }
  void ObjDecl (CTree *od) { obj_decl = od; }
  void ReplaceSon (CTree *old_son, CTree *new_son) {
    // &(...) is used here to avoid strange warnings by mingw32-g++
    CTree::ReplaceSon (&(sons[0]), 4, old_son, new_son);
  }
   private:
 CTree * _intro_members ;
public :
CTree * IntroMembers ( ) const { return _intro_members ; }
void IntroMembers ( CTree * members ) { _intro_members = members ; }
struct TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0 {
  typedef void Result;
  typedef ::Puma::CT_ClassDef That;
  typedef ::Puma::CT_ClassDef Target;
  static const int JPID = 4;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 1 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };
  template <int DUMMY> struct Arg<0, DUMMY> {
    typedef const ::Puma::CT_ClassDef & Type;
    typedef const ::Puma::CT_ClassDef ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};


public:
inline CT_ClassDef (const Puma::CT_ClassDef & arg0) : Puma::CT_Decl (arg0), Puma::CSemObject (arg0), sons (arg0.sons), obj_decl (arg0.obj_decl), _intro_members (arg0._intro_members) {
  TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0 tjp;
  tjp._that =  (TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0::That*)this;
  AC::invoke_ExtACTree_ExtACTree_a0_after<TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0> (&tjp);

}

struct TJP__ZN4Puma11CT_ClassDefD1Ev_0 {
  typedef void Result;
  typedef ::Puma::CT_ClassDef That;
  typedef ::Puma::CT_ClassDef Target;
  static const int JPID = 4;
  static const AC::JPType JPTYPE = (AC::JPType)32;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 0 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};


public:
inline ~CT_ClassDef () {
  TJP__ZN4Puma11CT_ClassDefD1Ev_0 tjp;
  tjp._that =  (TJP__ZN4Puma11CT_ClassDefD1Ev_0::That*)this;
  AC::invoke_ExtACTree_ExtACTree_a1_before<TJP__ZN4Puma11CT_ClassDefD1Ev_0> (&tjp);

}
};
      
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UnionDef : public CT_ClassDef {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_UnionDef (CTree *k, CTree *n, CTree *b = 0) : CT_ClassDef (k, n, b) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
      
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembList : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembList (int size = 10, int incr = 10) : 
    CT_DeclList (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembInitList : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembInitList (int size = 2) : 
    CT_List (size, 2, CT_List::OPEN) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembInit : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // name, init

public:
  CT_MembInit (CTree *n, CTree *i) { sons[0] = n; sons[1] = i; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[0]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_MembInit CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembInit CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BaseSpecList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_BaseSpecList (int size = 2) : 
    CT_List (size, 2, CT_List::OPEN|CT_List::SEPARATORS) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AccessSpec : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // access, colon

public:
  CT_AccessSpec (CTree *a, CTree *c) { sons[0] = a; sons[1] = c; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  int Access () const { return sons[0]->token ()->type (); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BaseSpec : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // virtual, access, name

public:
  CT_BaseSpec (CTree *v, CTree *a, CTree *n) {
    sons[0] = v; sons[1] = a; sons[2] = n; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  int Access () const { return sons[1]->token ()->type (); }
  CTree *AccessSpec () const { return sons[1]; }
  CTree *Virtual () const { return sons[0]; }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AccessDecl : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // name, semi_colon

public:
  CT_AccessDecl (CTree *n, CTree *s) { sons[0] = n; sons[1] = s; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CT_QualName *Member () const { return (CT_QualName*)sons[0]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UsingDecl : public CT_AccessDecl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // using, typename

public:
  CT_UsingDecl (CTree *u, CTree *n, CTree *s) : CT_AccessDecl (n, s) {
    sons[0] = u; sons[1] = 0; 
  }
  CT_UsingDecl (CTree *u, CTree *t, CTree *n, CTree *s) : CT_AccessDecl (n, s) {
    sons[0] = u; sons[1] = t; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2) + CT_AccessDecl::Sons (); }
  CTree *Son (int n) const {
    int num = CTree::Sons (sons, 2);
    CTree *result = CTree::Son (sons, 2, n);
    return result ? result : CT_AccessDecl::Son (n-num);
  }
  CTree *Typename () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
    CT_AccessDecl::ReplaceSon (old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Wildcards                                    */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Any : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // keyword, extension

public:
  CT_Any (CTree *k, CTree *e = (CTree*)0) { sons[0] = k; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  int AnyType () const { return sons[0]->token ()->type (); }
  CT_AnyExtension *Extension () const { return (CT_AnyExtension*)sons[1]; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AnyList : public CT_Any {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_AnyList (CTree *k, CTree *e = (CTree*)0) : CT_Any (k, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AnyExtension : public CTree, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // open, string, comma, cond, close

public:
  CT_AnyExtension (CTree *o, CTree *n, CTree *co, CTree *c, CTree *cr) {
    sons[0] = o; sons[1] = n; sons[2] = co; sons[3] = c; sons[4] = cr; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Condition () const { return sons[3]; }
  CT_Token *String () const { return (CT_Token*)sons[1]; }
  const char *Name () const { 
    return value ? value->StrLiteral ()->String () : (const char*)0; }

  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AnyCondition : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // arg1, arg2, arg3

public:
  CT_AnyCondition (CTree *a1, CTree *a2 = (CTree*)0, CTree *a3 = (CTree*)0) {
    sons[0] = a1; sons[1] = a2; sons[2] = a3; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};


} // namespace Puma

#endif /* __CTree_h__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
namespace Puma {


class CStructure;
class CObjectInfo;
class CTypeInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CSemVisitor : private CVisitor {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CStructure *current_scope;
  ErrorSink &err;

public:
  CSemVisitor (ErrorSink &);

  void run (CTree *, CStructure * = (CStructure*)0);
  void configure (Config &) {}
  
protected:
  void pre_visit (CTree *);
  void post_visit (CTree *);

protected:
  void pre_action (CT_Program *);
  void pre_action (CT_ArgDeclList *);
  void pre_action (CT_ArgNameList *);
  void pre_action (CT_ArgDeclSeq *);
  void pre_action (CT_MembList *);
  void pre_action (CT_CmpdStmt *);
  void pre_action (CT_IfStmt *);
  void pre_action (CT_IfElseStmt *);
  void pre_action (CT_SwitchStmt *);
  void pre_action (CT_ForStmt *);
  void pre_action (CT_WhileStmt *);
  void pre_action (CT_DoStmt *);
  void pre_action (CT_ExprStmt *);
  void pre_action (CT_CaseStmt *);
  void pre_action (CT_GotoStmt *);
  void pre_action (CT_ReturnStmt *);
  void pre_action (CT_InitDeclarator *);
  void pre_action (CT_ArrayDeclarator *);
  void pre_action (CT_BitFieldDeclarator *);
  void pre_action (CT_EnumDef *);
  void pre_action (CT_ExprList *);
  void pre_action (CT_CmpdLiteral *);
  
protected:
  void post_action (CT_Program *);
  void post_action (CT_ArgDeclList *);
  void post_action (CT_ArgNameList *);
  void post_action (CT_ArgDeclSeq *);
  void post_action (CT_MembList *);
  void post_action (CT_CmpdStmt *);
  void post_action (CT_IfStmt *);
  void post_action (CT_IfElseStmt *);
  void post_action (CT_SwitchStmt *);
  void post_action (CT_ForStmt *);
  void post_action (CT_WhileStmt *);

  CT_SimpleName *findName (CTree *) const;

public:
  CTypeInfo *resolveExpr (CTree *, CTree *) const;
  void resolveInit (CObjectInfo *info, CTree *, CTree *) const;

};

} // namespace Puma

#endif /* __CSemVisitor_h__ */

#ifndef __ac_fwd_ExtGnu__
#define __ac_fwd_ExtGnu__
class ExtGnu;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a0_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a1_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a2_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a3_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a4_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a5_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a6_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a7_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a8_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a9_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a10_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a11_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a12_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a13_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a14_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a15_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#endif
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CSemDeclSpecs_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CSemDeclSpecs_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_sem_decl_specs_h__
#define __c_sem_decl_specs_h__


#ifndef __ac_fwd_ExtACTree__
#define __ac_fwd_ExtACTree__
class ExtACTree;
namespace AC {
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a1_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#endif
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTree_h__
#define __CTree_h__

namespace Puma {


// Syntax tree node hierarchy:
class CTree;
class   CT_Statement;          
class     CT_LabelStmt;
class     CT_IfStmt;
class     CT_IfElseStmt;
class     CT_SwitchStmt;
class     CT_BreakStmt;
class     CT_ExprStmt;
class     CT_WhileStmt;
class     CT_DoStmt;
class     CT_ForStmt;
class     CT_ContinueStmt;
class     CT_ReturnStmt;
class     CT_GotoStmt;
class     CT_DeclStmt;
class     CT_CaseStmt;
class     CT_DefaultStmt;
class     CT_TryStmt;
class   CT_Expression;
class     CT_ThrowExpr;
class     CT_NewExpr;
class     CT_DeleteExpr;
class     CT_ConstructExpr;
class     CT_Integer;
class     CT_Character;
class       CT_WideCharacter;
class     CT_Float;
class     CT_Bool;
class     CT_BracedExpr;
class     CT_BinaryExpr;
class       CT_MembPtrExpr;
class         CT_MembRefExpr;
class     CT_UnaryExpr;
class       CT_PostfixExpr;
class       CT_AddrExpr;
class       CT_DerefExpr;
class     CT_IfThenExpr;
class     CT_CmpdLiteral;
class     CT_IndexExpr;
class     CT_CallExpr;
class     CT_CastExpr;
class     CT_StaticCast;
class       CT_ConstCast;
class       CT_ReintCast;
class       CT_DynamicCast;
class     CT_TypeidExpr;
class     CT_SizeofExpr;
class     CT_MembDesignator;
class     CT_IndexDesignator;
class     CT_ImplicitCast;
class   CT_DeclSpec;
class     CT_PrimDeclSpec;
class     CT_NamedType;
class     CT_ClassSpec;
class       CT_UnionSpec;
class       CT_EnumSpec;
class     CT_ExceptionSpec;
class   CT_Declarator;
class     CT_InitDeclarator;
class     CT_BracedDeclarator;
class     CT_ArrayDeclarator;
class     CT_FctDeclarator;
class     CT_RefDeclarator;
class     CT_PtrDeclarator;
class     CT_MembPtrDeclarator;
class     CT_BitFieldDeclarator;
class   CT_Decl;
class     CT_ObjDecl;
class     CT_ArgDecl;
class     CT_AccessDecl;
class       CT_UsingDecl;
class     CT_FctDef;
class     CT_AsmDef;
class     CT_EnumDef;
class     CT_ClassDef;
class       CT_UnionDef;
class     CT_Enumerator;
class     CT_LinkageSpec;
class     CT_Handler;
class     CT_TemplateDecl;
class     CT_TemplateParamDecl;
class       CT_TypeParamDecl;
class       CT_NonTypeParamDecl;
class     CT_NamespaceDef;
class     CT_NamespaceAliasDef;
class     CT_UsingDirective;
class   CT_List;
class     CT_CmpdStmt;
class     CT_DeclSpecSeq;
class     CT_HandlerSeq;
class     CT_DesignatorSeq;
class     CT_DeclList;
class       CT_Program;
class       CT_ArgDeclList;
class         CT_ArgNameList;
class       CT_ArgDeclSeq;
class       CT_MembList;
class     CT_ExprList;
class     CT_DeclaratorList;
class     CT_BaseSpecList;
class     CT_MembInitList;
class     CT_SimpleName;
class       CT_SpecialName;
class         CT_PrivateName;
class         CT_OperatorName;
class         CT_DestructorName;
class         CT_ConversionName;
class         CT_TemplateName;
class       CT_QualName;
class         CT_RootQualName;
class     CT_String;
class       CT_WideString;
class     CT_TemplateParamList;
class     CT_TemplateArgList;
class   CT_Token;
class   CT_Error;
class   CT_Condition;
class   CT_BaseSpec;
class   CT_AccessSpec;
class   CT_ArrayDelimiter;
class   CT_Any;
class   CT_AnyList;
class   CT_AnyExtension;
class   CT_AnyCondition;


} // namespace Puma

#include "Puma/ErrorSeverity.h"
#include "Puma/CSemObject.h"
#include "Puma/CSemScope.h"
#include "Puma/CSemValue.h"
#include "Puma/CExprValue.h"
#include "Puma/CStrLiteral.h"
#include "Puma/CTypeInfo.h"
#include "Puma/Printable.h"
#include "Puma/CTokens.h"
#include "Puma/Token.h"

#include <iostream>
#include <string.h>
using namespace std;

namespace Puma {


class ErrorStream;
class CObjectInfo;
class CStructure;

/*****************************************************************************/
/*                                                                           */
/*                    S y n t a x  t r e e  n o d e s                        */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  /*DEBUG*/static int alloc;
  /*DEBUG*/static int release;

protected:
  CTree *Son (CTree * const *, int, int) const;
  int Sons (CTree * const *, int) const;
  void ReplaceSon (CTree * const *, int, CTree *, CTree *) const;
  
protected:
  CTree () { /*DEBUG*/alloc++; }

public:
  virtual ~CTree () { /*DEBUG*/release++; }
  virtual int Sons () const = 0;
  virtual CTree *Son (int n) const { return (CTree*)0; }
  virtual const char *NodeName () const = 0;
  virtual Token *token () const;
  virtual Token *end_token () const;
  virtual CT_Token *token_node () const;
  virtual CT_Token *end_token_node () const;
  virtual void ReplaceSon (CTree *, CTree *) {}

public: // semantic information
  virtual CTypeInfo *Type () const { return (CTypeInfo*)0; }
  virtual CExprValue *Value () const { return (CExprValue*)0; }
  
  virtual CSemValue *SemValue () const { return (CSemValue*)0; }
  virtual CSemObject *SemObject () const { return (CSemObject*)0; }
  
public: // node classification function
  virtual CT_SimpleName *IsSimpleName () { return 0; }
  virtual CT_Declarator *IsDeclarator () { return 0; }
   private:
  typedef CTree CCExprResolveCTree;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CTree CExprResolveCTree;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Error : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Token : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Token *_token;
  unsigned long int _number;
  
public:
  CT_Token (Token *t, unsigned long int n = 0) : 
    _token (t), _number (n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
  Token *token () const { return _token; }
  Token *end_token () const { return _token; }
  CT_Token *token_node () const { return (CT_Token*)this; }
  CT_Token *end_token_node () const { return (CT_Token*)this; }
  void Number (unsigned long int n) { _number = n; }
  unsigned long int Number () const { return _number; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
};

/*****************************************************************************/
/*                                                                           */
/*                              List nodes                                   */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_List : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Array<CTree*> _sons;
  int _properties;

protected:
  CT_List(int size = 5, int incr = 5, int props = 0) : 
    _sons (size, incr), _properties (props) {}

public:
  enum {
    OPEN = 1,         // has a start token like ':' in ":a(1),b(2)"
    CLOSE = 2,
    OPEN_CLOSE = 3,   // has opening and closing delimiters, e.g. '(' ')'
    SEPARATORS = 4,   // the list has separators like ','
    FORCE_EMPTY = 8,  // pretend to be empty, e.g. for "(void)"
    END_SEP = 16,     // has separator after last element, e.g. "a,b,c,"
    NO_LAST_SEP = 32, // no separator before last element, e.g. "(a,b...)"
    INTRO = 64        // has an introduction char, e.g. "=" in "={a,b}"
  };
 
  int Entries () const;
  CTree *Entry (int no) const;
  int Sons () const { return _sons.length (); }
  CTree *Son (int n) const { return _sons.lookup (n); }
  int GetProperties () const { return _properties; }
  void AddProperties (int p) { _properties |= p; }
  void AddSon (CTree *s) { if (s) _sons.append (s); }
  void PrefixSon (CTree *s) { if (s) _sons.prepend (s); }
  void InsertSon (CTree *, CTree *);  // before given son
  void ReplaceSon (CTree *, CTree *);
  void RemoveSon (CTree *);
  void InsertSon (int idx, CTree *s)
   { if (idx <= Sons ()) _sons.insert (idx, s); }
  void ReplaceSon (int idx, CTree *s) 
   { if (idx < Sons ()) _sons[idx] = s; }
  void RemoveSon (int idx) 
   { if (idx < Sons ()) _sons.remove (idx); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExprList : public CT_List, public CSemValue, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ExprList () { AddProperties (SEPARATORS); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclaratorList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumeratorList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_EnumeratorList () { AddProperties (SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
   
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DeclList (int size = 20, int incr = 20) : CT_List (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void Linkage (CT_LinkageSpec *l);
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclSpecSeq : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CmpdStmt : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_CmpdStmt () { AddProperties (OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_HandlerSeq : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateParamList : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateParamList () { AddProperties (INTRO | SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateArgList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateArgList () { AddProperties (SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

/*****************************************************************************/
/*                                                                           */
/*                              Expressions                                  */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Expression : public CTree, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_Expression () {}

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
   private:
  typedef CT_Expression CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Expression CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_String : public CT_List, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_String (int size) : CT_List (size, 1) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
   private:
  typedef CT_String CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_String CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WideString : public CT_String {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_WideString (int size) : CT_String (size) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_WideString CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_WideString CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Integer : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Integer (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return _value ? 1 : 0; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Integer CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Integer CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Character : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Character (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Character CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Character CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WideCharacter : public CT_Character {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_WideCharacter (CTree *t) : CT_Character (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_WideCharacter CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_WideCharacter CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Float : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Float (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Float CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Float CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Bool : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Bool (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Bool CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Bool CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BracedExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // open, expr, close

public:
  CT_BracedExpr (CTree *o, CTree *e, CTree *c) { 
    sons[0] = o; sons[1] = e; sons[2] = c; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Expr () const { return sons[1]; }
  CTypeInfo *Type () const { return Expr ()->Type (); }
  CExprValue *Value () const { return Expr ()->Value (); }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
   private:
  typedef CT_BracedExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_BracedExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SimpleName : public CT_List, public Printable, 
                      public CSemValue, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_SimpleName (int size) : CT_List (size, 1) {}
  CT_SimpleName (int size, int properties) : 
    CT_List (size, 2, properties) {}
  
public:
  CT_SimpleName (CTree *n) : CT_List (1, 1) { AddSon (n); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  virtual const char *Text () const 
   { return Son (Sons ()-1)->token ()->text (); }
  virtual void print (ostream &os) const { os << Text (); }
  virtual CT_SimpleName *Name () const { return (CT_SimpleName*)this; }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
  // classification function
  virtual CT_SimpleName *IsSimpleName () { return this; }  
   private:
  typedef CT_SimpleName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_SimpleName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SpecialName : public CT_SimpleName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  char *_name;
  
protected:
  CT_SpecialName (int size = 1) : CT_SimpleName (size), _name (0) {}
  
public:
  ~CT_SpecialName () { if (_name) delete[] _name; }
  const char *Text () const { return _name; }
  void Name (const char *n) { 
    if (n) { 
      _name = new char[strlen(n) + 1];
      strcpy (_name,n);
    }
  }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_SpecialName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_SpecialName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PrivateName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_PrivateName (const char *n) { Name (n); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
  CTree *Son (int n) const { return (CTree*)0; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_PrivateName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_PrivateName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DestructorName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DestructorName (CTree *, CTree *);
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_DestructorName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DestructorName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateName (CTree *n, CTree *a) 
   { AddSon (n); AddSon (a); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CT_TemplateArgList *Arguments () const 
   { return (CT_TemplateArgList*)Son (Sons ()-1); }
  CT_SimpleName *TemplateName () const 
   { return (CT_SimpleName*)Son (Sons ()-2); }
  // may change in the future
  const char *Text () const { return TemplateName ()->Text (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_TemplateName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_TemplateName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_OperatorName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _oper;

public:
  enum { // complex operators
    FCT_CALL = -100,
    SUBSCRIPT,
    NEW_ARRAY,
    DEL_ARRAY
  };
 
public:
  CT_OperatorName (CTree *);
  CT_OperatorName (CTree *, CTree *, CTree *, CTree *);
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Operator () const { return _oper; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_OperatorName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_OperatorName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ConversionName : public CT_SpecialName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ConversionName (CTree *, CTree *);
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CT_NamedType *TypeName () const { return (CT_NamedType*)Son (Sons ()-1); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_ConversionName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ConversionName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_QualName : public CT_SimpleName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_QualName (int size = 3) : 
    CT_SimpleName (size, CT_List::SEPARATORS) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void print (ostream &) const;
  CT_SimpleName *Name () const { return (CT_SimpleName*)Son (Sons ()-1); }
  const char *Text () const { return Name ()->Text (); }
  CTypeInfo *Type () const { return Name ()->Type (); }
  CExprValue *Value () const { return Name ()->Value (); }
  CSemValue *SemValue () const { return Name ()->SemValue (); }
  CSemObject *SemObject () const { return Name ()->SemObject (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_QualName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_QualName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_RootQualName : public CT_QualName {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_RootQualName (int size = 2) : 
    CT_QualName (size) { AddProperties (INTRO); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
   private:
  typedef CT_RootQualName CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_RootQualName CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BinaryExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // expr, oper, expr

public:
  CT_BinaryExpr (CTree *l, CTree *o, CTree *r) {
    sons[0] = l; sons[1] = o; sons[2] = r;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
   private:
  typedef CT_BinaryExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_BinaryExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembPtrExpr : public CT_BinaryExpr, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembPtrExpr (CTree *e, CTree *o, CTree *i) :
    CT_BinaryExpr (e, o, i) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_MembPtrExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembPtrExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembRefExpr : public CT_MembPtrExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembRefExpr (CTree *e, CTree *o, CTree *i) :
    CT_MembPtrExpr (e, o, i) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_MembRefExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembRefExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UnaryExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // oper, expr

public:
  CT_UnaryExpr (CTree *o, CTree *e) { sons[0] = o; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[1]; }
   private:
  typedef CT_UnaryExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_UnaryExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PostfixExpr : public CT_UnaryExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_PostfixExpr (CTree *e, CTree *o) :
    CT_UnaryExpr (e, o) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_PostfixExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_PostfixExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AddrExpr : public CT_UnaryExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_AddrExpr (CTree *o, CTree *e) :
    CT_UnaryExpr (o, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_AddrExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_AddrExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DerefExpr : public CT_UnaryExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DerefExpr (CTree *o, CTree *e) :
    CT_UnaryExpr (o, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_DerefExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DerefExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeleteExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // oper, expr

public:
  CT_DeleteExpr (CTree *op, CTree *e) { sons[0] = op; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[1]; }
  CT_SimpleName *OperName () const { return (CT_SimpleName*)sons[0]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_DeleteExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DeleteExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NewExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[6]; // oper, placement, open, type, close, init

public:
  CT_NewExpr (CTree *op, CTree *p, CTree *o, CTree *t, CTree *c, CTree *i) {
    sons[0] = op; sons[1] = p; sons[2] = o; sons[3] = t; sons[4] = c; sons[5] = i; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 6); }
  CTree *Son (int n) const { return CTree::Son (sons, 6, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 6, old_son, new_son);
  }
  CT_SimpleName *OperName () const { return (CT_SimpleName*)sons[0]; }
  CT_ExprList *Placement () const { return (CT_ExprList*)sons[1];; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[5]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[3]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_NewExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_NewExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IfThenExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // cond, oper, left, colon, right

public:
  CT_IfThenExpr (CTree *c1, CTree *o, CTree *l, CTree *c2, CTree *r) {
    sons[0] = c1; sons[1] = o; sons[2] = l; sons[3] = c2; sons[4] = r;
  }
  CT_IfThenExpr (CTree *c1, CTree *o, CTree *c2, CTree *r) {
    sons[0] = c1; sons[1] = o; sons[2] = 0; sons[3] = c2; sons[4] = r;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CTree *Condition () const { return sons[0]; }
  CTree *LeftOperand () const { return sons[2]; }
  CTree *RightOperand () const { return sons[4]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
   private:
  typedef CT_IfThenExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_IfThenExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CmpdLiteral : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // open, type, close, init

public:
  CT_CmpdLiteral (CTree *r, CTree *t, CTree *cr, CTree *i) {
    sons[0] = r; sons[1] = t; sons[2] = cr; sons[3] = i;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[1]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[3]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_CmpdLiteral CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_CmpdLiteral CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ConstructExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // type, init

public:
  CT_ConstructExpr (CTree *t, CTree *i) { sons[0] = t; sons[1] = i; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[0]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_ConstructExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ConstructExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ThrowExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // throw, expr

public:
  CT_ThrowExpr (CTree *t, CTree *e = (CTree*)0) { sons[0] = t; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[1]; }
   private:
  typedef CT_ThrowExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ThrowExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IndexExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // expr, open, index, close

public:
  CT_IndexExpr (CTree *e, CTree *o, CTree *i, CTree *c) {
    sons[0] = e; sons[1] = o; sons[2] = i; sons[3] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
   private:
  typedef CT_IndexExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_IndexExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CallExpr : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // expr, args

public:
  CT_CallExpr (CTree *e) { sons[0] = e; sons[1] = 0; }
  CT_CallExpr (CTree *e, CTree *l) { sons[0] = e; sons[1] = l; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); } 
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CTree *Expr () const { return sons[0]; }
  CT_ExprList *Arguments () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_CallExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_CallExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CastExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // open, type, close, expr

public:
  CT_CastExpr (CTree *o, CTree *t, CTree *c, CTree *e) {
    sons[0] = o; sons[1] = t; sons[2] = c; sons[3] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CTree *Expr () const { return sons[3]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[1]; }
   private:
  typedef CT_CastExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_CastExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_StaticCast : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // cast, open, type, close, expr

public:
  CT_StaticCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) {
    sons[0] = cst; sons[1] = o; sons[2] = t; sons[3] = c; sons[4] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Expr () const { return sons[4]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[2]; }
   private:
  typedef CT_StaticCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_StaticCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ConstCast : public CT_StaticCast {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ConstCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) :
    CT_StaticCast (cst, o, t, c, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_ConstCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ConstCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ReintCast : public CT_StaticCast {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ReintCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) :
    CT_StaticCast (cst, o, t, c, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_ReintCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ReintCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DynamicCast : public CT_StaticCast {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DynamicCast (CTree *cst, CTree *o, CTree *t, CTree *c, CTree *e) :
    CT_StaticCast (cst, o, t, c, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_DynamicCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_DynamicCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ImplicitCast : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_expr; // casted expression

public:
  CT_ImplicitCast (CTree *e) : _expr (e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return n == 0 ? _expr : (CTree*)0; }
  CTree *Expr () const { return _expr; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _expr) _expr = new_son; }
   private:
  typedef CT_ImplicitCast CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_ImplicitCast CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TypeidExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // typeid, open, type_id/expr, close

public:
  CT_TypeidExpr (CTree *tid, CTree *o, CTree *e, CTree *c) {
    sons[0] = tid; sons[1] = o; sons[2] = e; sons[3] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CTree *Arg () const { return sons[2]; }
   private:
  typedef CT_TypeidExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_TypeidExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SizeofExpr : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // key, open, type, close, expr

public:
  CT_SizeofExpr (CTree *k, CTree *o, CTree *t, CTree *c) {
    sons[0] = k; sons[1] = o; sons[2] = t; sons[3] = c; sons[4] = 0;
  }
  CT_SizeofExpr (CTree *k, CTree *e) {
    sons[0] = k; sons[1] = 0; sons[2] = 0; sons[3] = 0; sons[4] = e;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Expr () const { return sons[4]; }
  CT_NamedType *TypeName () const { return (CT_NamedType*)sons[2]; }
   private:
  typedef CT_SizeofExpr CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_SizeofExpr CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IndexDesignator : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // open, index, close

public:
  CT_IndexDesignator (CTree *o, CTree *i, CTree *c) {
    sons[0] = o; sons[1] = i; sons[2] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
   private:
  typedef CT_IndexDesignator CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_IndexDesignator CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembDesignator : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // dot, member

public:
  CT_MembDesignator (CTree *d, CTree *m) { sons[0] = d; sons[1] = m; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
   private:
  typedef CT_MembDesignator CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembDesignator CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DesignatorSeq : public CT_List, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DesignatorSeq (int size = 1) : CT_List (size, 2) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
};

/*****************************************************************************/
/*                                                                           */
/*                         Declaration specifiers                            */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclSpec : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_DeclSpec () {}
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PrimDeclSpec : public CT_DeclSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  enum Type { PDS_FRIEND, PDS_TYPEDEF, PDS_AUTO, PDS_REGISTER, PDS_STATIC, 
              PDS_EXTERN, PDS_MUTABLE, PDS_INLINE, PDS_VIRTUAL, PDS_EXPLICIT, 
              PDS_CONST, PDS_VOLATILE, PDS_RESTRICT, PDS_CHAR, PDS_WCHAR_T, 
              PDS_BOOL, PDS_SHORT, PDS_INT, PDS_LONG, PDS_SIGNED, PDS_UNSIGNED, 
              PDS_FLOAT, PDS_DOUBLE, PDS_VOID, 
              // AspectC++ specific type specifier
              PDS_UNKNOWN_T,
              // Win specific declaration specifiers
              PDS_CDECL, PDS_STDCALL, PDS_FASTCALL, PDS_INT64,
              PDS_UNKNOWN, PDS_NUM };

private:
  Type _type;
  CT_Token *_token;

  void determine_type ();

public:
  CT_PrimDeclSpec (CT_Token *t) : _token (t) { determine_type (); }
  CT_PrimDeclSpec (Type t) : _token (0) { _type = t; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return _token ? 1 : 0; }
  CTree *Son (int n) const 
   { return (n == 0) ? _token : (CTree*)0; }
  const char *SpecText () const 
   { return _token ? _token->token ()->text ().c_str () : " "; }
  Type SpecType () const { return _type; }
  static const int NumTypes = PDS_NUM;
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NamedType : public CT_DeclSpec, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // declspecs, declarator

public:
  CT_NamedType (CTree *dss, CTree *d) { sons[0] = dss; sons[1] = d; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Declarator () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};
      
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ClassSpec : public CT_DeclSpec, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // key, name
  
public:
  CT_ClassSpec (CTree *k, CTree *n) { sons[0] = k; sons[1] = n; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); } 
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UnionSpec : public CT_ClassSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_UnionSpec (CTree *k, CTree *n) : CT_ClassSpec (k, n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumSpec : public CT_ClassSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_EnumSpec (CTree *k, CTree *n) : CT_ClassSpec (k, n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExceptionSpec : public CT_DeclSpec {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // throw, type_id_list
  
public:
  CT_ExceptionSpec (CTree *k, CTree *l) { sons[0] = k; sons[1] = l; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CT_ArgDeclList *Arguments () const { return (CT_ArgDeclList*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Declarations                                 */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Decl : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;
 
  CT_LinkageSpec *_linkage;
protected:
  CT_Decl () : _linkage (0) {}
public:
  void Linkage (CT_LinkageSpec *l) { _linkage = l; }
  CT_LinkageSpec *Linkage () const { return _linkage; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Program : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_Program (int size = 20, int incr = 20) : CT_DeclList (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
   
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ObjDecl : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declspecs, declarators, colon

public:
  CT_ObjDecl (CTree *dsl, CTree *dl, CTree *c) {
    sons[0] = dsl; sons[1] = dl; sons[2] = c;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CT_DeclaratorList *Declarators () const { return (CT_DeclaratorList*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateDecl : public CT_Decl, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // export, param_list, decl

public:
  CT_TemplateDecl (CTree *e, CTree *p, CTree *d) {
    sons[0] = e; sons[1] = p; sons[2] = d;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son); 
  }
  CTree *Export () const { return sons[0]; }
  CT_TemplateParamList *Parameters () const { 
    return (CT_TemplateParamList*)sons[1]; 
  }
  CTree *Declaration () const { return sons[2]; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateParamDecl : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_TemplateParamDecl () {}
  
public:
  virtual CT_ExprList *DefaultArgument () const = 0;
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NonTypeParamDecl : public CT_TemplateParamDecl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declspecs, declarator, init

public:
  CT_NonTypeParamDecl (CTree *dsl, CTree *d, CTree *i = (CTree*)0) {
    sons[0] = dsl; sons[1] = d; sons[2] = i;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_ExprList *DefaultArgument () const { return (CT_ExprList*)sons[2]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Initializer (CTree *i) { sons[2] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TypeParamDecl : public CT_TemplateParamDecl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // params, key, id, init

public:
  CT_TypeParamDecl (CTree *t, CTree *k, CTree *id, CTree *i = (CTree*)0) { 
    sons[0] = t; sons[1] = k; sons[2] = id; sons[3] = i;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_TemplateParamList *Parameters () const { 
    return (CT_TemplateParamList*)sons[0]; 
  }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[2]; }
  CT_ExprList *DefaultArgument () const { return (CT_ExprList*)sons[3]; }
  void Initializer (CTree *i) { sons[3] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // key, name, enumerators

public:
  CT_EnumDef (CTree *k, CTree *n) {
    sons[0] = k; sons[1] = n; sons[2] = 0; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  void Enumerators (CTree *el) { sons[2] = el; }
  CT_EnumeratorList *Enumerators () const { return (CT_EnumeratorList*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Enumerator : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // name, init

public:
  CT_Enumerator (CTree *n) { sons[0] = n; sons[1] = 0; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[0]; }
  void Initializer (CTree *i) { sons[1] = i; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son); 
  }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_FctDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[7]; // declspecs, declarator, try, ctor_init, args, body, handlers

public:
  CT_FctDef (CTree *dss, CTree *d, CTree *t, CTree *ci, CTree *as, 
             CTree *b, CTree *hs) {
    sons[0] = dss; sons[1] = d; sons[2] = t; sons[3] = ci; sons[4] = as; 
    sons[5] = b; sons[6] = hs; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 7); }
  CTree *Son (int n) const { return CTree::Son (sons, 7, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_Token *TryKey () const { return (CT_Token*)sons[2]; }
  CTree *CtorInit () const { return sons[3]; }
  CT_ArgDeclSeq *ArgDeclSeq () const { return (CT_ArgDeclSeq*)sons[4]; }
  CT_CmpdStmt *Body () const { return (CT_CmpdStmt*)sons[5]; }
  CT_HandlerSeq *Handlers () const { return (CT_HandlerSeq*)sons[6]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void CtorInit (CTree *i) { sons[3] = i; }
  void Body (CTree *b) { sons[5] = b; }
  void FctTryBlock (CTree *t, CTree *c, CTree *b, CTree *h) { 
    sons[2] = t; sons[3] = c; sons[5] = b; sons[6] = h;
  }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 7, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AsmDef : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // asm, open, str, close, semi_colon

public:
  CT_AsmDef (CTree *a, CTree *o, CTree *s, CTree *c, CTree *sc) {
    sons[0] = a; sons[1] = o; sons[2] = s; sons[3] = c; sons[4] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_String *Instructions () const { return (CT_String*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Handler : public CT_Decl, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // catch, exception_decl, stmt

public:
  CT_Handler (CTree *c, CTree *e, CTree *s) {
    sons[0] = c; sons[1] = e; sons[2] = s;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_ArgDeclList *Arguments () const { return (CT_ArgDeclList*)sons[1]; }
  CT_Statement *Statement () const { return (CT_Statement*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_LinkageSpec : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // extern, str, open, decls, close

public:
  CT_LinkageSpec (CTree *e, CTree *s, CTree *o, CTree *d, CTree *c) {
    sons[0] = e; sons[1] = s; sons[2] = o; sons[3] = d; sons[4] = c;
    if (isList ())
      ((CT_DeclList*)Decls ())->Linkage (this);
    else
      ((CT_Decl*)Decls ())->Linkage (this);
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_String *Linkage () const { return (CT_String*)sons[1]; }
  CTree *Decls () const { return sons[3]; }
  bool isList () const {
    return Decls ()->NodeName () == CT_DeclList::NodeId ();
  }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgDecl : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // declspecs, declarator, init, ellipsis

public:
  CT_ArgDecl (CTree *dsl, CTree *d) {
    sons[0] = dsl; sons[1] = d; sons[2] = 0; sons[3] = 0; 
  }
  CT_ArgDecl (CTree *ellipsis) {
    sons[0] = 0; sons[1] = 0; sons[2] = 0; sons[3] = ellipsis; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[2]; }
  CT_Token *Ellipsis () const { return (CT_Token*)sons[3]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Initializer (CTree *i) { sons[2] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgDeclList : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ArgDeclList (int size = 2, int props = SEPARATORS | OPEN_CLOSE) : 
   CT_DeclList (size, 2) { AddProperties (props); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgDeclSeq : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ArgDeclSeq (int size = 2) : CT_DeclList (size, 2) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArgNameList : public CT_ArgDeclList {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ArgNameList () : CT_ArgDeclList () {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NamespaceDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // ns, name, members

public:
  CT_NamespaceDef (CTree *n, CTree *nm) {
    sons[0] = n; sons[1] = nm; sons[2] = 0; 
  }
  CT_NamespaceDef (CTree *n, CTree *nm, CTree *m) {
    sons[0] = n; sons[1] = nm; sons[2] = m; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void Members (CTree *m) { sons[2] = m; }
  CT_MembList *Members () const { return (CT_MembList*)sons[2]; }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_NamespaceAliasDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // ns, alias, assign, name, semi_colon

public:
  CT_NamespaceAliasDef (CTree *n, CTree *a, CTree *as, CTree *nm, CTree *s) {
    sons[0] = n; sons[1] = a; sons[2] = as; sons[3] = nm; sons[4] = s; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[3]; }
  CT_SimpleName *Alias () const { return (CT_SimpleName*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UsingDirective : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // using, ns, name, semi_colon

public:
  CT_UsingDirective (CTree *u, CTree *ns, CTree *n, CTree *s) {
    sons[0] = u; sons[1] = ns; sons[2] = n; sons[3] = s; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Declarators                                  */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Declarator : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_Declarator () {}

public:
  virtual CTree *Declarator () const = 0;
  //classification function
  virtual CT_Declarator *IsDeclarator () { return this; }
  // locate the name node
  CT_SimpleName *Name ();
  CT_SimpleName *Name (CT_Declarator *&last_declarator);
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_InitDeclarator : public CT_Declarator, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // declarator, init
  CTree *obj_decl;

public:
  CT_InitDeclarator (CTree *d, CTree *i = (CTree*)0) {
    sons[0] = d; sons[1] = i; obj_decl = 0; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Declarator () const { return sons[0]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  CT_ObjDecl *ObjDecl () const { return (CT_ObjDecl*)obj_decl; }
  void Initializer (CTree* i) { sons[1] = i; }
  void ObjDecl (CTree *od) { obj_decl = od; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BracedDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // open, win_specs, declarator, close

public:
  CT_BracedDeclarator (CTree *o, CTree *d, CTree *c) {
    sons[0] = o; sons[1] = 0; sons[2] = d; sons[3] = c; 
  }
  CT_BracedDeclarator (CTree *o, CTree *ws, CTree *d, CTree *c) {
    sons[0] = o; sons[1] = ws; sons[2] = d; sons[3] = c; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CTree *Declarator () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArrayDelimiter : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // star, static, quals, expr
  bool pos0;

public:
  CT_ArrayDelimiter (CTree *m, CTree *s, CTree *q, CTree *e, bool p = false) {
    sons[0] = m; sons[1] = s; sons[2] = q; sons[3] = e; pos0 = p;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_Token *Star () const { return (CT_Token*)sons[0]; }
  CT_Token *Static () const { return (CT_Token*)sons[pos0?2:1]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[pos0?1:2]; }
  CTree *Expr () const { return sons[3]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ArrayDeclarator : public CT_Declarator, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // declarator, open, delim, close

public:
  CT_ArrayDeclarator (CTree *d, CTree *o, CTree *ad, CTree *c) {
    sons[0] = d; sons[1] = o; sons[2] = ad; sons[3] = c; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CTree *Declarator () const { return sons[0]; }
  CT_ArrayDelimiter *Delimiter () const 
   { return (CT_ArrayDelimiter*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_FctDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // declarator, args, cv_quals, exception_specs

public:
  CT_FctDeclarator (CTree *d, CTree *args, CTree *cv, CTree *es) {
    sons[0] = d; sons[1] = args; sons[2] = cv; sons[3] = es; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CTree *Declarator () const { return sons[0]; }
  CT_ArgDeclList *Arguments () const { return (CT_ArgDeclList*)sons[1]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[2]; }
  CT_ExceptionSpec *ExceptionSpecs () const { return (CT_ExceptionSpec*)sons[3]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_RefDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // ref, declarator

public:
  CT_RefDeclarator (CTree *r, CTree *d) { sons[0] = r; sons[1] = d; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Declarator () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) {
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_PtrDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // ptr, cv_quals, declarator

public:
  CT_PtrDeclarator (CTree *p, CTree *c, CTree *d) {
    sons[0] = p; sons[1] = c; sons[2] = d; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Declarator () const { return sons[2]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembPtrDeclarator : public CT_Declarator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // class, colon, ptr, cv_quals, declarator

public:
  CT_MembPtrDeclarator (CTree *c, CTree *cc, CTree *p, CTree *q, CTree *d) {
    sons[0] = c; sons[1] = cc; sons[2] = p; sons[3] = q; sons[4] = d; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[0]; }
  CTree *Declarator () const { return sons[4]; }
  CT_DeclSpecSeq *Qualifier () const { return (CT_DeclSpecSeq*)sons[3]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BitFieldDeclarator : public CT_Declarator, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declarator, colon, expr

public:
  CT_BitFieldDeclarator (CTree *d, CTree *c, CTree *e = 0) {
    sons[0] = d; sons[1] = c; sons[2] = e; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Declarator () const { return sons[0]; }
  CTree *Expr () const { return sons[2]; }
  void FieldSize (CTree *s) { sons[2] = s; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Statements                                   */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Statement : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;
 
protected:
  CT_Statement () {}
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_LabelStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // id, colon, stmt

public:
  CT_LabelStmt (CTree *id, CTree *c, CTree *stmt) {
    sons[0] = id; sons[1] = c; sons[2] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[2]; }
  CT_SimpleName *Label () const { return (CT_SimpleName*)sons[0]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DefaultStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // keyword, colon, stmt

public:
  CT_DefaultStmt (CTree *kw, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = c; sons[2] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TryStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // try, stmt, handlers

public:
  CT_TryStmt (CTree *t, CTree *s, CTree *h) {
    sons[0] = t; sons[1] = s; sons[2] = h; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[1]; }
  CT_HandlerSeq *Handlers () const { return (CT_HandlerSeq*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CaseStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[4]; // keyword, expr, colon, stmt

public:
  CT_CaseStmt (CTree *kw, CTree *expr, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = expr; sons[2] = c; sons[3] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[3]; }
  CTree *Expr () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 4, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExprStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // expr, semi_colon

public:
  CT_ExprStmt (CTree *expr, CTree *sc) { sons[0] = expr; sons[1] = sc; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CTree *Expr () const { return sons[0]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_decl;

public:
  CT_DeclStmt (CTree *decl) : _decl (decl) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 1; }
  CTree *Son (int n) const { return n == 0 ? _decl : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _decl) _decl = new_son; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_SwitchStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // keyword, open, cond, close, stmt

public:
  CT_SwitchStmt (CTree *kw, CTree *o, CTree *cond, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[4]; }
  CTree *Condition () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IfStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // keyword, open, cond, close, stmt

public:
  CT_IfStmt (CTree *kw, CTree *o, CTree *cond, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[4]; }
  CTree *Condition () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_IfElseStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[7]; // if, open, cond, close, if_stmt, else, else_stmt

public:
  CT_IfElseStmt (CTree *i, CTree *o, CTree *cond, CTree *c, 
                 CTree *is, CTree *e, CTree *es) {
    sons[0] = i; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = is; 
    sons[5] = e; sons[6] = es; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 7; }
  CTree *Son (int n) const { return CTree::Son (sons, 7, n); }
  CTree *Condition () const { return sons[2]; }
  CT_Statement *IfPart () const { return (CT_Statement*)sons[4]; }
  CT_Statement *ElsePart () const { return (CT_Statement*)sons[6]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 7, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BreakStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // key, semi_colon

public:
  CT_BreakStmt (CTree *key, CTree *sc) { sons[0] = key; sons[1] = sc; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ContinueStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // key, semi_colon

public:
  CT_ContinueStmt (CTree *key, CTree *sc) { sons[0] = key; sons[1] = sc; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_GotoStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // key, label, semi_colon

public:
  CT_GotoStmt (CTree *key, CTree *l, CTree *sc) {
    sons[0] = key; sons[1] = l; sons[2] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_SimpleName *Label () const { return (CT_SimpleName*)sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ReturnStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // key, expr, semi_colon

public:
  CT_ReturnStmt (CTree *key, CTree *e, CTree *sc) {
    sons[0] = key; sons[1] = e; sons[2] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CTree *Expr () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WhileStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // key, open, cond, close, stmt

public:
  CT_WhileStmt (CTree *kw, CTree *o, CTree *cond, CTree *c, CTree *stmt) {
    sons[0] = kw; sons[1] = o; sons[2] = cond; sons[3] = c; sons[4] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 5; }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[4]; }
  CTree *Condition () const { return sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DoStmt : public CT_Statement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[7]; // do, stmt, while, open, expr, close, semi_colon

public:
  CT_DoStmt (CTree *d, CTree *stmt, CTree *w, CTree *o, CTree *e, 
             CTree *c, CTree *sc) {
    sons[0] = d; sons[1] = stmt; sons[2] = w; sons[3] = o; sons[4] = e; 
    sons[5] = c; sons[6] = sc; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 7; }
  CTree *Son (int n) const { return CTree::Son (sons, 7, n); }
  CT_Statement *Statement () const { return (CT_Statement*)sons[1]; }
  CTree *Expr () const { return sons[4]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 7, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ForStmt : public CT_Statement, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[8]; // key, open, init, cond, semi_colon, expr, close, stmt

public:
  CT_ForStmt (CTree *k, CTree *o, CTree *i, CTree *co, CTree *sc,
              CTree *e, CTree *c, CTree *stmt) {
    sons[0] = k; sons[1] = o; sons[2] = i; sons[3] = co; 
    sons[4] = sc; sons[5] = e; sons[6] = c; sons[7] = stmt; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 8); }
  CTree *Son (int n) const { return CTree::Son (sons, 8, n); }
  CTree *InitStmt () const { return sons[2]; }
  CTree *Condition () const { return sons[3]; }
  CTree *Expr () const { return sons[5]; }
  CT_Statement *Statement () const { return (CT_Statement*)sons[7]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 8, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Condition : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // declspecs, declarator, init

public:
  CT_Condition (CTree *dsl, CTree *d) {
    sons[0] = dsl; sons[1] = d; sons[2] = 0;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  CT_DeclSpecSeq *DeclSpecs () const { return (CT_DeclSpecSeq*)sons[0]; }
  CTree *Declarator () const { return sons[1]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[2]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Initializer (CTree *i) { sons[2] = i; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Classes                                      */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ClassDef : public CT_Decl, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

   
  struct __ac_wrapper_sons {
    typedef ::Puma::CTree * E; typedef E A[4]; A _data;
    operator A& () { return _data; }
    operator A& () const { return (A&)*(::Puma::CTree * *)_data; }
    operator const A& () { return _data; }
    operator const A& () const { return _data; }
    operator void* () { return _data; }
    operator void* () const { return (void*)_data; }
    operator const void* () { return _data; }
    operator const void* () const { return _data; }
    template <typename I> E& operator [] (I i) { return _data[i]; } // for VC++ 2003
    template <typename I> const E& operator [] (I i) const { return _data[i]; } // for VC++ 2003
  } sons; // key, name, bases, members
  CTree *obj_decl;

public:
  

struct TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0 {
  typedef void Result;
  typedef ::Puma::CT_ClassDef That;
  typedef ::Puma::CT_ClassDef Target;
  static const int JPID = 4;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 3 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };
  template <int DUMMY> struct Arg<0, DUMMY> {
    typedef ::Puma::CTree * Type;
    typedef ::Puma::CTree * ReferredType;
  };
  template <int DUMMY> struct Arg<1, DUMMY> {
    typedef ::Puma::CTree * Type;
    typedef ::Puma::CTree * ReferredType;
  };
  template <int DUMMY> struct Arg<2, DUMMY> {
    typedef ::Puma::CTree * Type;
    typedef ::Puma::CTree * ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};

CT_ClassDef (CTree * arg0, CTree * arg1, CTree * arg2 = (CTree*)0) {
  TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0 tjp;
  tjp._that =  (TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0::That*)this;
this->__exec_old_C1(arg0, arg1, arg2);
  AC::invoke_ExtACTree_ExtACTree_a0_after<TJP__ZN4Puma11CT_ClassDefC1EPN4PumaE5CTreePN4PumaE5CTreePN4PumaE5CTree_0> (&tjp);

}
inline void __exec_old_C1(::Puma::CTree * k,::Puma::CTree * n,::Puma::CTree * b){
    sons[0] = k; sons[1] = n; sons[2] = b; sons[3] = 0; obj_decl = 0; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 4); }
  CTree *Son (int n) const { return CTree::Son (sons, 4, n); }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[1]; }
  CT_MembList *Members () const { return (CT_MembList*)sons[3]; }
  CT_BaseSpecList *BaseClasses () const { return (CT_BaseSpecList*)sons[2]; }
  CT_ObjDecl *ObjDecl () const { return (CT_ObjDecl*)obj_decl; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
  void Members (CTree *m) { sons[3] = m; }
  void BaseClasses (CTree *bc) { sons[2] = bc; }
  void ObjDecl (CTree *od) { obj_decl = od; }
  void ReplaceSon (CTree *old_son, CTree *new_son) {
    // &(...) is used here to avoid strange warnings by mingw32-g++
    CTree::ReplaceSon (&(sons[0]), 4, old_son, new_son);
  }
   private:
 CTree * _intro_members ;
public :
CTree * IntroMembers ( ) const { return _intro_members ; }
void IntroMembers ( CTree * members ) { _intro_members = members ; }
struct TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0 {
  typedef void Result;
  typedef ::Puma::CT_ClassDef That;
  typedef ::Puma::CT_ClassDef Target;
  static const int JPID = 4;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 1 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };
  template <int DUMMY> struct Arg<0, DUMMY> {
    typedef const ::Puma::CT_ClassDef & Type;
    typedef const ::Puma::CT_ClassDef ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};


public:
inline CT_ClassDef (const Puma::CT_ClassDef & arg0) : Puma::CT_Decl (arg0), Puma::CSemObject (arg0), sons (arg0.sons), obj_decl (arg0.obj_decl), _intro_members (arg0._intro_members) {
  TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0 tjp;
  tjp._that =  (TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0::That*)this;
  AC::invoke_ExtACTree_ExtACTree_a0_after<TJP__ZN4Puma11CT_ClassDefC1ERKN4PumaE11CT_ClassDef_0> (&tjp);

}

struct TJP__ZN4Puma11CT_ClassDefD1Ev_0 {
  typedef void Result;
  typedef ::Puma::CT_ClassDef That;
  typedef ::Puma::CT_ClassDef Target;
  static const int JPID = 4;
  static const AC::JPType JPTYPE = (AC::JPType)32;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 0 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};


public:
inline ~CT_ClassDef () {
  TJP__ZN4Puma11CT_ClassDefD1Ev_0 tjp;
  tjp._that =  (TJP__ZN4Puma11CT_ClassDefD1Ev_0::That*)this;
  AC::invoke_ExtACTree_ExtACTree_a1_before<TJP__ZN4Puma11CT_ClassDefD1Ev_0> (&tjp);

}
};
      
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UnionDef : public CT_ClassDef {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_UnionDef (CTree *k, CTree *n, CTree *b = 0) : CT_ClassDef (k, n, b) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
      
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembList : public CT_DeclList, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembList (int size = 10, int incr = 10) : 
    CT_DeclList (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembInitList : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_MembInitList (int size = 2) : 
    CT_List (size, 2, CT_List::OPEN) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_MembInit : public CT_Expression, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // name, init

public:
  CT_MembInit (CTree *n, CTree *i) { sons[0] = n; sons[1] = i; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[0]; }
  CT_ExprList *Initializer () const { return (CT_ExprList*)sons[1]; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
   private:
  typedef CT_MembInit CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_MembInit CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BaseSpecList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_BaseSpecList (int size = 2) : 
    CT_List (size, 2, CT_List::OPEN|CT_List::SEPARATORS) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AccessSpec : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // access, colon

public:
  CT_AccessSpec (CTree *a, CTree *c) { sons[0] = a; sons[1] = c; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  int Access () const { return sons[0]->token ()->type (); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_BaseSpec : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // virtual, access, name

public:
  CT_BaseSpec (CTree *v, CTree *a, CTree *n) {
    sons[0] = v; sons[1] = a; sons[2] = n; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  int Access () const { return sons[1]->token ()->type (); }
  CTree *AccessSpec () const { return sons[1]; }
  CTree *Virtual () const { return sons[0]; }
  CT_SimpleName *Name () const { return (CT_SimpleName*)sons[2]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AccessDecl : public CT_Decl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // name, semi_colon

public:
  CT_AccessDecl (CTree *n, CTree *s) { sons[0] = n; sons[1] = s; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  CT_QualName *Member () const { return (CT_QualName*)sons[0]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_UsingDecl : public CT_AccessDecl {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // using, typename

public:
  CT_UsingDecl (CTree *u, CTree *n, CTree *s) : CT_AccessDecl (n, s) {
    sons[0] = u; sons[1] = 0; 
  }
  CT_UsingDecl (CTree *u, CTree *t, CTree *n, CTree *s) : CT_AccessDecl (n, s) {
    sons[0] = u; sons[1] = t; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2) + CT_AccessDecl::Sons (); }
  CTree *Son (int n) const {
    int num = CTree::Sons (sons, 2);
    CTree *result = CTree::Son (sons, 2, n);
    return result ? result : CT_AccessDecl::Son (n-num);
  }
  CTree *Typename () const { return sons[1]; }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
    CT_AccessDecl::ReplaceSon (old_son, new_son);
  }
};

/*****************************************************************************/
/*                                                                           */
/*                              Wildcards                                    */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Any : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[2]; // keyword, extension

public:
  CT_Any (CTree *k, CTree *e = (CTree*)0) { sons[0] = k; sons[1] = e; }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 2); }
  CTree *Son (int n) const { return CTree::Son (sons, 2, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 2, old_son, new_son);
  }
  int AnyType () const { return sons[0]->token ()->type (); }
  CT_AnyExtension *Extension () const { return (CT_AnyExtension*)sons[1]; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AnyList : public CT_Any {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_AnyList (CTree *k, CTree *e = (CTree*)0) : CT_Any (k, e) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AnyExtension : public CTree, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[5]; // open, string, comma, cond, close

public:
  CT_AnyExtension (CTree *o, CTree *n, CTree *co, CTree *c, CTree *cr) {
    sons[0] = o; sons[1] = n; sons[2] = co; sons[3] = c; sons[4] = cr; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 5); }
  CTree *Son (int n) const { return CTree::Son (sons, 5, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 5, old_son, new_son);
  }
  CTree *Condition () const { return sons[3]; }
  CT_Token *String () const { return (CT_Token*)sons[1]; }
  const char *Name () const { 
    return value ? value->StrLiteral ()->String () : (const char*)0; }

  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_AnyCondition : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *sons[3]; // arg1, arg2, arg3

public:
  CT_AnyCondition (CTree *a1, CTree *a2 = (CTree*)0, CTree *a3 = (CTree*)0) {
    sons[0] = a1; sons[1] = a2; sons[2] = a3; 
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 3); }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
};


} // namespace Puma

#endif /* __CTree_h__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
namespace Puma {


class ErrorSink;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CSemDeclSpecs {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;


  // initialization context
  ErrorSink *_err;
  CT_DeclSpecSeq *_dss;
  
  // analysis results:
  // -----------------
  // counters
  int _names;
  int _class_specs;
  int _union_specs;
  int _enum_specs;
  // nodes/objects
  int _prim_map[CT_PrimDeclSpec::NumTypes];
  Token *_prim_token[CT_PrimDeclSpec::NumTypes];
  CT_SimpleName *_name;

  // final results after all checks:
  // -------------------------------
  CTypeInfo *_type;
  bool _def_class, _def_union, _def_enum;

  // analyses the syntax tree nodes of the decl-spec sequence. Return false
  // if an error was detected. 
  public: inline bool __exec_old_analyze_seq();
private:
bool analyze_seq ();
  
  // analyzes the current declaration specifier in the sequence and set some
  // attributes according to the result. Returns false if the specifier type
  // is unknown.
  public: inline bool __exec_old_analyze(::Puma::CTree * spec);
private:
bool analyze (CTree *spec);

  // check functions (used after analyse_seq()
  bool check_prim_decl_specs (bool &have_type);
  public: inline bool __exec_old_check_complex_decl_specs(bool & have_type);
private:
bool check_complex_decl_specs (bool &have_type);  
  bool check_storage_class ();
  public: inline bool __exec_old_check_signed_unsigned();
private:
bool check_signed_unsigned ();
  bool check_long_short (); 
  public: inline bool __exec_old_check_finally();
private:
bool check_finally ();
  
  // type creation code
  public: inline ::Puma::CTypeInfo * __exec_old_create_type();
private:
CTypeInfo *create_type ();
  CTypeInfo *create_qualifiers (CTypeInfo *type);
  
public:
  CSemDeclSpecs (ErrorSink *, CT_DeclSpecSeq *);
  ~CSemDeclSpecs ();

  CTypeInfo *make_type () const;
  CT_DeclSpecSeq *DeclSpecSeq () const;

  bool declared (CT_PrimDeclSpec::Type) const;
  bool defClass () const;
  bool defUnion () const;
  bool defEnum () const;
   private:
 public :
int _typeofs ;
CT_GnuTypeof * _typeof_node ;};

inline CSemDeclSpecs::~CSemDeclSpecs () 
 { if (_type) CTypeInfo::Destroy (_type); }
  
inline CTypeInfo *CSemDeclSpecs::make_type () const 
 { return CTypeInfo::Duplicate (_type); }
inline CT_DeclSpecSeq *CSemDeclSpecs::DeclSpecSeq () const 
 { return _dss; }

inline bool CSemDeclSpecs::declared (CT_PrimDeclSpec::Type as) const 
 { return _prim_map[as] > 0; }

inline bool CSemDeclSpecs::defClass () const
 { return _def_class; }
inline bool CSemDeclSpecs::defUnion () const
 { return _def_union; }
inline bool CSemDeclSpecs::defEnum () const
 { return _def_enum; }


} // namespace Puma

#endif /* __c_sem_decl_specs_h__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CSemDeclSpecs_h__
namespace Puma {
  class CCSyntax;
  class CSyntax;
} // namespace Puma


using namespace Puma;

namespace Puma {
  
  
  
  
  
  
  
  
  
  
}

class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class ExtGnu {
public:
  static ExtGnu *aspectof () {
    static ExtGnu __instance;
    return &__instance;
  }
  static ExtGnu *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;


  // flags to enable/disable certain Gnu features
  bool extended_asm;
  bool extended_cv_qual;
  bool gnu_builtins;
  bool std_hack;
  bool typeof_keyword;
  bool statement_exprs;

  // pointcut definitions
  
  
  
  
  

  // ----------------------------------------------------
  // the Gnu ASM syntax
  // ----------------------------------------------------

  // structural extensions
  
  

  // extended asm statement
  
public: template<class JoinPoint> void __a0_after (JoinPoint *tjp, CSyntax *syntax) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    CTree *&result = *(CTree**)tjp->result ();
    if (extended_asm && !result &&
        ((__JP_That*)syntax)->look_ahead (TOK_ASM) &&
        ((__JP_That*)syntax)->parse (&__JP_That::gnu_asm_def)) {
      result = ((__JP_That*)syntax)->builder().simple_decl ();
    }
  }
private:


  // extended asm statement
  
public: template<class JoinPoint> void __a1_around (JoinPoint *tjp, CSyntax *syn) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (extended_asm)
      *tjp->result () = ((__JP_That*)syn)->gnu_asm_def ();
    else
      tjp->proceed ();
  }
private:


  // ----------------------------------------------------
  // the 'restrict' keyword
  // ----------------------------------------------------

  // extended cv qualifier
  
public: template<class JoinPoint> void __a2_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (extended_cv_qual)
      tjp->that ()->_cv_qual_1.set (TOK_RESTRICT);
  }
private:


  // -------------------------
  // Gnu statement expressions 
  // -------------------------

  // pointcut definitions
  
  

  // structural extensions
  
  
  

  // extended primary expression syntax
  
public: template<class JoinPoint> void __a3_around (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    __JP_That *syntax = tjp->that ();
    if (statement_exprs &&
        ((__JP_That*)syntax)->look_ahead (TOK_OPEN_ROUND) &&
        ((__JP_That*)syntax)->look_ahead (TOK_OPEN_CURLY, 2)) {
      CTree *&result = *(CTree**)tjp->result ();
      ((__JP_That*)syntax)->consume (); // skip the TOK_OPEN_ROUND
      result =
        (((__JP_That*)syntax)->parse (&__JP_That::cmpd_stmt) &&
        ((__JP_That*)syntax)->parse (TOK_CLOSE_ROUND)) ?
        ((__JP_That*)syntax)->builder().gnu_statement_expr () : 0;
    }
    else
      tjp->proceed ();
  }
private:


  // ----------------------
  // TYPEOF keyword support
  // ----------------------

  // structural extensions
  
  
  
  

  // introduce new state into CSemDeclSpecs
  
  

  // syntax extension
  
public: template<class JoinPoint> void __a4_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (typeof_keyword)
      tjp->that ()->_simple_type_spec_1.set (TOK_TYPEOF);
  }
private:

  
public: template<class JoinPoint> void __a5_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    CTree *&result = *(CTree**)tjp->result ();
    if (typeof_keyword && !result && tjp->that ()->look_ahead (TOK_TYPEOF) &&
        tjp->that ()->parse (&__JP_That::gnu_typeof))
      result = tjp->that ()->builder ().simple_type_spec ();
  }
private:

  
public: template<class JoinPoint> void __a6_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    CTree *&result = *(CTree**)tjp->result ();
    if (typeof_keyword && !result && tjp->that ()->look_ahead (TOK_TYPEOF) &&
        tjp->that ()->parse (&__JP_That::gnu_typeof))
      result = tjp->that ()->semantic ().simple_type_spec ();
  }
private:


  // initialize the new state before an analysis starts
  
public: void __a7_before (CSemDeclSpecs &csd) {
    csd._typeofs = 0;
    csd._typeof_node = 0;
  }
private:


  // make the analysis function aware of 'typeof'
  
public: template<class JoinPoint> void __a8_after (JoinPoint *tjp, CSemDeclSpecs &csd, CTree *spec) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    bool &result = *tjp->result ();
    if (!result && spec->NodeName () == CT_GnuTypeof::NodeId ()) {
      csd._typeofs++;      
      csd._typeof_node = (CT_GnuTypeof*)spec;
      result = true;
    }
  }
private:

  
  // make the check functions aware of 'typeof'
  
public: template<class JoinPoint> void __a9_after (JoinPoint *tjp, CSemDeclSpecs &csd, bool &have_type) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    bool &result = *tjp->result ();
    if (result && !have_type && csd._typeofs) {
      have_type = true;
      result    = true;
    }
  }
private:

  
  
public: template<class JoinPoint> void __a10_after (JoinPoint *tjp, CSemDeclSpecs &csd) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    bool &result = *tjp->result ();
    if (result) {
      if ((csd._prim_map[CT_PrimDeclSpec::PDS_SIGNED] || 
           csd._prim_map[CT_PrimDeclSpec::PDS_UNSIGNED]) &&
          csd._typeofs) {
        *csd._err << sev_error << csd._dss->token ()->location () 
                  << "`signed' or `unsigned' invalid for 'typeof'"
                  << endMessage;
        result = false;
      }
    }
  }
private:


  
public: template<class JoinPoint> void __a11_after (JoinPoint *tjp, CSemDeclSpecs &csd) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    bool &result = *tjp->result ();
    if (result && csd._typeofs > 0) {
      *csd._err << sev_error << csd._dss->token ()->location () 
                << "invalid type specified in declaration"
                << endMessage;
      result = false;
    }
  }
private:


  // make the type creation function aware of 'typeof'
  
public: template<class JoinPoint> void __a12_after (JoinPoint *tjp, CSemDeclSpecs &csd) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    CTypeInfo *&result = *tjp->result ();
    if (result->isUndefined () && csd._typeofs) {
      csd._typeofs--;
      if (csd._typeof_node->Type ()) {
        result = CTypeInfo::Duplicate (csd._typeof_node->Type ());
      }
    }
  }
private:

  
  // ----------------------
  // Gnu builtin functions
  // ----------------------

  // structural extensions
  

  
public: template<class JoinPoint> void __a13_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (gnu_builtins)
      tjp->that ()->define_gnu_builtins ();
  }
private:


  // ----------------------------------------------------
  // std hack: if a lookup in 'std' fails, look into '::'
  // ----------------------------------------------------

  
public: template<class JoinPoint> void __a14_before (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (std_hack) {
      CStructure *&scope = *(CStructure**)tjp->arg (0);
      bool &nested = *(bool*)tjp->arg (1);
      if (scope->Parent ()->GlobalScope () &&
          strcmp (scope->Name (), "std") == 0)
        nested = true;
    }
  }
private:

  
  // get the configuration and check whether the GNU mode is enabled
  
public: void __a15_before (Config &config) {
    if (config.Option ("--gnu") || config.Option ("--gnu-2.95")) {
      extended_asm     = true;
      extended_cv_qual = true;
      gnu_builtins     = true;
      typeof_keyword   = true;
      statement_exprs  = true;
    }
    if (config.Option ("--gnu-extended-asm"))
      extended_asm = true;
    if (config.Option ("--gnu-2.95") || config.Option ("--gnu-std-hack"))
      std_hack = true;
  }
private:


protected:
  ExtGnu () : extended_asm (false), extended_cv_qual (false),
    gnu_builtins (false), std_hack (false), typeof_keyword (false),
    statement_exprs (false)
  {}
};
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a0_after (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtGnu::aspectof()->__a0_after (tjp, (Puma::CSyntax *)Arg0::val (tjp));
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a1_around (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtGnu::aspectof()->__a1_around (tjp, (Puma::CSyntax *)Arg0::val (tjp));
  }
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a2_after (JoinPoint *tjp) {
    ::ExtGnu::aspectof()->__a2_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a3_around (JoinPoint *tjp) {
    ::ExtGnu::aspectof()->__a3_around (tjp);
  }
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a4_after (JoinPoint *tjp) {
    ::ExtGnu::aspectof()->__a4_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a5_after (JoinPoint *tjp) {
    ::ExtGnu::aspectof()->__a5_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a6_after (JoinPoint *tjp) {
    ::ExtGnu::aspectof()->__a6_after (tjp);
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a7_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtGnu::aspectof()->__a7_before ((Puma::CSemDeclSpecs &)Arg0::val (tjp));
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a8_after (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    typedef typename Binding::template Arg<1> Arg1;
    ::ExtGnu::aspectof()->__a8_after (tjp, (Puma::CSemDeclSpecs &)Arg0::val (tjp), (Puma::CTree *)Arg1::val (tjp));
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a9_after (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    typedef typename Binding::template Arg<1> Arg1;
    ::ExtGnu::aspectof()->__a9_after (tjp, (Puma::CSemDeclSpecs &)Arg0::val (tjp), (bool &)Arg1::val (tjp));
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a10_after (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtGnu::aspectof()->__a10_after (tjp, (Puma::CSemDeclSpecs &)Arg0::val (tjp));
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a11_after (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtGnu::aspectof()->__a11_after (tjp, (Puma::CSemDeclSpecs &)Arg0::val (tjp));
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a12_after (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtGnu::aspectof()->__a12_after (tjp, (Puma::CSemDeclSpecs &)Arg0::val (tjp));
  }
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a13_after (JoinPoint *tjp) {
    ::ExtGnu::aspectof()->__a13_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_ExtGnu_ExtGnu_a14_before (JoinPoint *tjp) {
    ::ExtGnu::aspectof()->__a14_before (tjp);
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtGnu_ExtGnu_a15_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtGnu::aspectof()->__a15_before ((Puma::Config &)Arg0::val (tjp));
  }
} 



// ----------------------------------------------------
// the Gnu ASM syntax
// ----------------------------------------------------

// add rules to the C Syntax










// extend the C Builder







	


// -------------------------
// Gnu statement expressions 
// -------------------------

// C Builder extension




// C semantic extension


// the necessary #include "..CSemVisitor.h" in CSemExpr.cc will is inserted
// manually (for now)!


// C++ semantic extension


// the necessary #include "..CCSemVisitor.h" in CCSemExpr.cc will is inserted
// manually (for now)!


// ----------------------
// TYPEOF keyword support
// ----------------------

// add rules to the C Syntax for the Gnu Typeof syntax




// add rules to the C Builder for the Gnu Typeof syntax


// builder extension


// C semantic extension




// C++ semantic extension





// ----------------------
// Gnu builtin functions
// ----------------------

// extend the C/C++ semantic





#endif /* __ext_gnu_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __WinAsm__
#define __WinAsm__

/********************************************************/
/* Win asm support aspect                               */
/********************************************************/

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __win_c_tree_h__
#define __win_c_tree_h__

namespace Puma {


// Syntax tree node hierarchy:
class CTree;
class   CT_Statement;
class     CT_AsmBlock;


} // namespace Puma


#ifndef __ac_fwd_ExtACTree__
#define __ac_fwd_ExtACTree__
class ExtACTree;
namespace AC {
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACTree_ExtACTree_a1_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#endif
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTree_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTree_h__
#define __CTree_h__

namespace Puma {


// Syntax tree node hierarchy:
class CTree;
class   CT_Statement;          
class     CT_LabelStmt;
class     CT_IfStmt;
class     CT_IfElseStmt;
class     CT_SwitchStmt;
class     CT_BreakStmt;
class     CT_ExprStmt;
class     CT_WhileStmt;
class     CT_DoStmt;
class     CT_ForStmt;
class     CT_ContinueStmt;
class     CT_ReturnStmt;
class     CT_GotoStmt;
class     CT_DeclStmt;
class     CT_CaseStmt;
class     CT_DefaultStmt;
class     CT_TryStmt;
class   CT_Expression;
class     CT_ThrowExpr;
class     CT_NewExpr;
class     CT_DeleteExpr;
class     CT_ConstructExpr;
class     CT_Integer;
class     CT_Character;
class       CT_WideCharacter;
class     CT_Float;
class     CT_Bool;
class     CT_BracedExpr;
class     CT_BinaryExpr;
class       CT_MembPtrExpr;
class         CT_MembRefExpr;
class     CT_UnaryExpr;
class       CT_PostfixExpr;
class       CT_AddrExpr;
class       CT_DerefExpr;
class     CT_IfThenExpr;
class     CT_CmpdLiteral;
class     CT_IndexExpr;
class     CT_CallExpr;
class     CT_CastExpr;
class     CT_StaticCast;
class       CT_ConstCast;
class       CT_ReintCast;
class       CT_DynamicCast;
class     CT_TypeidExpr;
class     CT_SizeofExpr;
class     CT_MembDesignator;
class     CT_IndexDesignator;
class     CT_ImplicitCast;
class   CT_DeclSpec;
class     CT_PrimDeclSpec;
class     CT_NamedType;
class     CT_ClassSpec;
class       CT_UnionSpec;
class       CT_EnumSpec;
class     CT_ExceptionSpec;
class   CT_Declarator;
class     CT_InitDeclarator;
class     CT_BracedDeclarator;
class     CT_ArrayDeclarator;
class     CT_FctDeclarator;
class     CT_RefDeclarator;
class     CT_PtrDeclarator;
class     CT_MembPtrDeclarator;
class     CT_BitFieldDeclarator;
class   CT_Decl;
class     CT_ObjDecl;
class     CT_ArgDecl;
class     CT_AccessDecl;
class       CT_UsingDecl;
class     CT_FctDef;
class     CT_AsmDef;
class     CT_EnumDef;
class     CT_ClassDef;
class       CT_UnionDef;
class     CT_Enumerator;
class     CT_LinkageSpec;
class     CT_Handler;
class     CT_TemplateDecl;
class     CT_TemplateParamDecl;
class       CT_TypeParamDecl;
class       CT_NonTypeParamDecl;
class     CT_NamespaceDef;
class     CT_NamespaceAliasDef;
class     CT_UsingDirective;
class   CT_List;
class     CT_CmpdStmt;
class     CT_DeclSpecSeq;
class     CT_HandlerSeq;
class     CT_DesignatorSeq;
class     CT_DeclList;
class       CT_Program;
class       CT_ArgDeclList;
class         CT_ArgNameList;
class       CT_ArgDeclSeq;
class       CT_MembList;
class     CT_ExprList;
class     CT_DeclaratorList;
class     CT_BaseSpecList;
class     CT_MembInitList;
class     CT_SimpleName;
class       CT_SpecialName;
class         CT_PrivateName;
class         CT_OperatorName;
class         CT_DestructorName;
class         CT_ConversionName;
class         CT_TemplateName;
class       CT_QualName;
class         CT_RootQualName;
class     CT_String;
class       CT_WideString;
class     CT_TemplateParamList;
class     CT_TemplateArgList;
class   CT_Token;
class   CT_Error;
class   CT_Condition;
class   CT_BaseSpec;
class   CT_AccessSpec;
class   CT_ArrayDelimiter;
class   CT_Any;
class   CT_AnyList;
class   CT_AnyExtension;
class   CT_AnyCondition;


} // namespace Puma

#include "Puma/ErrorSeverity.h"
#include "Puma/CSemObject.h"
#include "Puma/CSemScope.h"
#include "Puma/CSemValue.h"
#include "Puma/CExprValue.h"
#include "Puma/CStrLiteral.h"
#include "Puma/CTypeInfo.h"
#include "Puma/Printable.h"
#include "Puma/CTokens.h"
#include "Puma/Token.h"

#include <iostream>
#include <string.h>
using namespace std;

namespace Puma {


class ErrorStream;
class CObjectInfo;
class CStructure;

/*****************************************************************************/
/*                                                                           */
/*                    S y n t a x  t r e e  n o d e s                        */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  /*DEBUG*/static int alloc;
  /*DEBUG*/static int release;

protected:
  CTree *Son (CTree * const *, int, int) const;
  int Sons (CTree * const *, int) const;
  void ReplaceSon (CTree * const *, int, CTree *, CTree *) const;
  
protected:
  CTree () { /*DEBUG*/alloc++; }

public:
  virtual ~CTree () { /*DEBUG*/release++; }
  virtual int Sons () const = 0;
  virtual CTree *Son (int n) const { return (CTree*)0; }
  virtual const char *NodeName () const = 0;
  virtual Token *token () const;
  virtual Token *end_token () const;
  virtual CT_Token *token_node () const;
  virtual CT_Token *end_token_node () const;
  virtual void ReplaceSon (CTree *, CTree *) {}

public: // semantic information
  virtual CTypeInfo *Type () const { return (CTypeInfo*)0; }
  virtual CExprValue *Value () const { return (CExprValue*)0; }
  
  virtual CSemValue *SemValue () const { return (CSemValue*)0; }
  virtual CSemObject *SemObject () const { return (CSemObject*)0; }
  
public: // node classification function
  virtual CT_SimpleName *IsSimpleName () { return 0; }
  virtual CT_Declarator *IsDeclarator () { return 0; }
   private:
  typedef CTree CCExprResolveCTree;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CTree CExprResolveCTree;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Error : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Token : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Token *_token;
  unsigned long int _number;
  
public:
  CT_Token (Token *t, unsigned long int n = 0) : 
    _token (t), _number (n) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 0; }
  Token *token () const { return _token; }
  Token *end_token () const { return _token; }
  CT_Token *token_node () const { return (CT_Token*)this; }
  CT_Token *end_token_node () const { return (CT_Token*)this; }
  void Number (unsigned long int n) { _number = n; }
  unsigned long int Number () const { return _number; }
  // special new / delete with reusing memory
  void *operator new (size_t);
  void  operator delete (void *);
};

/*****************************************************************************/
/*                                                                           */
/*                              List nodes                                   */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_List : public CTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Array<CTree*> _sons;
  int _properties;

protected:
  CT_List(int size = 5, int incr = 5, int props = 0) : 
    _sons (size, incr), _properties (props) {}

public:
  enum {
    OPEN = 1,         // has a start token like ':' in ":a(1),b(2)"
    CLOSE = 2,
    OPEN_CLOSE = 3,   // has opening and closing delimiters, e.g. '(' ')'
    SEPARATORS = 4,   // the list has separators like ','
    FORCE_EMPTY = 8,  // pretend to be empty, e.g. for "(void)"
    END_SEP = 16,     // has separator after last element, e.g. "a,b,c,"
    NO_LAST_SEP = 32, // no separator before last element, e.g. "(a,b...)"
    INTRO = 64        // has an introduction char, e.g. "=" in "={a,b}"
  };
 
  int Entries () const;
  CTree *Entry (int no) const;
  int Sons () const { return _sons.length (); }
  CTree *Son (int n) const { return _sons.lookup (n); }
  int GetProperties () const { return _properties; }
  void AddProperties (int p) { _properties |= p; }
  void AddSon (CTree *s) { if (s) _sons.append (s); }
  void PrefixSon (CTree *s) { if (s) _sons.prepend (s); }
  void InsertSon (CTree *, CTree *);  // before given son
  void ReplaceSon (CTree *, CTree *);
  void RemoveSon (CTree *);
  void InsertSon (int idx, CTree *s)
   { if (idx <= Sons ()) _sons.insert (idx, s); }
  void ReplaceSon (int idx, CTree *s) 
   { if (idx < Sons ()) _sons[idx] = s; }
  void RemoveSon (int idx) 
   { if (idx < Sons ()) _sons.remove (idx); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_ExprList : public CT_List, public CSemValue, public CSemObject {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_ExprList () { AddProperties (SEPARATORS); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
  CSemObject *SemObject () const { return (CSemObject*)this; }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclaratorList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_EnumeratorList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_EnumeratorList () { AddProperties (SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};
   
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_DeclList (int size = 20, int incr = 20) : CT_List (size, incr) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void Linkage (CT_LinkageSpec *l);
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_DeclSpecSeq : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_CmpdStmt : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_CmpdStmt () { AddProperties (OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_HandlerSeq : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateParamList : public CT_List, public CSemScope {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateParamList () { AddProperties (INTRO | SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_TemplateArgList : public CT_List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_TemplateArgList () { AddProperties (SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

/*****************************************************************************/
/*                                                                           */
/*                              Expressions                                  */
/*                                                                           */
/*****************************************************************************/

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Expression : public CTree, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CT_Expression () {}

public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
   private:
  typedef CT_Expression CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Expression CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_String : public CT_List, public CSemValue {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_String (int size) : CT_List (size, 1) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }

  CTypeInfo *Type () const { return type; }
  CExprValue *Value () const { return value; }
  CSemValue *SemValue () const { return (CSemValue*)this; }
   private:
  typedef CT_String CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_String CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_WideString : public CT_String {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CT_WideString (int size) : CT_String (size) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
   private:
  typedef CT_WideString CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_WideString CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Integer : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Integer (CTree *t) : _value (t) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return _value ? 1 : 0; }
  CTree *Son (int n) const { return (n == 0) ? _value : (CTree*)0; }
  void ReplaceSon (CTree *old_son, CTree *new_son) 
   { if (old_son == _value) _value = new_son; }
   private:
  typedef CT_Integer CCExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CCSemExpr & sem_expr , CTree * base ) ;  private:
  typedef CT_Integer CExprResolveExpr;
 public :
virtual CTypeInfo * resolve ( CSemExpr & sem_expr , CTree * base ) ;};

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CT_Character : public CT_Expression {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTree *_value;  // CT_Token

public:
  CT_Character (CTree *t) : _value (t) {}
  static const char *NodeId ();
  c